/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.geometry;

import com.sun.electric.database.change.Undo;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.EditWindow_;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.MutableTextDescriptor;
import com.sun.electric.database.variable.TextDescriptor;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public abstract class Geometric
extends ElectricObject {
    protected Cell parent;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected Geometric() {
    }

    protected void setParent(Cell parent) {
        this.parent = parent;
    }

    public String describe(boolean withQuotes) {
        return "?";
    }

    public void checkChanging() {
        if (this.parent != null) {
            this.parent.checkChanging();
        }
    }

    public Cell whichCell() {
        return this.parent;
    }

    public int whichMultiPage() {
        int pageNo = 0;
        if (this.parent.isMultiPage()) {
            double cY = this.getBounds().getCenterY();
            pageNo = (int)((cY + 500.0) / 1000.0);
        }
        return pageNo;
    }

    protected boolean isDatabaseObject() {
        return this.parent != null;
    }

    public void getInfo() {
        Rectangle2D visBounds = this.getBounds();
        System.out.println(" Bounds: (" + visBounds.getCenterX() + "," + visBounds.getCenterY() + "), size: " + visBounds.getWidth() + "x" + visBounds.getHeight());
        System.out.println(" Parent: " + this.parent);
        super.getInfo();
    }

    public Cell getParent() {
        return this.parent;
    }

    public String getName() {
        Name name = this.getNameKey();
        return name != null ? name.toString() : null;
    }

    public abstract Name getNameKey();

    public abstract int getDuplicate();

    public boolean setName(String name) {
        if (!$assertionsDisabled && !this.isLinked()) {
            throw new AssertionError();
        }
        Name key = null;
        if (name != null && name.length() > 0) {
            if (name.equals(this.getName())) {
                return false;
            }
            key = Name.findName(name);
        } else {
            if (!this.isUsernamed()) {
                return false;
            }
            key = this.parent.getAutoname(this.getBasename());
        }
        if (Geometric.checkNameKey(key, this.parent, this instanceof NodeInst)) {
            return true;
        }
        if (this.parent.hasTempName(key) && !name.equalsIgnoreCase(this.getName())) {
            System.out.println(this.parent + " already has Geometric with temporary name \"" + name + "\"");
            return true;
        }
        Name oldName = this.getNameKey();
        int oldDuplicate = this.getDuplicate();
        this.lowLevelRename(key, -1);
        Undo.renameGeometric(this, oldName, oldDuplicate);
        return false;
    }

    protected static boolean checkNameKey(Name name, Cell parent, boolean isNode) {
        if (!name.isValid()) {
            System.out.println(parent + ": Invalid name \"" + name + "\" wasn't assigned to " + (isNode ? "node" : "arc") + " :" + Name.checkName(name.toString()));
            return true;
        }
        if (name.isTempname() && name.isBus()) {
            System.out.println(parent + ": Temporary name \"" + name + "\" can't be bus");
            return true;
        }
        if (name.hasEmptySubnames()) {
            if (name.isBus()) {
                System.out.println(parent + ": Name \"" + name + "\" with empty subnames wasn't assigned to " + (isNode ? "node" : "arc"));
            } else {
                System.out.println(parent + ": Cannot assign empty name \"" + name + "\" to " + (isNode ? "node" : "arc"));
            }
            return true;
        }
        return false;
    }

    public abstract void lowLevelRename(Name var1, int var2);

    public abstract Name getBasename();

    public boolean isUsernamed() {
        Name name = this.getNameKey();
        return name != null && !name.isTempname();
    }

    public abstract Rectangle2D getBounds();

    public double getTrueCenterX() {
        return this.getBounds().getCenterX();
    }

    public double getTrueCenterY() {
        return this.getBounds().getCenterY();
    }

    public Point2D getTrueCenter() {
        return new Point2D.Double(this.getTrueCenterX(), this.getTrueCenterY());
    }

    public int numDisplayableVariables(boolean multipleStrings) {
        return super.numDisplayableVariables(multipleStrings) + (this.isUsernamed() ? 1 : 0);
    }

    public int addDisplayableVariables(Rectangle2D rect, Poly[] polys, int start, EditWindow_ wnd, boolean multipleStrings) {
        int numVars = 0;
        if (this.isUsernamed()) {
            double cX = rect.getCenterX();
            double cY = rect.getCenterY();
            String varName = this instanceof NodeInst ? NodeInst.NODE_NAME_TD : ArcInst.ARC_NAME_TD;
            TextDescriptor td = this.getTextDescriptor(varName);
            double offX = td.getXOff();
            double offY = td.getYOff();
            TextDescriptor.Position pos = td.getPos();
            Poly.Type style = pos.getPolyType();
            if (this instanceof NodeInst && (offX != 0.0 || offY != 0.0)) {
                MutableTextDescriptor mtd = new MutableTextDescriptor(td);
                mtd.setOff(0.0, 0.0);
                td = mtd;
                style = Poly.rotateType(style, this);
            }
            Point2D[] pointList = null;
            pointList = style == Poly.Type.TEXTBOX ? Poly.makePoints(rect) : new Point2D.Double[]{new Point2D.Double(cX + offX, cY + offY)};
            polys[start] = new Poly(pointList);
            polys[start].setStyle(style);
            polys[start].setString(this.getName());
            polys[start].setTextDescriptor(td);
            polys[start].setLayer(null);
            polys[start].setName(this.getNameKey());
            numVars = 1;
        }
        return super.addDisplayableVariables(rect, polys, start + numVars, wnd, multipleStrings) + numVars;
    }

    public static boolean objectsTouch(Geometric geom1, Geometric geom2) {
        if (geom1 instanceof NodeInst) {
            if (geom2 instanceof NodeInst) {
                return false;
            }
            Geometric temp = geom1;
            geom1 = geom2;
            geom2 = temp;
        }
        if (!(geom2 instanceof NodeInst)) {
            return false;
        }
        NodeInst ni = (NodeInst)geom2;
        ArcInst ai = (ArcInst)geom1;
        for (int i = 0; i < 2; ++i) {
            if (ai.getPortInst(i).getNodeInst() != ni) continue;
            return true;
        }
        return false;
    }

    static {
        $assertionsDisabled = !Geometric.class.desiredAssertionStatus();
    }
}

