/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt.model.layout.form;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.wb.core.editor.actions.assistant.ILayoutAssistantPage;
import org.eclipse.wb.core.editor.actions.assistant.LayoutAssistantListener;
import org.eclipse.wb.core.model.IAbstractComponentInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.broadcast.ObjectEventListener;
import org.eclipse.wb.draw2d.geometry.Dimension;
import org.eclipse.wb.draw2d.geometry.Rectangle;
import org.eclipse.wb.draw2d.geometry.Transposer;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.gef.policy.layout.absolute.actions.AbstractAlignmentActionsSupport;
import org.eclipse.wb.internal.core.gef.policy.snapping.PlacementUtils;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.core.utils.state.GlobalState;
import org.eclipse.wb.internal.core.utils.ui.TabFactory;
import org.eclipse.wb.internal.swt.gef.policy.layout.form.FormUtils;
import org.eclipse.wb.internal.swt.model.ModelMessages;
import org.eclipse.wb.internal.swt.model.layout.form.FormLayoutInfoImpl;
import org.eclipse.wb.internal.swt.model.layout.form.FormLayoutUtils;
import org.eclipse.wb.internal.swt.model.layout.form.IFormAttachmentInfo;
import org.eclipse.wb.internal.swt.model.layout.form.IFormDataInfo;
import org.eclipse.wb.internal.swt.model.layout.form.IFormLayoutInfo;
import org.eclipse.wb.internal.swt.model.layout.form.LayoutAssistantPageClassic;
import org.eclipse.wb.internal.swt.model.layout.form.WidgetSelectDialog;
import org.eclipse.wb.internal.swt.model.layout.form.actions.AnchorActionsClassic;
import org.eclipse.wb.internal.swt.model.widgets.IControlInfo;

public class FormLayoutInfoImplClassic<C extends IControlInfo>
extends FormLayoutInfoImpl<C> {
    private final IFormLayoutInfo<C> layout;
    private final AnchorActionsClassic<C> anchorActions;
    private final AbstractAlignmentActionsSupport<C> alignmentActions;

    public FormLayoutInfoImplClassic(IFormLayoutInfo<C> layout_) {
        this.layout = layout_;
        this.anchorActions = new AnchorActionsClassic(this);
        this.alignmentActions = new AlignmentsSupport();
        this.layout.addBroadcastListener(new ObjectEventListener(){

            public void addSelectionActions(List<ObjectInfo> objects, List<Object> actions) throws Exception {
                FormLayoutInfoImplClassic.this.alignmentActions.addAlignmentActions(objects, actions);
            }
        });
        this.layout.addBroadcastListener(new LayoutAssistantListener(){

            public void createAssistantPages(List<ObjectInfo> objects, TabFolder folder, List<ILayoutAssistantPage> pages) throws Exception {
                if (!objects.isEmpty()) {
                    for (ObjectInfo object : objects) {
                        if (object.getParent() == FormLayoutInfoImplClassic.this.layout.getComposite()) continue;
                        return;
                    }
                    ArrayList actions = Lists.newArrayList();
                    FormLayoutInfoImplClassic.this.alignmentActions.addAlignmentActions(objects, (List)actions);
                    LayoutAssistantPageClassic page = new LayoutAssistantPageClassic(FormLayoutInfoImplClassic.this.layout, (Composite)folder, objects, actions);
                    TabFactory.item((TabFolder)folder).text("FormLayout").control(page);
                    pages.add(page);
                }
            }
        });
    }

    public IFormAttachmentInfo<C> getAttachment(C control, int side) throws Exception {
        if (this.layout.isManagedObject(control)) {
            IFormAttachmentInfo<C> attachment = this.getAttachment0(control, side);
            return attachment.isVirtual() ? null : attachment;
        }
        return null;
    }

    private IFormAttachmentInfo<C> getAttachment0(C child, int side) throws Exception {
        IFormDataInfo formData = (IFormDataInfo)this.layout.getLayoutData2((IControlInfo)child);
        return formData.getAttachment(side);
    }

    public boolean isLeft(IFormAttachmentInfo<C> attachment) {
        return attachment.getSide().getEngineSide() == 1;
    }

    public boolean isRight(IFormAttachmentInfo<C> attachment) {
        return attachment.getSide().getEngineSide() == 4;
    }

    public boolean isTop(IFormAttachmentInfo<C> attachment) {
        return attachment.getSide().getEngineSide() == 8;
    }

    public boolean isBottom(IFormAttachmentInfo<C> attachment) {
        return attachment.getSide().getEngineSide() == 32;
    }

    public boolean isParentAttachment(IFormAttachmentInfo<C> attachment) {
        return attachment.getControl() == null;
    }

    public boolean isControlAttachment(IFormAttachmentInfo<C> attachment) {
        return !attachment.isVirtual() && attachment.getControl() != null;
    }

    public boolean shouldShowConstraintLine(IFormAttachmentInfo<C> attachment) {
        int oppositeSideAlign;
        IFormAttachmentInfo<C> opposite;
        try {
            opposite = this.getOpposite(attachment);
        }
        catch (Throwable e) {
            throw ReflectionUtils.propagate((Throwable)e);
        }
        if (opposite.isVirtual()) {
            return true;
        }
        int align = attachment.getAlignment();
        if (align != (oppositeSideAlign = opposite.getAlignment())) {
            return true;
        }
        int offset = attachment.getOffset();
        int oppositeOffset = opposite.getOffset();
        return Math.abs(offset) < Math.abs(oppositeOffset);
    }

    public void moveToPercentOffset(C child, int side, int percent, int offset) throws Exception {
        IFormAttachmentInfo<C> attachment = this.getAttachment0(child, side);
        attachment.setControl(null);
        attachment.setNumerator(percent);
        attachment.setDenominator(100);
        attachment.setOffset(offset);
        attachment.write();
        this.rebindOpposite(attachment);
    }

    public void moveToOffset(C child, int side, int parentSize, int offset) throws Exception {
        IFormAttachmentInfo<C> attachment = this.getAttachment0(child, side);
        this.moveToOffset(attachment, parentSize, offset);
    }

    private void moveToOffset(IFormAttachmentInfo<C> attachment, int parentSize, int offset) throws Exception {
        this.bindToParent(attachment, parentSize, offset);
        this.rebindOpposite(attachment);
    }

    public void moveToMargin(C child, int side, int direction, int marginValue) throws Exception {
        IFormAttachmentInfo<C> attachment = this.getAttachment0(child, side);
        attachment.setControl(null);
        attachment.setDenominator(100);
        if (!PlacementUtils.isTrailingSide((int)direction)) {
            attachment.setNumerator(0);
            attachment.setOffset(marginValue);
        } else {
            attachment.setNumerator(100);
            attachment.setOffset(-marginValue);
        }
        attachment.write();
        this.rebindOpposite(attachment);
    }

    public void moveToControl(C child, int side, C target, int alignment, int offset) throws Exception {
        IFormAttachmentInfo<C> attachment = this.getAttachment0(child, side);
        attachment.setControl(target);
        attachment.setOffset(offset);
        attachment.setAlignment(FormLayoutUtils.convertGefSide(alignment));
        attachment.write();
        int thisSide = attachment.getSide().getEngineSide();
        IFormAttachmentInfo<C> opposite = this.getOpposite(attachment);
        if (!opposite.isVirtual()) {
            opposite.setControl(target);
            opposite.setAlignment(FormLayoutUtils.convertGefSide(alignment));
            Rectangle controlBounds = child.getModelBounds();
            int oppositeOffset = attachment.getOffset();
            if (controlBounds != null) {
                int k;
                int n = k = PlacementUtils.isTrailingSide((int)thisSide) ? -1 : 1;
                oppositeOffset = PlacementUtils.isHorizontalSide((int)opposite.getSide().getEngineSide()) ? (oppositeOffset += k * controlBounds.width) : (oppositeOffset += k * controlBounds.height);
            }
            opposite.setOffset(oppositeOffset);
            opposite.write();
        }
    }

    private void bindToParent(IFormAttachmentInfo<C> attachment, int parentSize, int offset) throws Exception {
        int numerator = 0;
        int denominator = 100;
        int oldNumerator = attachment.getNumerator();
        if (oldNumerator == 100) {
            numerator = 100;
            offset = parentSize - offset;
            offset = -offset;
        }
        attachment.setControl(null);
        attachment.setNumerator(numerator);
        attachment.setDenominator(denominator);
        attachment.setOffset(offset);
        attachment.write();
    }

    private void rebindOpposite(IFormAttachmentInfo<C> attachment) throws Exception {
        int thisSide = attachment.getSide().getEngineSide();
        IFormAttachmentInfo<C> opposite = this.getOpposite(attachment);
        if (!opposite.isVirtual()) {
            opposite.setControl(null);
            Rectangle controlBounds = this.getThisControl(attachment).getModelBounds();
            opposite.setNumerator(attachment.getNumerator());
            opposite.setDenominator(attachment.getDenominator());
            if (controlBounds != null) {
                int sign;
                int n = sign = PlacementUtils.isTrailingSide((int)thisSide) ? -1 : 1;
                if (PlacementUtils.isHorizontalSide((int)opposite.getSide().getEngineSide())) {
                    opposite.setOffset(attachment.getOffset() + sign * controlBounds.width);
                } else {
                    opposite.setOffset(attachment.getOffset() + sign * controlBounds.height);
                }
            }
            opposite.write();
        }
    }

    private C getThisControl(IFormAttachmentInfo<C> attachment) {
        return (C)((IControlInfo)attachment.getParent().getParent());
    }

    private IFormAttachmentInfo<C> getOpposite(IFormAttachmentInfo<C> attachment) throws Exception {
        IFormDataInfo formData = (IFormDataInfo)attachment.getParent();
        int oppositeSide = attachment.getSide().getOppositeSide().getEngineSide();
        return formData.getAttachment(oppositeSide);
    }

    public List<C> getAlignControlInfos(C sourceControl, int sourceSide) throws Exception {
        ArrayList list = Lists.newArrayList();
        for (IControlInfo info : this.layout.getControls()) {
            if (this.isRelative(info, sourceControl, sourceSide)) continue;
            list.add(info);
        }
        return list;
    }

    private boolean isRelative(C checkingControl, C refControl, int side) throws Exception {
        HashSet referenced = Sets.newHashSet();
        this.collectReferencedControls(checkingControl, side, referenced);
        return referenced.contains(refControl);
    }

    private void collectReferencedControls(C control, int side, Set<C> referenced) throws Exception {
        if (referenced.contains(control)) {
            return;
        }
        referenced.add(control);
        if (PlacementUtils.isHorizontalSide((int)side)) {
            this.collectReferencedControls0(control, 1, referenced);
            this.collectReferencedControls0(control, 4, referenced);
        } else {
            this.collectReferencedControls0(control, 8, referenced);
            this.collectReferencedControls0(control, 32, referenced);
        }
    }

    private void collectReferencedControls0(C control, int side, Set<C> referenced) throws Exception {
        IFormAttachmentInfo<C> attachment = this.getAttachment0(control, side);
        if (this.isControlAttachment(attachment)) {
            this.collectReferencedControls(attachment.getControl(), side, referenced);
        }
    }

    public void createToOffset(C child, int side, int parentSize, int offset) throws Exception {
        IFormAttachmentInfo<C> attachment = this.getAttachment0(child, side);
        if (PlacementUtils.isTrailingSide((int)side)) {
            this.resizeToOffset(attachment, parentSize, offset);
        } else {
            this.moveToOffset(attachment, parentSize, offset);
        }
    }

    public void createToControl(C child, int side, C targetControl, int targetSide, int offset) throws Exception {
        IFormAttachmentInfo<C> attachment = this.getAttachment0(child, side);
        if (PlacementUtils.isTrailingSide((int)side)) {
            this.resizeToControl(attachment, targetControl, targetSide, offset);
        } else {
            this.moveToControl(child, side, targetControl, targetSide, offset);
        }
    }

    public void createToPercentOffset(C child, int side, int percent, int offset) throws Exception {
        IFormAttachmentInfo<C> attachment = this.getAttachment0(child, side);
        if (PlacementUtils.isTrailingSide((int)side)) {
            this.resizeToPercentOffset(attachment, percent, offset);
        } else {
            this.moveToPercentOffset(child, side, percent, offset);
        }
    }

    public void createToMargin(C child, int side, int direction, int marginValue) throws Exception {
        IFormAttachmentInfo<C> attachment = this.getAttachment0(child, side);
        if (PlacementUtils.isTrailingSide((int)side)) {
            this.resizeToMargin(attachment, direction, marginValue);
        } else {
            this.moveToMargin(child, side, direction, marginValue);
        }
    }

    public void resizeToOffset(IFormAttachmentInfo<C> attachment, int parentDimension, int offset) throws Exception {
        this.bindOppositeToParent(attachment);
        this.bindToParent(attachment, parentDimension, offset);
    }

    private void bindOppositeToParent(IFormAttachmentInfo<C> attachment) throws Exception {
        IFormAttachmentInfo<C> opposite = this.getOpposite(attachment);
        if (opposite.isVirtual()) {
            Rectangle parentBounds = this.getThisControl(attachment).getModelBounds();
            opposite.setDenominator(100);
            if (this.isLeft(attachment)) {
                opposite.setOffset(parentBounds.x + parentBounds.width - FormUtils.getLayoutMarginLeft(this.layout));
            } else if (this.isTop(attachment)) {
                opposite.setOffset(parentBounds.y + parentBounds.height - FormUtils.getLayoutMarginTop(this.layout));
            } else if (this.isRight(attachment)) {
                opposite.setOffset(parentBounds.x - FormUtils.getLayoutMarginLeft(this.layout));
            } else if (this.isBottom(attachment)) {
                opposite.setOffset(parentBounds.y - FormUtils.getLayoutMarginTop(this.layout));
            }
            opposite.write();
        }
    }

    public void resizeToPercentOffset(IFormAttachmentInfo<C> attachment, int percent, int offset) throws Exception {
        this.bindOppositeToParent(attachment);
        attachment.setDenominator(100);
        attachment.setControl(null);
        attachment.setNumerator(percent);
        attachment.setOffset(offset);
        attachment.write();
    }

    public void resizeToMargin(IFormAttachmentInfo<C> attachment, int direction, int marginValue) throws Exception {
        this.bindOppositeToParent(attachment);
        attachment.setDenominator(100);
        attachment.setControl(null);
        if (direction == 1 || direction == 8) {
            attachment.setNumerator(0);
            attachment.setOffset(marginValue);
        } else {
            attachment.setNumerator(100);
            attachment.setDenominator(100);
            attachment.setOffset(-marginValue);
        }
        attachment.write();
    }

    public void resizeToControl(IFormAttachmentInfo<C> attachment, C targetControl, int targetSide, int offset) throws Exception {
        this.bindOppositeToParent(attachment);
        attachment.setControl(targetControl);
        attachment.setOffset(offset);
        attachment.setAlignment(FormLayoutUtils.convertGefSide(targetSide));
        attachment.write();
    }

    public AnchorActionsClassic<C> getAnchorActions() {
        return this.anchorActions;
    }

    public void anchor_delete(C control, int controlSide) throws Exception {
        IFormAttachmentInfo<C> attachment = this.getAttachment0(control, controlSide);
        attachment.delete();
    }

    public void anchor_bindToParent(C control, int controlSide, int parentSide) throws Exception {
        this.layout.anchorToParent(control, controlSide, parentSide);
    }

    public void anchor_bindToParentAsPercent(C control, int controlSide) throws Exception {
        this.layout.anchorToParentAsPercent(control, controlSide);
    }

    public void anchor_bindToControl(C control, int controlSide, int targetSide) throws Exception {
        IFormAttachmentInfo<IControlInfo> attachment = this.getAttachment0(control, controlSide);
        WidgetSelectDialog<C> dialog = new WidgetSelectDialog<C>(DesignerPlugin.getShell(), this.getAlignControlInfos(control, controlSide), ModelMessages.FormLayoutInfoImplClassic_widgetSelect_dialogTitle, ModelMessages.FormLayoutInfoImplClassic_widgetSelect_listTitle, ModelMessages.FormLayoutInfoImplClassic_widgetSelect_name);
        if (dialog.open() != 0) {
            return;
        }
        IControlInfo targetControl = (IControlInfo)dialog.getSelectedWidget();
        Transposer t = new Transposer(!PlacementUtils.isHorizontalSide((int)controlSide));
        Rectangle controlBounds = t.t(control.getModelBounds());
        Rectangle targetBounds = t.t(targetControl.getModelBounds());
        int offset = 0;
        offset = !PlacementUtils.isTrailingSide((int)controlSide) ? (PlacementUtils.isTrailingSide((int)targetSide) ? -(targetBounds.right() - controlBounds.x) : targetBounds.x) : (PlacementUtils.isTrailingSide((int)targetSide) ? -(targetBounds.right() - controlBounds.right()) : controlBounds.right());
        attachment.setOffset(offset);
        attachment.setControl(targetControl);
        attachment.setAlignment(FormLayoutUtils.convertGefSide(targetSide));
        attachment.write();
    }

    private IPreferenceStore getPreferenceStore() {
        return GlobalState.getToolkit().getPreferences();
    }

    private boolean shouldKeepAttachmentsStyle() {
        return this.getPreferenceStore().getBoolean("formLayout.keepAttachmentsStyle");
    }

    private final class AlignmentsSupport
    extends AbstractAlignmentActionsSupport<C> {
        private AlignmentsSupport() {
        }

        protected boolean isComponentInfo(ObjectInfo object) {
            return FormLayoutInfoImplClassic.this.layout.isManagedObject(object);
        }

        protected IAbstractComponentInfo getLayoutContainer() {
            return FormLayoutInfoImplClassic.this.layout.getComposite();
        }

        protected void commandAlignLeft() throws Exception {
            IControlInfo target = (IControlInfo)this.m_components.get(0);
            int x = target.getModelBounds().x - FormUtils.getLayoutMarginLeft(FormLayoutInfoImplClassic.this.layout);
            int clientWidth = ((FormLayoutInfoImplClassic)FormLayoutInfoImplClassic.this).layout.getContainerSize().width;
            for (IControlInfo control : this.m_components) {
                if (target == control) continue;
                int width = control.getModelBounds().width;
                this.copyAttachmentPosition(clientWidth, FormLayoutInfoImplClassic.this.getAttachment0(control, 1), x + width, FormLayoutInfoImplClassic.this.getAttachment0(target, 1), x);
            }
        }

        protected void commandAlignRight() throws Exception {
            IControlInfo target = (IControlInfo)this.m_components.get(0);
            int r = target.getModelBounds().right() - FormUtils.getLayoutMarginLeft(FormLayoutInfoImplClassic.this.layout);
            int clientWidth = ((FormLayoutInfoImplClassic)FormLayoutInfoImplClassic.this).layout.getContainerSize().width;
            for (IControlInfo control : this.m_components) {
                if (target == control) continue;
                int width = control.getModelBounds().width;
                this.copyAttachmentPosition(clientWidth, FormLayoutInfoImplClassic.this.getAttachment0(control, 4), r - width, FormLayoutInfoImplClassic.this.getAttachment0(target, 4), r);
            }
        }

        protected void commandAlignTop() throws Exception {
            IControlInfo target = (IControlInfo)this.m_components.get(0);
            int y = target.getModelBounds().y - FormUtils.getLayoutMarginTop(FormLayoutInfoImplClassic.this.layout);
            int clientHeight = ((FormLayoutInfoImplClassic)FormLayoutInfoImplClassic.this).layout.getContainerSize().height;
            for (IControlInfo control : this.m_components) {
                if (target == control) continue;
                int height = control.getModelBounds().height;
                this.copyAttachmentPosition(clientHeight, FormLayoutInfoImplClassic.this.getAttachment0(control, 8), y + height, FormLayoutInfoImplClassic.this.getAttachment0(target, 8), y);
            }
        }

        protected void commandAlignBottom() throws Exception {
            IControlInfo target = (IControlInfo)this.m_components.get(0);
            int b = target.getModelBounds().bottom() - FormUtils.getLayoutMarginTop(FormLayoutInfoImplClassic.this.layout);
            int clientHeight = ((FormLayoutInfoImplClassic)FormLayoutInfoImplClassic.this).layout.getContainerSize().height;
            for (IControlInfo control : this.m_components) {
                if (target == control) continue;
                int height = control.getModelBounds().height;
                this.copyAttachmentPosition(clientHeight, FormLayoutInfoImplClassic.this.getAttachment0(control, 32), b - height, FormLayoutInfoImplClassic.this.getAttachment0(target, 32), b);
            }
        }

        protected void commandAlignCenterVertically() throws Exception {
            IControlInfo target = (IControlInfo)this.m_components.get(0);
            Rectangle bounds = target.getModelBounds();
            int y = bounds.y - FormUtils.getLayoutMarginTop(FormLayoutInfoImplClassic.this.layout);
            int c = y + bounds.height / 2;
            int clientHeight = ((FormLayoutInfoImplClassic)FormLayoutInfoImplClassic.this).layout.getContainerSize().height;
            for (IControlInfo control : this.m_components) {
                if (target == control) continue;
                int height = control.getModelBounds().height;
                this.setAttachmentPosition(FormLayoutInfoImplClassic.this.getAttachment0(control, 8), clientHeight, c - height / 2);
                this.setAttachmentPosition(FormLayoutInfoImplClassic.this.getAttachment0(control, 32), clientHeight, c + height / 2);
            }
        }

        protected void commandAlignCenterHorizontally() throws Exception {
            IControlInfo target = (IControlInfo)this.m_components.get(0);
            Rectangle bounds = target.getModelBounds();
            int x = bounds.x - FormUtils.getLayoutMarginLeft(FormLayoutInfoImplClassic.this.layout);
            int c = x + bounds.width / 2;
            int clientWidth = ((FormLayoutInfoImplClassic)FormLayoutInfoImplClassic.this).layout.getContainerSize().width;
            for (IControlInfo control : this.m_components) {
                if (target == control) continue;
                int width = control.getModelBounds().width;
                this.setAttachmentPosition(FormLayoutInfoImplClassic.this.getAttachment0(control, 1), clientWidth, c - width / 2);
                this.setAttachmentPosition(FormLayoutInfoImplClassic.this.getAttachment0(control, 4), clientWidth, c + width / 2);
            }
        }

        protected void commandCenterVertically() throws Exception {
            int clientHeight = ((FormLayoutInfoImplClassic)FormLayoutInfoImplClassic.this).layout.getContainerSize().height;
            for (IControlInfo control : this.m_components) {
                int height = control.getModelBounds().height;
                int leftPosition = clientHeight / 2 - height / 2;
                int rightPosition = clientHeight / 2 + height / 2;
                this.setAttachmentPosition(FormLayoutInfoImplClassic.this.getAttachment0(control, 8), clientHeight, leftPosition);
                this.setAttachmentPosition(FormLayoutInfoImplClassic.this.getAttachment0(control, 32), clientHeight, rightPosition);
            }
        }

        protected void commandCenterHorizontally() throws Exception {
            int clientWidth = ((FormLayoutInfoImplClassic)FormLayoutInfoImplClassic.this).layout.getContainerSize().width;
            for (IControlInfo control : this.m_components) {
                int width = control.getModelBounds().width;
                int leftPosition = clientWidth / 2 - width / 2;
                int rightPosition = clientWidth / 2 + width / 2;
                this.setAttachmentPosition(FormLayoutInfoImplClassic.this.getAttachment0(control, 1), clientWidth, leftPosition);
                this.setAttachmentPosition(FormLayoutInfoImplClassic.this.getAttachment0(control, 4), clientWidth, rightPosition);
            }
        }

        protected void commandReplicateWidth() throws Exception {
            IControlInfo target = (IControlInfo)this.m_components.get(0);
            int width = target.getModelBounds().width;
            int clientWidth = ((FormLayoutInfoImplClassic)FormLayoutInfoImplClassic.this).layout.getContainerSize().width;
            for (IControlInfo control : this.m_components) {
                if (target == control) continue;
                int x = control.getModelBounds().x - FormUtils.getLayoutMarginLeft(FormLayoutInfoImplClassic.this.layout);
                this.setAttachmentPosition(FormLayoutInfoImplClassic.this.getAttachment0(control, 1), clientWidth, x);
                this.setAttachmentPosition(FormLayoutInfoImplClassic.this.getAttachment0(control, 4), clientWidth, x + width);
            }
        }

        protected void commandReplicateHeight() throws Exception {
            IControlInfo target = (IControlInfo)this.m_components.get(0);
            int height = target.getModelBounds().height;
            int clientHeight = ((FormLayoutInfoImplClassic)FormLayoutInfoImplClassic.this).layout.getContainerSize().height;
            for (IControlInfo control : this.m_components) {
                if (target == control) continue;
                int y = control.getModelBounds().y - FormUtils.getLayoutMarginTop(FormLayoutInfoImplClassic.this.layout);
                this.setAttachmentPosition(FormLayoutInfoImplClassic.this.getAttachment0(control, 8), clientHeight, y);
                this.setAttachmentPosition(FormLayoutInfoImplClassic.this.getAttachment0(control, 32), clientHeight, y + height);
            }
        }

        protected void commandDistributeSpaceVertically() throws Exception {
            this.distributeSpace(false);
        }

        protected void commandDistributeSpaceHorizontally() throws Exception {
            this.distributeSpace(true);
        }

        private void distributeSpace(boolean isHorizontal) throws Exception {
            int x;
            int space;
            int leadingSide = isHorizontal ? 1 : 8;
            int trailingSide = isHorizontal ? 4 : 32;
            final Transposer t = new Transposer(!isHorizontal);
            int margin = isHorizontal ? FormUtils.getLayoutMarginLeft(FormLayoutInfoImplClassic.this.layout) : FormUtils.getLayoutMarginTop(FormLayoutInfoImplClassic.this.layout);
            ArrayList controlList = Lists.newArrayList((Iterable)this.m_components);
            int clientSize = t.t((Dimension)((FormLayoutInfoImplClassic)FormLayoutInfoImplClassic.this).layout.getContainerSize()).width;
            boolean alternative = DesignerPlugin.isCtrlPressed() && this.m_components.size() > 2;
            int controlsSize = 0;
            for (IAbstractComponentInfo control : this.m_components) {
                controlsSize += t.t((Rectangle)control.getModelBounds()).width;
            }
            Collections.sort(controlList, new Comparator<IAbstractComponentInfo>(){

                @Override
                public int compare(IAbstractComponentInfo o1, IAbstractComponentInfo o2) {
                    return t.t((Rectangle)o1.getModelBounds()).x - t.t((Rectangle)o2.getModelBounds()).x;
                }
            });
            if (alternative) {
                IControlInfo leadingControl = (IControlInfo)controlList.get(0);
                IControlInfo trailingControl = (IControlInfo)controlList.get(controlList.size() - 1);
                Rectangle leadingBounds = t.t(leadingControl.getModelBounds());
                Rectangle trailingBounds = t.t(trailingControl.getModelBounds());
                int totalSize = trailingBounds.right() - leadingBounds.x;
                space = (totalSize - controlsSize) / (controlList.size() - 1);
                x = leadingBounds.x + margin;
            } else {
                x = space = (clientSize - controlsSize) / (controlList.size() + 1);
            }
            int i = 0;
            while (i < controlList.size()) {
                IControlInfo control = (IControlInfo)controlList.get(i);
                int width = t.t((Rectangle)control.getModelBounds()).width;
                if (!alternative || i != 0 && i != controlList.size() - 1) {
                    this.setAttachmentPosition(FormLayoutInfoImplClassic.this.getAttachment0(control, leadingSide), clientSize, x);
                    this.setAttachmentPosition(FormLayoutInfoImplClassic.this.getAttachment0(control, trailingSide), clientSize, x + width);
                }
                x += width;
                x += space;
                ++i;
            }
        }

        private void copyAttachmentPosition(int parentSize, IFormAttachmentInfo<C> target, int oppositeTargetValue, IFormAttachmentInfo<C> source, int sourceValue) throws Exception {
            IFormAttachmentInfo targetOpposite = FormLayoutInfoImplClassic.this.getOpposite(target);
            if (FormLayoutInfoImplClassic.this.shouldKeepAttachmentsStyle() || source.isVirtual()) {
                this.setAttachmentPosition(target, parentSize, sourceValue);
                this.setAttachmentPosition(targetOpposite, parentSize, oppositeTargetValue);
                return;
            }
            boolean virtualTarget = target.isVirtual();
            this.copy(source, target);
            if (virtualTarget) {
                targetOpposite.delete();
            } else if (!targetOpposite.isVirtual()) {
                this.setAttachmentPosition(targetOpposite, parentSize, oppositeTargetValue);
            }
            target.write();
        }

        private void copy(IFormAttachmentInfo<C> source, IFormAttachmentInfo<C> target) {
            if (!source.isVirtual()) {
                if (FormLayoutInfoImplClassic.this.isControlAttachment(source)) {
                    target.setControl(source.getControl());
                    target.setAlignment(source.getAlignment());
                    target.setOffset(source.getOffset());
                } else {
                    target.setNumerator(source.getNumerator());
                    target.setDenominator(source.getDenominator());
                    target.setOffset(source.getOffset());
                }
            }
        }

        private void setAttachmentPosition(IFormAttachmentInfo<C> attachment, int parentSize, int value) throws Exception {
            if (attachment.isParentLeading()) {
                attachment.setOffset(value);
            } else if (attachment.isParentTrailing()) {
                attachment.setOffset(value - parentSize);
            } else if (attachment.isPercentaged()) {
                int percent = (int)((double)value * 100.0 / (double)parentSize);
                attachment.setNumerator(percent);
            } else {
                attachment.setControl(null);
                attachment.setNumerator(0);
                attachment.setOffset(value);
            }
            attachment.write();
        }
    }
}

