/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.variable;

import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrSubstitutor;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.broadcast.JavaEventListener;
import org.eclipse.wb.core.model.broadcast.JavaInfoSetVariable;
import org.eclipse.wb.internal.core.model.variable.AbstractNamedVariableSupport;
import org.eclipse.wb.internal.core.model.variable.EmptyVariableSupport;
import org.eclipse.wb.internal.core.model.variable.VariableSupport;
import org.eclipse.wb.internal.core.utils.StringUtilities;
import org.eclipse.wb.internal.core.utils.jdt.core.CodeUtils;
import org.eclipse.wb.internal.core.utils.state.GlobalState;

public abstract class SyncParentChildVariableNameSupport<T extends JavaInfo> {
    protected final T m_childInfo;
    public static final String TEMPLATE_FOR_DEFAULT = "${defaultName}";

    public SyncParentChildVariableNameSupport(T layoutData) {
        this.m_childInfo = layoutData;
        this.m_childInfo.addBroadcastListener((Object)new JavaInfoSetVariable(){

            @Override
            public void invoke(JavaInfo javaInfo, VariableSupport oldVariable, VariableSupport newVariable) throws Exception {
                if (javaInfo == SyncParentChildVariableNameSupport.this.m_childInfo && oldVariable instanceof EmptyVariableSupport && newVariable instanceof AbstractNamedVariableSupport) {
                    JavaInfo parent = ((JavaInfo)((Object)SyncParentChildVariableNameSupport.this.m_childInfo)).getParentJava();
                    if (!GlobalState.isParsing() && parent != null && parent.getVariableSupport() instanceof AbstractNamedVariableSupport) {
                        SyncParentChildVariableNameSupport.this.setNewName();
                    }
                }
            }
        });
        this.m_childInfo.addBroadcastListener((Object)new JavaEventListener(){

            @Override
            public void variable_setName(AbstractNamedVariableSupport variableSupport, String oldName, String newName) throws Exception {
                JavaInfo parent = ((JavaInfo)((Object)SyncParentChildVariableNameSupport.this.m_childInfo)).getParentJava();
                if (variableSupport.getJavaInfo() == parent && ((JavaInfo)((Object)SyncParentChildVariableNameSupport.this.m_childInfo)).getVariableSupport() instanceof AbstractNamedVariableSupport && parent.getVariableSupport() instanceof AbstractNamedVariableSupport) {
                    SyncParentChildVariableNameSupport.this.setNewName();
                }
            }
        });
    }

    private void setNewName() throws Exception {
        String newName = this.generateName();
        if (newName != null) {
            ((JavaInfo)((Object)this.m_childInfo)).getVariableSupport().setName(newName);
        }
    }

    protected static boolean isValidTemplate(String[] templates, String template) {
        return ArrayUtils.contains((Object[])templates, (Object)template);
    }

    protected String generateName() {
        String template = this.getTemplate();
        if (template.equals(this.getTemplateForDefault()) || StringUtils.isEmpty((String)template)) {
            return null;
        }
        return StrSubstitutor.replace((Object)template, this.getValueMap());
    }

    protected String getTemplateForDefault() {
        return TEMPLATE_FOR_DEFAULT;
    }

    protected abstract String getTemplate();

    protected abstract Map<String, String> getValueMap();

    public String getClassName() {
        return CodeUtils.getShortClass(((JavaInfo)((Object)this.m_childInfo)).getDescription().getComponentClass().getName());
    }

    public String getAcronym() {
        return StringUtilities.extractCamelCaps((String)this.getClassName()).toLowerCase();
    }

    public String getParentName() {
        return ((JavaInfo)((Object)this.m_childInfo)).getParentJava().getVariableSupport().getComponentName();
    }

    public String getParentNameCap() {
        return StringUtils.capitalize((String)this.getParentName());
    }
}

