/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.xsd.participants;

import java.util.List;
import org.eclipse.lemminx.dom.DOMAttr;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.extensions.xsd.utils.XSDUtils;
import org.eclipse.lemminx.services.extensions.IHighlightingParticipant;
import org.eclipse.lemminx.utils.DOMUtils;
import org.eclipse.lemminx.utils.XMLPositionUtility;
import org.eclipse.lsp4j.DocumentHighlight;
import org.eclipse.lsp4j.DocumentHighlightKind;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;

public class XSDHighlightingParticipant
implements IHighlightingParticipant {
    @Override
    public void findDocumentHighlights(DOMNode node, Position position, int offset, List<DocumentHighlight> highlights, CancelChecker cancelChecker) {
        DOMDocument document = node.getOwnerDocument();
        if (!DOMUtils.isXSD(document)) {
            return;
        }
        DOMAttr attr = node.findAttrAt(offset);
        if (attr == null || attr.getNodeAttrValue() == null) {
            return;
        }
        XSDUtils.BindingType bindingType = XSDUtils.getBindingType(attr);
        if (bindingType != XSDUtils.BindingType.NONE) {
            DOMAttr originAttr = attr;
            highlights.add(new DocumentHighlight(XMLPositionUtility.createRange(originAttr.getNodeAttrValue().getStart(), originAttr.getNodeAttrValue().getEnd(), document), DocumentHighlightKind.Read));
            boolean searchInExternalSchema = false;
            XSDUtils.searchXSTargetAttributes(originAttr, bindingType, true, searchInExternalSchema, (targetNamespacePrefix, targetAttr) -> highlights.add(new DocumentHighlight(XMLPositionUtility.createRange(targetAttr.getNodeAttrValue().getStart(), targetAttr.getNodeAttrValue().getEnd(), targetAttr.getOwnerDocument()), DocumentHighlightKind.Write)));
        } else if (XSDUtils.isXSTargetElement(attr.getOwnerElement())) {
            DOMAttr targetAttr2 = attr;
            highlights.add(new DocumentHighlight(XMLPositionUtility.createRange(targetAttr2.getNodeAttrValue().getStart(), targetAttr2.getNodeAttrValue().getEnd(), targetAttr2.getOwnerDocument()), DocumentHighlightKind.Write));
            XSDUtils.searchXSOriginAttributes(targetAttr2, (origin, target) -> highlights.add(new DocumentHighlight(XMLPositionUtility.createRange(origin.getNodeAttrValue().getStart(), origin.getNodeAttrValue().getEnd(), origin.getOwnerDocument()), DocumentHighlightKind.Read)), cancelChecker);
        }
    }
}

