import * as vscode from 'vscode-languageserver-protocol';
import { TagNameCasing, AttrNameCasing, SFCParseResult } from '@vue/language-service';
import { ComponentMeta } from 'vue-component-meta';
export declare namespace GetComponentMeta {
    type ParamsType = vscode.TextDocumentIdentifier;
    type ResponseType = ComponentMeta | null | undefined;
    type ErrorType = never;
    const type: vscode.RequestType<vscode.TextDocumentIdentifier, ResponseType, never>;
}
export declare namespace DetectNameCasingRequest {
    type ParamsType = {
        textDocument: vscode.TextDocumentIdentifier;
    };
    type ResponseType = {
        tag: TagNameCasing[];
        attr: AttrNameCasing[];
    } | null | undefined;
    type ErrorType = never;
    const type: vscode.RequestType<ParamsType, ResponseType, never>;
}
export declare namespace GetConvertTagCasingEditsRequest {
    type ParamsType = {
        textDocument: vscode.TextDocumentIdentifier;
        casing: TagNameCasing;
    };
    type ResponseType = vscode.TextEdit[] | null | undefined;
    type ErrorType = never;
    const type: vscode.RequestType<ParamsType, ResponseType, never>;
}
export declare namespace GetConvertAttrCasingEditsRequest {
    type ParamsType = {
        textDocument: vscode.TextDocumentIdentifier;
        casing: AttrNameCasing;
    };
    type ResponseType = vscode.TextEdit[] | null | undefined;
    type ErrorType = never;
    const type: vscode.RequestType<ParamsType, ResponseType, never>;
}
export declare namespace ParseSFCRequest {
    type ParamsType = string;
    type ResponseType = SFCParseResult;
    type ErrorType = never;
    const type: vscode.RequestType<string, SFCParseResult, never>;
}
//# sourceMappingURL=protocol.d.ts.map