/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.debug.presentation;

import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.model.IDisconnect;
import org.eclipse.debug.core.model.ILineBreakpoint;
import org.eclipse.debug.core.model.ITerminate;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.ISourcePresentation;
import org.eclipse.debug.ui.IValueDetailListener;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.lsp4e.debug.debugmodel.DSPDebugElement;
import org.eclipse.lsp4e.debug.debugmodel.DSPThread;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;

public class DSPDebugModelPresentation
extends LabelProvider
implements IDebugModelPresentation,
IFontProvider {
    private Font italic;

    /*
     * WARNING - void declaration
     */
    public String getText(Object element) {
        DSPDebugElement terminate;
        Object object;
        StringBuilder label = new StringBuilder();
        Object object2 = element;
        if (object2 instanceof DSPThread) {
            void thread;
            DSPThread dSPThread = (DSPThread)((Object)object2);
            DSPThread cfr_ignored_0 = (DSPThread)((Object)object2);
            label.append(NLS.bind((String)"Thread #{0} [{1}]", (Object)thread.getId(), (Object)thread.getName()));
        }
        if (label.length() != 0) {
            object = element;
            if (object instanceof ITerminate) {
                ITerminate iTerminate = (ITerminate)object;
                ITerminate cfr_ignored_1 = (ITerminate)object;
                if (terminate.isTerminated()) {
                    label.insert(0, "<terminated>");
                }
            } else {
                Object object3 = element;
                if (object3 instanceof IDisconnect) {
                    void disconned;
                    IDisconnect iDisconnect = (IDisconnect)object3;
                    IDisconnect cfr_ignored_2 = (IDisconnect)object3;
                    if (disconned.isDisconnected()) {
                        label.insert(0, "<disconnected>");
                    }
                }
            }
        } else {
            label.append(DebugUIPlugin.getDefaultLabelProvider().getText(element));
        }
        if ((object = element) instanceof DSPDebugElement) {
            void debugElement;
            terminate = (DSPDebugElement)((Object)object);
            DSPDebugElement cfr_ignored_3 = (DSPDebugElement)((Object)object);
            if (debugElement.getErrorMessage() != null) {
                label.append(" <error:");
                label.append(debugElement.getErrorMessage());
                label.append('>');
            }
        }
        return label.toString();
    }

    /*
     * WARNING - void declaration
     */
    public Font getFont(Object element) {
        Object object = element;
        if (object instanceof DSPDebugElement) {
            void debugElement;
            DSPDebugElement dSPDebugElement = (DSPDebugElement)((Object)object);
            DSPDebugElement cfr_ignored_0 = (DSPDebugElement)((Object)object);
            if (debugElement.getErrorMessage() != null) {
                return this.italic();
            }
        }
        return null;
    }

    private Font italic() {
        if (this.italic == null) {
            Font dialogFont = JFaceResources.getDialogFont();
            FontData[] fontData = dialogFont.getFontData();
            int i = 0;
            while (i < fontData.length) {
                FontData data = fontData[i];
                data.setStyle(2);
                ++i;
            }
            Display display = DSPDebugModelPresentation.getDisplay();
            this.italic = new Font((Device)display, fontData);
        }
        return this.italic;
    }

    public void dispose() {
        if (this.italic != null) {
            this.italic.dispose();
        }
        super.dispose();
    }

    /*
     * WARNING - void declaration
     */
    public IEditorInput getEditorInput(Object element) {
        Object object = element;
        if (object instanceof ILineBreakpoint) {
            void lineBreakpoint;
            ILineBreakpoint iLineBreakpoint = (ILineBreakpoint)object;
            ILineBreakpoint cfr_ignored_0 = (ILineBreakpoint)object;
            return new FileEditorInput((IFile)lineBreakpoint.getMarker().getResource());
        }
        Object object2 = element;
        if (object2 instanceof IFile) {
            void file;
            IFile iFile = (IFile)object2;
            IFile cfr_ignored_1 = (IFile)object2;
            return new FileEditorInput((IFile)file);
        }
        IFileStore fileStore = EFS.getLocalFileSystem().getStore((IPath)new Path(element.toString()));
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IFile[] files = root.findFilesForLocationURI(fileStore.toURI());
        if (files != null) {
            IFile[] iFileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                IFile file = iFileArray[n2];
                if (file.exists()) {
                    return new FileEditorInput(file);
                }
                ++n2;
            }
        }
        return new FileStoreEditorInput(fileStore);
    }

    /*
     * WARNING - void declaration
     */
    public String getEditorId(IEditorInput input, Object element) {
        String id = null;
        if (input != null) {
            String lid;
            ISourcePresentation sourcePres;
            IEditorDescriptor descriptor = null;
            IEditorInput iEditorInput = input;
            if (iEditorInput instanceof IFileEditorInput) {
                void fileEditorInput;
                IFileEditorInput iFileEditorInput = (IFileEditorInput)iEditorInput;
                IFileEditorInput cfr_ignored_0 = (IFileEditorInput)iEditorInput;
                IFile file = fileEditorInput.getFile();
                descriptor = IDE.getDefaultEditor((IFile)file);
            } else {
                IEditorInput iEditorInput2 = input;
                if (iEditorInput2 instanceof IURIEditorInput) {
                    void uriEditorInput;
                    IURIEditorInput file = (IURIEditorInput)iEditorInput2;
                    IURIEditorInput cfr_ignored_1 = (IURIEditorInput)iEditorInput2;
                    URI uri = uriEditorInput.getURI();
                    try {
                        IFileStore fileStore = EFS.getStore((URI)uri);
                        id = IDE.getEditorDescriptorForFileStore((IFileStore)fileStore, (boolean)false).getId();
                    }
                    catch (CoreException fileStore) {
                        // empty catch block
                    }
                }
            }
            if (id == null) {
                if (descriptor == null) {
                    IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
                    descriptor = registry.getDefaultEditor(input.getName());
                }
                id = "org.eclipse.ui.genericeditor.GenericEditor";
                if (descriptor != null) {
                    id = descriptor.getId();
                }
            }
            if (id == null && element instanceof ILineBreakpoint && (sourcePres = (ISourcePresentation)Platform.getAdapterManager().getAdapter(element, ISourcePresentation.class)) != null && (lid = sourcePres.getEditorId(input, element)) != null) {
                id = lid;
            }
        }
        return id;
    }

    public void setAttribute(String attribute, Object value) {
    }

    public void computeDetail(IValue value, IValueDetailListener listener) {
    }

    public static Display getDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }
}

