/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.preview.adapter.internal.core;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.servlet.ServletContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.preview.adapter.internal.core.PreviewRuntime;
import org.eclipse.wst.server.preview.adapter.internal.core.PreviewServerBehaviour;
import org.eclipse.wst.server.preview.adapter.internal.core.Trace;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.LoggerFactory;

public class PreviewLaunchConfigurationDelegate
extends LaunchConfigurationDelegate {
    private static final String[] REQUIRED_BUNDLE_IDS = new String[]{PreviewLaunchConfigurationDelegate.getBundleForClass(ServletContext.class), PreviewLaunchConfigurationDelegate.getBundleForClass(LoggerFactory.class), "org.eclipse.jetty.http", "org.eclipse.jetty.io", "org.eclipse.jetty.security", "org.eclipse.jetty.server", "org.eclipse.jetty.servlet", "org.eclipse.jetty.util", "org.eclipse.jetty.webapp", "org.eclipse.jetty.xml", "org.apache.aries.spifly.dynamic.bundle", "org.eclipse.wst.server.preview"};
    private static final int CLASSPATH_BIN_INDEX_PREVIEW_SERVER = REQUIRED_BUNDLE_IDS.length - 1;
    private static final String[] fgCandidateJavaFiles = new String[]{"javaw", "javaw.exe", "java", "java.exe", "j9w", "j9w.exe", "j9", "j9.exe"};
    private static final String[] fgCandidateJavaLocations = new String[]{"bin" + File.separatorChar, "jre" + File.separatorChar + "bin" + File.separatorChar};
    private static final String MAIN_CLASS = "org.eclipse.wst.server.preview.internal.PreviewStarter";

    private static String getBundleForClass(Class<?> cls) {
        Bundle bundle = FrameworkUtil.getBundle(cls);
        return String.valueOf(bundle.getSymbolicName()) + ":" + bundle.getVersion();
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        IServer server = ServerUtil.getServer((ILaunchConfiguration)configuration);
        if (server == null) {
            Trace.trace(Trace.FINEST, "Launch configuration could not find server");
            return;
        }
        if (server.shouldPublish() && ServerCore.isAutoPublishing()) {
            server.publish(1, monitor);
        }
        PreviewServerBehaviour previewServer = (PreviewServerBehaviour)((Object)server.loadAdapter(PreviewServerBehaviour.class, null));
        StringBuffer cp = new StringBuffer();
        int size = REQUIRED_BUNDLE_IDS.length;
        int i = 0;
        while (i < size) {
            String[] bundleInfo = REQUIRED_BUNDLE_IDS[i].split(":");
            String version = null;
            if (bundleInfo.length > 1) {
                version = bundleInfo[1];
            }
            Bundle[] bundles = Platform.getBundles((String)bundleInfo[0], (String)version);
            Arrays.sort(bundles, (bundle1, bundle2) -> bundle1.getVersion().compareTo(bundle2.getVersion()));
            Bundle b = bundles[0];
            IPath path = null;
            if (b != null) {
                path = PreviewRuntime.getJarredPluginPath(b);
            }
            if (path == null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.server.preview.adapter", "Could not find required bundle " + REQUIRED_BUNDLE_IDS[i]));
            }
            if (i == CLASSPATH_BIN_INDEX_PREVIEW_SERVER && path.append("bin").toFile().exists()) {
                path = path.append("bin");
            }
            if (i > 0) {
                cp.append(File.pathSeparator);
            }
            cp.append(path.toOSString());
            ++i;
        }
        ArrayList<String> cmds = new ArrayList<String>();
        File java = PreviewLaunchConfigurationDelegate.getJavaExecutable();
        if (java == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.server.preview.adapter", "Could not find JRE executable"));
        }
        cmds.add(java.getAbsolutePath());
        cmds.add("-classpath");
        cmds.add(cp.toString());
        cmds.add(MAIN_CLASS);
        cmds.add(previewServer.getTempDirectory().append("preview.xml").toOSString());
        previewServer.setupLaunch(launch, mode, monitor);
        try {
            String[] cmdLine = new String[cmds.size()];
            cmds.toArray(cmdLine);
            Process p = DebugPlugin.exec((String[])cmdLine, null);
            if (p != null) {
                IProcess pr = DebugPlugin.newProcess((ILaunch)launch, (Process)p, (String)cmdLine[0]);
                pr.setAttribute(IProcess.ATTR_CMDLINE, PreviewLaunchConfigurationDelegate.renderCommandLine(cmdLine));
                launch.addProcess(pr);
                previewServer.addProcessListener(pr);
            }
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Problem creating preview process", e);
        }
    }

    protected static String renderCommandLine(String[] commandLine) {
        if (commandLine.length < 1) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < commandLine.length) {
            buf.append(' ');
            char[] characters = commandLine[i].toCharArray();
            StringBuffer command = new StringBuffer();
            boolean containsSpace = false;
            int j = 0;
            while (j < characters.length) {
                char character = characters[j];
                if (character == '\"') {
                    command.append('\\');
                } else if (character == ' ') {
                    containsSpace = true;
                }
                command.append(character);
                ++j;
            }
            if (containsSpace) {
                buf.append('\"');
                buf.append(command.toString());
                buf.append('\"');
            } else {
                buf.append(command.toString());
            }
            ++i;
        }
        return buf.toString();
    }

    protected static File getJavaExecutable() {
        File javaHome;
        String home = System.getProperty("java.home");
        if (Platform.getOS().equals("macosx")) {
            block18: {
                Process p = null;
                try {
                    try {
                        p = DebugPlugin.exec((String[])new String[]{"/usr/libexec/java_home"}, null, (String[])new String[0]);
                        IProcess process = DebugPlugin.newProcess((ILaunch)new Launch(null, "run", null), (Process)p, (String)"Looking for the user's enabled and preferred JVMs");
                        int i = 0;
                        while (i < 600) {
                            if (process.isTerminated()) break;
                            try {
                                Thread.sleep(50L);
                            }
                            catch (InterruptedException interruptedException) {}
                            ++i;
                        }
                        IStreamsProxy streamsProxy = process.getStreamsProxy();
                        String text = null;
                        if (streamsProxy != null) {
                            text = streamsProxy.getOutputStreamMonitor().getContents().trim();
                        }
                        if (text != null && text.length() > 0) {
                            home = text;
                        }
                    }
                    catch (CoreException coreException) {
                        if (p != null) {
                            p.destroy();
                        }
                        break block18;
                    }
                }
                catch (Throwable throwable) {
                    if (p != null) {
                        p.destroy();
                    }
                    throw throwable;
                }
                if (p != null) {
                    p.destroy();
                }
            }
            if (home == null) {
                home = "/Library/Java/Home";
            }
        }
        try {
            javaHome = new File(home).getCanonicalFile();
        }
        catch (IOException iOException) {
            return null;
        }
        if (!javaHome.exists()) {
            return null;
        }
        return PreviewLaunchConfigurationDelegate.findJavaExecutable(javaHome);
    }

    protected static File findJavaExecutable(File vmInstallLocation) {
        int i = 0;
        while (i < fgCandidateJavaFiles.length) {
            int j = 0;
            while (j < fgCandidateJavaLocations.length) {
                File javaFile = new File(vmInstallLocation, String.valueOf(fgCandidateJavaLocations[j]) + fgCandidateJavaFiles[i]);
                if (javaFile.isFile()) {
                    return javaFile;
                }
                ++j;
            }
            ++i;
        }
        return null;
    }
}

