/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.gitflow.ui.internal.dialogs;

import java.io.IOException;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIIcons;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.swt.graphics.Image;

class DecoratedBranchLabelProvider
extends ColumnLabelProvider {
    private ResourceManager resourceManager = Activator.getDefault().getResourceManager();
    private Repository repository;
    private String prefix;

    public DecoratedBranchLabelProvider(Repository repository, String prefix) {
        this.repository = repository;
        this.prefix = prefix;
    }

    public String getText(Object element) {
        if (element instanceof Ref) {
            String name = ((Ref)element).getName();
            return name.substring(this.prefix.length());
        }
        return super.getText(element);
    }

    public Image getImage(Object element) {
        if (element instanceof Ref) {
            return this.decorateImage((Ref)element);
        }
        return super.getImage(element);
    }

    private Image decorateImage(Ref node) {
        String compareString;
        String branchName;
        String refName = node.getName();
        try {
            branchName = this.repository.getFullBranch();
            compareString = refName;
        }
        catch (IOException e) {
            return UIIcons.getImage((ResourceManager)this.resourceManager, (ImageDescriptor)UIIcons.BRANCH);
        }
        if (compareString.equals(branchName)) {
            return UIIcons.getImage((ResourceManager)this.resourceManager, (ImageDescriptor)UIIcons.CHECKED_OUT_BRANCH);
        }
        return UIIcons.getImage((ResourceManager)this.resourceManager, (ImageDescriptor)UIIcons.BRANCH);
    }
}

