/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.debug.firefox;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.browser.BrowserManager;
import org.eclipse.ui.internal.browser.IBrowserDescriptor;
import org.eclipse.wildwebdeveloper.Activator;
import org.eclipse.wildwebdeveloper.debug.AbstractHTMLDebugDelegate;
import org.eclipse.wildwebdeveloper.debug.MessageUtils;
import org.eclipse.wildwebdeveloper.debug.Messages;

public class FirefoxRunDABDebugDelegate
extends AbstractHTMLDebugDelegate {
    static final String ID = "org.eclipse.wildwebdeveloper.runFirefoxDebug";
    static final String PORT = "port";
    static final String REQUEST = "request";
    static final String PREFERENCES = "preferences";
    static final String TMP_DIRS = "tmpdirs";
    static final String TYPE = "type";
    static final String FIREFOX_EXECUTABLE = "firefoxExecutable";
    static final String PROFILE_DIR = "profileDir";
    static final String RELOAD_ON_CHANGE = "reloadOnChange";
    static final String FILE = "file";

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        File executable;
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put(REQUEST, "launch");
        String firefoxLocation = FirefoxRunDABDebugDelegate.findFirefoxLocation(configuration);
        File file = executable = firefoxLocation != null && !firefoxLocation.isBlank() ? new File(firefoxLocation) : null;
        if (executable == null || !executable.isAbsolute() || !executable.canExecute()) {
            MessageUtils.showBrowserLocationsConfigurationError(Activator.getShell(), configuration, mode, Messages.RuntimeExecutable_Firefox, false);
            return;
        }
        param.put(FIREFOX_EXECUTABLE, firefoxLocation);
        String url = configuration.getAttribute("url", "");
        if (!url.isEmpty()) {
            param.put("url", url);
            File projectDirectory = new File(VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(configuration.getAttribute("org.eclipse.debug.core.ATTR_WORKING_DIRECTORY", "")));
            param.put("webRoot", projectDirectory.getAbsolutePath());
        } else {
            param.put(FILE, VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(configuration.getAttribute("program", "No program path set").trim()));
        }
        param.put(PREFERENCES, "{}");
        param.put(TMP_DIRS, System.getProperty("java.io.tmpdir"));
        param.put(TYPE, "firefox");
        if (configuration.getAttribute(RELOAD_ON_CHANGE, false)) {
            String workspaceDir = configuration.getAttribute("org.eclipse.debug.core.ATTR_WORKING_DIRECTORY", "");
            param.put(RELOAD_ON_CHANGE, workspaceDir);
        }
        File debugAdapter = FirefoxRunDABDebugDelegate.findDebugAdapter();
        super.launchWithParameters(configuration, mode, launch, monitor, param, debugAdapter);
    }

    static File findDebugAdapter() {
        try {
            URL fileURL = FileLocator.toFileURL((URL)FirefoxRunDABDebugDelegate.class.getResource("/node_modules/firefox-debugadapter/adapter.bundle.js"));
            return new File(fileURL.toURI());
        }
        catch (IOException | URISyntaxException e) {
            Status errorStatus = new Status(4, "org.eclipse.wildwebdeveloper", e.getMessage(), (Throwable)e);
            Activator.getDefault().getLog().log((IStatus)errorStatus);
            Display.getDefault().asyncExec(() -> FirefoxRunDABDebugDelegate.lambda$0(e, (IStatus)errorStatus));
            return null;
        }
    }

    public static boolean isFirefox(IBrowserDescriptor desc) {
        return desc != null && (desc.getName().toLowerCase().contains("firefox") || desc.getLocation() != null && desc.getLocation().toLowerCase().contains("firefox"));
    }

    static String findFirefoxLocation(ILaunchConfiguration configuration) {
        List<IBrowserDescriptor> runtimes = BrowserManager.getInstance().getWebBrowsers().stream().filter(FirefoxRunDABDebugDelegate::isFirefox).toList();
        for (IBrowserDescriptor browser : runtimes) {
            String location;
            File executable;
            if (browser.getLocation() == null || !(executable = new File(location = browser.getLocation())).isAbsolute() || !executable.canExecute()) continue;
            return location;
        }
        return null;
    }

    private static /* synthetic */ void lambda$0(Exception exception, IStatus iStatus) {
        int n = ErrorDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Debug error", (String)exception.getMessage(), (IStatus)iStatus);
    }
}

