/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.search;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.search.FieldReferenceMatch;
import org.eclipse.wst.jsdt.core.search.LocalVariableReferenceMatch;
import org.eclipse.wst.jsdt.core.search.MethodReferenceMatch;
import org.eclipse.wst.jsdt.core.search.SearchMatch;
import org.eclipse.wst.jsdt.core.search.SearchParticipant;
import org.eclipse.wst.jsdt.core.search.SearchRequestor;
import org.eclipse.wst.jsdt.internal.ui.search.JavaElementMatch;
import org.eclipse.wst.jsdt.internal.ui.search.JavaSearchResult;

public class NewSearchResultCollector
extends SearchRequestor {
    private JavaSearchResult fSearch;
    private boolean fIgnorePotentials;

    public NewSearchResultCollector(JavaSearchResult search, boolean ignorePotentials) {
        this.fSearch = search;
        this.fIgnorePotentials = ignorePotentials;
    }

    public void acceptSearchMatch(SearchMatch match) throws CoreException {
        IJavaScriptElement enclosingElement = (IJavaScriptElement)match.getElement();
        if (enclosingElement != null) {
            if (this.fIgnorePotentials && match.getAccuracy() == 1) {
                return;
            }
            boolean isWriteAccess = false;
            boolean isReadAccess = false;
            if (match instanceof FieldReferenceMatch) {
                FieldReferenceMatch fieldRef = (FieldReferenceMatch)match;
                isWriteAccess = fieldRef.isWriteAccess();
                isReadAccess = fieldRef.isReadAccess();
            } else if (match instanceof LocalVariableReferenceMatch) {
                LocalVariableReferenceMatch localVarRef = (LocalVariableReferenceMatch)match;
                isWriteAccess = localVarRef.isWriteAccess();
                isReadAccess = localVarRef.isReadAccess();
            }
            boolean isSuperInvocation = false;
            if (match instanceof MethodReferenceMatch) {
                MethodReferenceMatch methodRef = (MethodReferenceMatch)match;
                isSuperInvocation = methodRef.isSuperInvocation();
            }
            this.fSearch.addMatch(new JavaElementMatch(enclosingElement, match.getRule(), match.getOffset(), match.getLength(), match.getAccuracy(), isReadAccess, isWriteAccess, match.isInsideDocComment(), isSuperInvocation));
        }
    }

    public void beginReporting() {
    }

    public void endReporting() {
    }

    public void enterParticipant(SearchParticipant participant) {
    }

    public void exitParticipant(SearchParticipant participant) {
    }
}

