/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ui.viewers.xychart;

import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.tmf.ui.viewers.xychart.AxisRange;
import org.eclipse.tracecompass.tmf.ui.viewers.xychart.IAxis;
import org.eclipse.tracecompass.tmf.ui.viewers.xychart.ITmfChartTimeProvider;

public class TmfXyUiUtils {
    private static final long MIN_WINDOW_SIZE = 1L;
    private static final double ZOOM_FACTOR_AT_X_POSITION = 0.8;
    private static final double ZOOM_FACTOR_SELECTION_CENTERED = 1.5;

    private TmfXyUiUtils() {
    }

    public static void horizontalScroll(ITmfChartTimeProvider viewer, IAxis xAxis, boolean left) {
        if (xAxis == null) {
            return;
        }
        long windowStartTime = viewer.getWindowStartTime();
        long windowsEndTime = viewer.getWindowEndTime();
        long startTime = viewer.getStartTime();
        long endTime = viewer.getEndTime();
        long range = windowsEndTime - windowStartTime;
        if (range <= 0L) {
            return;
        }
        long increment = Math.max(1L, range / 2L);
        if (left) {
            windowStartTime = Math.max(windowStartTime - increment, startTime);
            windowsEndTime = windowStartTime + range;
        } else {
            windowsEndTime = Math.min(windowsEndTime + increment, endTime);
            windowStartTime = windowsEndTime - range;
        }
        viewer.updateWindow(windowStartTime, windowsEndTime);
        xAxis.setRange(new AxisRange(windowStartTime - viewer.getTimeOffset(), windowsEndTime - viewer.getTimeOffset()));
    }

    public static void zoom(ITmfChartTimeProvider viewer, IAxis xAxis, boolean zoomIn, int x) {
        if (xAxis == null) {
            return;
        }
        long newDuration = viewer.getWindowDuration();
        if (newDuration == 0L) {
            return;
        }
        double ratio = 1.0;
        if (zoomIn) {
            ratio = 0.8;
            newDuration = Math.round(0.8 * (double)newDuration);
        } else {
            ratio = 1.25;
            newDuration = (long)Math.ceil((double)newDuration * ratio);
        }
        newDuration = Math.max(1L, newDuration);
        long timeAtXPos = TmfXyUiUtils.limitXDataCoordinate(viewer, xAxis.getDataCoordinate(x)) + viewer.getTimeOffset();
        long newWindowStartTime = timeAtXPos - Math.round(ratio * (double)(timeAtXPos - viewer.getWindowStartTime()));
        long newWindowEndTime = TmfXyUiUtils.validateWindowEndTime(viewer, newWindowStartTime, newWindowStartTime + newDuration);
        newWindowStartTime = TmfXyUiUtils.validateWindowStartTime(viewer, newWindowStartTime);
        viewer.updateWindow(newWindowStartTime, newWindowEndTime);
        xAxis.setRange(new AxisRange(newWindowStartTime - viewer.getTimeOffset(), newWindowEndTime - viewer.getTimeOffset()));
    }

    public static void zoom(ITmfChartTimeProvider viewer, IAxis axis, boolean zoomIn) {
        if (zoomIn) {
            TmfXyUiUtils.zoomIn(viewer, axis);
        } else {
            TmfXyUiUtils.zoomOut(viewer, axis);
        }
    }

    public static long limitXDataCoordinate(@Nullable ITmfChartTimeProvider viewer, double x) {
        if (viewer != null) {
            long windowStartTime = viewer.getWindowStartTime() - viewer.getTimeOffset();
            long windowEndTime = viewer.getWindowEndTime() - viewer.getTimeOffset();
            if (x < (double)windowStartTime) {
                return windowStartTime;
            }
            if (x > (double)windowEndTime) {
                return windowEndTime;
            }
        }
        return (long)x;
    }

    private static void zoomIn(ITmfChartTimeProvider viewer, IAxis chart) {
        long time0;
        long time1;
        IAxis xAxis = chart;
        if (xAxis == null) {
            return;
        }
        long prevTime0 = viewer.getWindowStartTime();
        long prevTime1 = viewer.getWindowEndTime();
        long prevRange = prevTime1 - prevTime0;
        if (prevRange == 0L) {
            return;
        }
        long selTime = (viewer.getSelectionEndTime() + viewer.getSelectionBeginTime()) / 2L;
        if (selTime < prevTime0 || selTime > prevTime1) {
            selTime = (prevTime0 + prevTime1) / 2L;
        }
        if ((time1 = selTime + (long)((double)(prevTime1 - selTime) / 1.5)) - (time0 = selTime - (long)((double)(selTime - prevTime0) / 1.5)) < 1L) {
            time0 = selTime - (selTime - prevTime0) * 1L / prevRange;
            time1 = time0 + 1L;
        }
        time0 = TmfXyUiUtils.validateWindowStartTime(viewer, time0);
        time1 = TmfXyUiUtils.validateWindowEndTime(viewer, time0, time1);
        viewer.updateWindow(time0, time1);
        xAxis.setRange(new AxisRange(time0 - viewer.getTimeOffset(), time1 - viewer.getTimeOffset()));
    }

    private static void zoomOut(ITmfChartTimeProvider viewer, IAxis xAxis) {
        long time0;
        long newInterval;
        if (xAxis == null) {
            return;
        }
        long prevTime0 = viewer.getWindowStartTime();
        long prevTime1 = viewer.getWindowEndTime();
        long selTime = (viewer.getSelectionEndTime() + viewer.getSelectionBeginTime()) / 2L;
        if (selTime < prevTime0 || selTime > prevTime1) {
            selTime = (prevTime0 + prevTime1) / 2L;
        }
        if (prevTime1 - prevTime0 <= 1L) {
            newInterval = 2L;
            time0 = selTime - 1L;
        } else {
            newInterval = (long)Math.ceil((double)(prevTime1 - prevTime0) * 1.5);
            time0 = selTime - (long)Math.ceil((double)(selTime - prevTime0) * 1.5);
        }
        time0 = TmfXyUiUtils.validateWindowStartTime(viewer, Math.max(1L, Math.min(time0, viewer.getEndTime() - newInterval)));
        long time1 = TmfXyUiUtils.validateWindowEndTime(viewer, time0, time0 + newInterval);
        viewer.updateWindow(time0, time1);
        xAxis.setRange(new AxisRange(time0 - viewer.getTimeOffset(), time1 - viewer.getTimeOffset()));
    }

    private static long validateWindowStartTime(ITmfChartTimeProvider viewer, long start) {
        long realStart = start;
        long startTime = viewer.getStartTime();
        long endTime = viewer.getEndTime();
        if (realStart < startTime) {
            realStart = startTime;
        }
        if (realStart > endTime) {
            realStart = endTime;
        }
        return realStart;
    }

    private static long validateWindowEndTime(ITmfChartTimeProvider viewer, long start, long end) {
        long realEnd = end;
        long endTime = viewer.getEndTime();
        if (realEnd > endTime) {
            realEnd = endTime;
        }
        if (realEnd < start + 1L) {
            realEnd = start + 1L;
        }
        return realEnd;
    }
}

