/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.externaltools.internal.model;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.externaltools.internal.model.ExternalToolsImages;
import org.eclipse.ui.externaltools.internal.program.launchConfigurations.ExternalToolsProgramMessages;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public final class ExternalToolsPlugin
extends AbstractUIPlugin
implements ILaunchListener {
    public static final String PLUGIN_ID = "org.eclipse.ui.externaltools";
    public static final IStatus OK_STATUS = new Status(0, "org.eclipse.ui.externaltools", 0, "", null);
    private static ExternalToolsPlugin plugin;
    private IWindowListener fWindowListener;
    private ILaunchManager launchManager;

    public ExternalToolsPlugin() {
        plugin = this;
    }

    public static ExternalToolsPlugin getDefault() {
        return plugin;
    }

    public static IStatus newErrorStatus(String message, Throwable exception) {
        if (message == null) {
            return new Status(4, PLUGIN_ID, 0, "", exception);
        }
        return new Status(4, PLUGIN_ID, 0, message, exception);
    }

    public static CoreException newError(String message, Throwable exception) {
        return new CoreException((IStatus)new Status(4, PLUGIN_ID, 0, message, exception));
    }

    public void log(String message, Throwable exception) {
        IStatus status = ExternalToolsPlugin.newErrorStatus(message, exception);
        this.getLog().log(status);
    }

    public void log(Throwable exception) {
        this.getLog().log(ExternalToolsPlugin.newErrorStatus("Internal error logged from External Tools UI: ", exception));
    }

    public ImageDescriptor getImageDescriptor(String path) {
        try {
            Bundle bundle = ExternalToolsPlugin.getDefault().getBundle();
            URL installURL = bundle.getEntry("/");
            URL url = new URL(installURL, path);
            return ImageDescriptor.createFromURL((URL)url);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow();
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow window = ExternalToolsPlugin.getActiveWorkbenchWindow();
        if (window != null) {
            return window.getActivePage();
        }
        return null;
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow window = ExternalToolsPlugin.getActiveWorkbenchWindow();
        if (window != null) {
            return window.getShell();
        }
        return null;
    }

    public static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    protected ImageRegistry createImageRegistry() {
        return ExternalToolsImages.initializeImageRegistry();
    }

    public void stop(BundleContext context) throws Exception {
        try {
            ExternalToolsImages.disposeImageDescriptorRegistry();
        }
        finally {
            super.stop(context);
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunch[] launches = this.launchManager.getLaunches();
        if (launches.length > 0) {
            if (this.fWindowListener == null) {
                this.fWindowListener = new ProgramLaunchWindowListener();
                PlatformUI.getWorkbench().addWindowListener(this.fWindowListener);
            }
        } else {
            this.launchManager.addLaunchListener((ILaunchListener)this);
        }
    }

    public void launchAdded(ILaunch launch) {
        ILaunchConfiguration launchConfiguration = launch.getLaunchConfiguration();
        if (launchConfiguration != null) {
            try {
                ILaunchConfigurationType launchConfigurationType = launchConfiguration.getType();
                if (launchConfigurationType.getIdentifier().equals("org.eclipse.ui.externaltools.ProgramLaunchConfigurationType") && this.fWindowListener == null) {
                    this.fWindowListener = new ProgramLaunchWindowListener();
                    PlatformUI.getWorkbench().addWindowListener(this.fWindowListener);
                    this.launchManager.removeLaunchListener((ILaunchListener)this);
                }
            }
            catch (CoreException e) {
                this.log(e);
            }
        }
    }

    public void launchChanged(ILaunch launch) {
    }

    public void launchRemoved(ILaunch launch) {
    }

    private class ProgramLaunchWindowListener
    implements IWindowListener {
        private ProgramLaunchWindowListener() {
        }

        public void windowActivated(IWorkbenchWindow window) {
        }

        public void windowDeactivated(IWorkbenchWindow window) {
        }

        public void windowClosed(IWorkbenchWindow window) {
            ILaunch[] launches;
            IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
            if (windows.length > 1) {
                return;
            }
            ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
            ILaunchConfigurationType programType = manager.getLaunchConfigurationType("org.eclipse.ui.externaltools.ProgramLaunchConfigurationType");
            if (programType == null) {
                return;
            }
            ILaunch[] iLaunchArray = launches = manager.getLaunches();
            int n = launches.length;
            int n2 = 0;
            while (n2 < n) {
                block6: {
                    ILaunchConfigurationType configType;
                    ILaunch launch = iLaunchArray[n2];
                    try {
                        ILaunchConfiguration config = launch.getLaunchConfiguration();
                        if (config == null) break block6;
                        configType = config.getType();
                    }
                    catch (CoreException coreException) {
                        break block6;
                    }
                    if (configType.equals(programType) && !launch.isTerminated()) {
                        MessageDialog.openWarning((Shell)window.getShell(), (String)ExternalToolsProgramMessages.ProgramLaunchDelegate_Workbench_Closing_1, (String)ExternalToolsProgramMessages.ProgramLaunchDelegate_The_workbench_is_exiting);
                        break;
                    }
                }
                ++n2;
            }
        }

        public void windowOpened(IWorkbenchWindow window) {
        }
    }
}

