/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.log.viewer.properties;

import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.log.viewer.utils.Messages;
import org.eclipse.titan.log.viewer.utils.ResourcePropertyHandler;

public class PropertyStore
extends PreferenceStore {
    private final IResource resource;
    private final IPreferenceStore workbenchStore;
    private final String pageId;
    private boolean inserting = false;

    public PropertyStore(IResource resource, IPreferenceStore workbenchStore, String pageId) {
        this.resource = resource;
        this.workbenchStore = workbenchStore;
        this.pageId = pageId;
    }

    public void save() throws IOException {
        this.writeProperties();
    }

    public void save(OutputStream out, String header) throws IOException {
        this.writeProperties();
    }

    private void writeProperties() throws IOException {
        String[] preferences = super.preferenceNames();
        for (int i = 0; i < preferences.length; ++i) {
            String propertyKey = preferences[i];
            try {
                ResourcePropertyHandler.setProperty(this.resource, this.pageId, propertyKey, this.getString(propertyKey));
                continue;
            }
            catch (CoreException e) {
                ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
                throw new IOException(Messages.getString("PropertyStore.0") + propertyKey);
            }
        }
    }

    public boolean getDefaultBoolean(String name) {
        return this.workbenchStore.getDefaultBoolean(name);
    }

    public double getDefaultDouble(String name) {
        return this.workbenchStore.getDefaultDouble(name);
    }

    public float getDefaultFloat(String name) {
        return this.workbenchStore.getDefaultFloat(name);
    }

    public int getDefaultInt(String name) {
        return this.workbenchStore.getDefaultInt(name);
    }

    public long getDefaultLong(String name) {
        return this.workbenchStore.getDefaultLong(name);
    }

    public String getDefaultString(String name) {
        return this.workbenchStore.getDefaultString(name);
    }

    public boolean getBoolean(String name) {
        this.insertValue(name);
        return super.getBoolean(name);
    }

    public double getDouble(String name) {
        this.insertValue(name);
        return super.getDouble(name);
    }

    public float getFloat(String name) {
        this.insertValue(name);
        return super.getFloat(name);
    }

    public int getInt(String name) {
        this.insertValue(name);
        return super.getInt(name);
    }

    public long getLong(String name) {
        this.insertValue(name);
        return super.getLong(name);
    }

    public String getString(String name) {
        this.insertValue(name);
        return super.getString(name);
    }

    private synchronized void insertValue(String propertyKey) {
        if (this.inserting) {
            return;
        }
        if (super.contains(propertyKey)) {
            return;
        }
        this.inserting = true;
        String prop = null;
        prop = ResourcePropertyHandler.getProperty(this.resource, this.pageId, propertyKey);
        if (prop == null) {
            prop = this.workbenchStore.getString(propertyKey);
        }
        if (prop != null) {
            this.setValue(propertyKey, prop);
        }
        this.inserting = false;
    }

    public boolean contains(String name) {
        return this.workbenchStore.contains(name);
    }

    public void setToDefault(String name) {
        this.setValue(name, this.getDefaultString(name));
    }

    public boolean isDefault(String name) {
        String defaultValue = this.getDefaultString(name);
        if (defaultValue == null) {
            return false;
        }
        return defaultValue.equals(this.getString(name));
    }
}

