/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.log.viewer.extractors;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Observable;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.titan.common.utils.IOUtils;
import org.eclipse.titan.log.viewer.models.LogFileMetaData;

public abstract class Extractor
extends Observable {
    protected byte[] buffer = null;
    protected long fileSize = 0L;
    protected long filePointer = 0L;
    protected long lineCounter = 0L;
    protected LogFileMetaData logFileMetaData;
    protected int recordNumber = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void extractFromLogFile(LogFileMetaData logFileMetaData, IProgressMonitor pMonitor) throws IOException {
        long monitorStep;
        IProgressMonitor monitor = pMonitor == null ? new NullProgressMonitor() : pMonitor;
        this.logFileMetaData = logFileMetaData;
        File logFile = new File(logFileMetaData.getFilePath());
        monitor.beginTask(logFile.getName() + ": Extracting testcases.", 100);
        long monitorNextTick = monitorStep = logFile.length() / 100L;
        FileInputStream in = null;
        try {
            int lengthRead;
            in = new FileInputStream(logFile);
            this.fileSize = logFile.length();
            this.buffer = new byte[8192];
            int nextChar = 0;
            int startLineIdx = 0;
            int charsInBuffer = lengthRead = in.read(this.buffer, 0, 8192);
            while (lengthRead != -1) {
                boolean foundRecord = false;
                int recordsInBlock = 0;
                while (nextChar < charsInBuffer) {
                    byte aChar = this.buffer[nextChar];
                    if (aChar == 10) {
                        foundRecord = true;
                        ++this.lineCounter;
                        ++recordsInBlock;
                        this.processRow(startLineIdx, nextChar, this.recordNumber);
                        ++this.recordNumber;
                        int recordLength = nextChar - startLineIdx + 1;
                        this.filePointer += (long)recordLength;
                        if (this.filePointer >= monitorNextTick) {
                            monitor.worked(1);
                            monitorNextTick += monitorStep;
                        }
                        startLineIdx = nextChar + 1;
                        if (monitor.isCanceled()) {
                            this.recordNumber = 0;
                            this.filePointer = 0L;
                            return;
                        }
                    }
                    ++nextChar;
                }
                if (!foundRecord) {
                    byte[] oldBuffer = this.buffer;
                    this.buffer = new byte[this.buffer.length * 2];
                    System.arraycopy(oldBuffer, 0, this.buffer, 0, oldBuffer.length);
                    lengthRead = in.read(this.buffer, oldBuffer.length, this.buffer.length - oldBuffer.length);
                    charsInBuffer = oldBuffer.length + lengthRead;
                    continue;
                }
                int lefInBlock = 0;
                if (startLineIdx < charsInBuffer) {
                    lefInBlock = charsInBuffer - startLineIdx;
                    System.arraycopy(this.buffer, startLineIdx, this.buffer, 0, lefInBlock);
                }
                if ((lengthRead = in.read(this.buffer, lefInBlock, this.buffer.length - lefInBlock)) <= 0) continue;
                if (lefInBlock != 0) {
                    startLineIdx = 0;
                    nextChar = lefInBlock;
                } else {
                    startLineIdx = nextChar -= charsInBuffer;
                }
                charsInBuffer = lefInBlock + lengthRead;
            }
            if (startLineIdx < nextChar) {
                ++this.lineCounter;
                this.processRow(startLineIdx, nextChar, this.recordNumber);
                ++this.recordNumber;
                this.filePointer += (long)(nextChar - startLineIdx);
                monitor.done();
            }
            this.processRowsFinished(startLineIdx, nextChar, this.recordNumber);
        }
        finally {
            this.buffer = null;
            IOUtils.closeQuietly((Closeable)in);
        }
    }

    protected abstract void processRow(int var1, int var2, int var3) throws IOException;

    protected abstract void processRowsFinished(int var1, int var2, int var3) throws IOException;

    protected boolean hasValidTimeStamp(int nextChar, int remaining) {
        if (!Character.isDigit(this.buffer[nextChar])) {
            return false;
        }
        switch (this.logFileMetaData.getTimeStampConstant()) {
            case 27: {
                if (remaining < 27) break;
                String time = new String(this.buffer, nextChar, 27);
                return Pattern.matches("[12][0-9]{3}\\/(Jan|Feb|Mar|Apr|May|Jun|Jul|Aug|Sep|Oct|Nov|Dec)\\/([012][0-9]|30|31)\\ ([01][0-9]|2[0-3])\\:[0-5][0-9]\\:[0-5][0-9]\\.[0-9]{6}", time);
            }
            case 15: {
                if (remaining < 15) break;
                String time = new String(this.buffer, nextChar, 15);
                return Pattern.matches("([01][0-9]|2[0-3])\\:[0-5][0-9]\\:[0-5][0-9]\\.[0-9]{6}", time);
            }
            default: {
                String seconds;
                int endPos;
                if (remaining < 8) break;
                boolean foundWhiteSpace = false;
                int lastPos = nextChar + remaining;
                for (endPos = nextChar; endPos < lastPos; ++endPos) {
                    if (!Character.isWhitespace(this.buffer[endPos])) continue;
                    foundWhiteSpace = true;
                    break;
                }
                if (!foundWhiteSpace || !Pattern.matches("(0|[1-9][0-9]*)\\.[0-9]{6}", seconds = new String(this.buffer, nextChar, endPos - nextChar))) break;
                return true;
            }
        }
        return false;
    }

    protected int findPos(char[] ser, int start, int stop) {
        int matchPos = 0;
        for (int ix = start; ix < stop; ++ix) {
            if (this.buffer[ix] == ser[matchPos]) {
                if (++matchPos != ser.length) continue;
                return ix - matchPos;
            }
            matchPos = 0;
        }
        return -1;
    }

    protected boolean contains(char[] ser, int start, int stop) {
        int matchPos = 0;
        for (int ix = start; ix < stop; ++ix) {
            if (this.buffer[ix] == ser[matchPos]) {
                if (++matchPos != ser.length) continue;
                return true;
            }
            matchPos = 0;
        }
        return false;
    }
}

