/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.refactoring.movefunction;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.ILocateableNode;
import org.eclipse.titan.designer.AST.IVisitableNode;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.TTCN3.definitions.Def_Function;
import org.eclipse.titan.designer.AST.TTCN3.definitions.TTCN3Module;
import org.eclipse.titan.designer.AST.TTCN3.definitions.VisibilityModifier;
import org.eclipse.titan.designer.AST.TTCN3.types.ComponentTypeBody;
import org.eclipse.titan.designer.AST.TTCN3.types.Component_Type;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titan.designer.parsers.ProjectSourceParser;
import org.eclipse.titanium.refactoring.movefunction.ChangeCreator;
import org.eclipse.titanium.refactoring.movefunction.FunctionData;
import org.eclipse.titanium.refactoring.movefunction.MoveFunctionMethod;
import org.eclipse.titanium.refactoring.movefunction.MoveFunctionType;

public class MoveFunctionRefactoring
extends Refactoring {
    public static final String PROJECTCONTAINSERRORS = "The project `{0}'' contains errors, which might corrupt the result of the refactoring";
    public static final String PROJECTCONTAINSTTCNPPFILES = "The project `{0}'' contains .ttcnpp files, which might corrupt the result of the refactoring";
    private static final String ONTHEFLYANALAYSISDISABLED = "The on-the-fly analysis is disabled, there is semantic information present to work on";
    private final Set<IProject> projects = new HashSet<IProject>();
    private Module destinationModule;
    private final List<Module> selectedModules = new ArrayList<Module>();
    private final IStructuredSelection structSelection;
    private final MoveFunctionSettings settings;
    private Map<Module, List<FunctionData>> functions;
    private RefactoringStatus result;
    private Object[] affectedObjects;

    public MoveFunctionRefactoring(IStructuredSelection selection, MoveFunctionSettings settings) {
        this.structSelection = selection;
        this.settings = settings;
        for (Object o : selection) {
            if (!(o instanceof IResource)) continue;
            IProject temp = ((IResource)o).getProject();
            this.projects.add(temp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        this.result = new RefactoringStatus();
        try {
            pm.beginTask("Checking preconditions...", 2);
            IPreferencesService prefs = Platform.getPreferencesService();
            if (!prefs.getBoolean("org.eclipse.titan.designer", "org.eclipse.titan.designer.useOnTheFlyParsing", false, null)) {
                this.result.addError(ONTHEFLYANALAYSISDISABLED);
            }
            for (IProject project : this.projects) {
                if (!GlobalParser.hasTtcnppFiles((IResource)project)) continue;
                this.result.addError(MessageFormat.format(PROJECTCONTAINSTTCNPPFILES, project));
            }
            pm.worked(1);
            block6: for (IProject project : this.projects) {
                IMarker[] markers;
                for (IMarker marker : markers = project.findMarkers(null, true, 2)) {
                    if (2 != marker.getAttribute("severity", 2)) continue;
                    this.result.addError(MessageFormat.format(PROJECTCONTAINSERRORS, project));
                    continue block6;
                }
            }
            pm.worked(1);
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
            this.result.addFatalError(e.getMessage());
        }
        finally {
            pm.done();
        }
        return this.result;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return new RefactoringStatus();
    }

    public Object[] getAffectedObjects() {
        return this.affectedObjects;
    }

    public String getName() {
        return "Move function";
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        if (this.structSelection == null) {
            return null;
        }
        CompositeChange cchange = new CompositeChange("MoveFunctionRefactoring");
        boolean first = true;
        for (Map.Entry<Module, List<FunctionData>> entry : this.functions.entrySet()) {
            Change ch;
            ChangeCreator chCreator;
            if (first) {
                chCreator = new ChangeCreator((IFile)entry.getKey().getLocation().getFile(), this.settings, entry.getValue(), this.projects.iterator().next(), new HashMap<Module, List<Module>>());
                chCreator.perform();
                ch = chCreator.getChange();
                if (ch != null) {
                    cchange.add(ch);
                }
                first = false;
                continue;
            }
            chCreator = new ChangeCreator((IFile)entry.getKey().getLocation().getFile(), this.settings, entry.getValue(), this.projects.iterator().next());
            chCreator.perform();
            ch = chCreator.getChange();
            if (ch == null) continue;
            cchange.add(ch);
        }
        return cchange;
    }

    public Map<Module, List<FunctionData>> getModules() {
        if (this.structSelection == null) {
            return null;
        }
        if (this.functions != null) {
            return this.functions;
        }
        for (Object o : this.structSelection) {
            if (!(o instanceof IResource)) continue;
            IResource res = (IResource)o;
            SelectedModulesVisitor vis = new SelectedModulesVisitor();
            try {
                res.accept((IResourceVisitor)vis);
            }
            catch (CoreException e) {
                ErrorReporter.logExceptionStackTrace((String)"Error while processing the selected resources", (Throwable)e);
            }
            this.selectedModules.addAll(vis.getSelectedModules());
        }
        this.functions = new HashMap<Module, List<FunctionData>>();
        for (Module module : this.selectedModules) {
            if (!(module instanceof TTCN3Module)) continue;
            this.functions.put(module, new ArrayList());
        }
        return this.functions;
    }

    public Map<Module, List<FunctionData>> getFunctions() {
        return this.functions;
    }

    public List<FunctionData> selectMovableFunctions(TTCN3Module ttcn3module, SubMonitor progress) {
        if (!this.functions.get(ttcn3module).isEmpty()) {
            return this.functions.get(ttcn3module);
        }
        for (ILocateableNode node : ttcn3module.getDefinitions()) {
            if (node instanceof Def_Function) {
                Def_Function fun = (Def_Function)node;
                if (fun.getVisibilityModifier().equals((Object)VisibilityModifier.Private)) continue;
                ReferenceVisitor refVis = new ReferenceVisitor();
                fun.accept((ASTVisitor)refVis);
                boolean dependent = false;
                for (ILocateableNode node2 : refVis.getLocations()) {
                    Assignment assignment;
                    if (!(node2 instanceof Reference) || (assignment = ((Reference)node2).getRefdAssignment(CompilationTimeStamp.getBaseTimestamp(), false, null)) == null || assignment.isLocal() || !assignment.getMyScope().getModuleScope().equals(fun.getMyScope().getModuleScope())) continue;
                    dependent = true;
                    break;
                }
                if (!dependent) {
                    FunctionData fd = new FunctionData(fun, this.createFunctionBody(fun, (Module)ttcn3module));
                    fd.setModule((Module)ttcn3module);
                    this.functions.get(ttcn3module).add(fd);
                }
            }
            progress.worked(1);
        }
        return this.functions.get(ttcn3module);
    }

    public Map<Module, List<FunctionData>> chooseDestination() {
        for (Map.Entry<Module, List<FunctionData>> entry : this.functions.entrySet()) {
            for (FunctionData fun : entry.getValue()) {
                if (!fun.isToBeMoved() || fun.getRefactoringMethod() != null && !this.settings.isChanged()) continue;
                fun.clearDestinations();
                fun.setRefactoringMethod(this.settings.getMethod());
                List<Module> usedModules = this.collectUsedModules(fun.getDefiniton(), entry.getKey());
                fun.setUsedModules(usedModules);
                if (usedModules.size() > 0) {
                    switch (this.settings.getMethod()) {
                        case LENGTH: {
                            this.chooseModuleByLength(usedModules, fun);
                            this.addUnusedModules(fun, usedModules);
                            break;
                        }
                        case IMPORTS: {
                            this.chooseModuleByImports(usedModules, fun);
                            break;
                        }
                        case LENGTHANDIMPORTS: {
                            this.chooseModuleByLengthAndImports(usedModules, fun);
                            this.addUnusedModules(fun, usedModules);
                        }
                    }
                }
                if (!this.settings.getMethod().equals((Object)MoveFunctionMethod.COMPONENT)) continue;
                this.chooseModuleByComponent(fun);
            }
        }
        this.settings.setChanged(false);
        return this.functions;
    }

    private String createFunctionBody(Def_Function fun, Module module) {
        try {
            IFile file = (IFile)module.getLocation().getFile();
            InputStream istream = file.getContents();
            BufferedReader br = new BufferedReader(new InputStreamReader(istream, file.getCharset()));
            int startOffset = fun.getLocation().getOffset();
            int endOffset = fun.getLocation().getEndOffset();
            br.skip(startOffset);
            char[] contentBuf = new char[endOffset - startOffset];
            br.read(contentBuf, 0, endOffset - startOffset);
            String body2 = new String(contentBuf);
            br.close();
            istream.close();
            return body2;
        }
        catch (CoreException ce) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)ce));
        }
        catch (IOException ioe) {
            ErrorReporter.logExceptionStackTrace((Exception)ioe);
        }
        return "";
    }

    private void chooseModuleByLength(List<Module> usedModules, FunctionData function) {
        List<Module> filteredList = this.filterByExcludedNames(usedModules);
        if (filteredList.size() > 0) {
            Collections.sort(filteredList, new Comparator<Module>(){

                @Override
                public int compare(Module m1, Module m2) {
                    return m1.getLocation().getEndOffset() - m1.getLocation().getOffset() - (m2.getLocation().getEndOffset() - m2.getLocation().getOffset());
                }
            });
            this.destinationModule = filteredList.get(0);
            int destLength = this.destinationModule.getLocation().getEndOffset() - this.destinationModule.getLocation().getOffset();
            for (int i = 1; i < filteredList.size(); ++i) {
                Module m = filteredList.get(i);
                if (this.settings.getExcludedModuleNames() != null && this.settings.getExcludedModuleNames().matcher(m.getIdentifier().getTtcnName()).matches()) continue;
                int moduleLength = m.getLocation().getEndOffset() - m.getLocation().getOffset();
                if (moduleLength == destLength && !m.equals(this.destinationModule)) {
                    function.addDestination(m, 100, -1);
                    continue;
                }
                function.addDestination(m, (int)((double)destLength * 100.0 / (double)moduleLength), -1);
            }
            function.addDestination(this.destinationModule, 100, -1);
        }
    }

    private List<Module> filterByExcludedNames(List<Module> usedModules) {
        ArrayList<Module> filteredList = new ArrayList<Module>();
        for (Module m : usedModules) {
            if (this.settings.getExcludedModuleNames() != null && this.settings.getExcludedModuleNames().matcher(m.getIdentifier().getTtcnName()).matches()) continue;
            filteredList.add(m);
        }
        return filteredList;
    }

    private void chooseModuleByImports(List<Module> usedModules, FunctionData function) {
        List<Module> filteredList = this.filterByExcludedNames(usedModules);
        if (filteredList.size() > 0) {
            List<Map.Entry<Module, Integer>> list = this.countMissingImports(filteredList, function);
            this.destinationModule = list.get(0).getKey();
            int min = list.get(0).getValue();
            function.addDestination(this.destinationModule, 100, min);
            list.remove(0);
            for (Map.Entry<Module, Integer> e : list) {
                if (e.getValue() == min) {
                    function.addDestination(e.getKey(), 100, e.getValue());
                    continue;
                }
                function.addDestination(e.getKey(), (int)((double)min * 100.0 / (double)e.getValue().intValue()), e.getValue());
            }
            List<Module> filteredList2 = this.filterByExcludedNames(this.selectedModules);
            List<Map.Entry<Module, Integer>> list2 = this.countMissingImports(filteredList2, function);
            for (Map.Entry<Module, Integer> e : list2) {
                if (usedModules.contains(e.getKey()) || function.getModule().equals(e.getKey())) continue;
                function.addDestination(e.getKey(), 0, e.getValue());
            }
        }
    }

    private List<Map.Entry<Module, Integer>> countMissingImports(List<Module> usedModules, FunctionData function) {
        HashMap<Module, Integer> importsCounter = new HashMap<Module, Integer>();
        for (Module m : usedModules) {
            if (!(m instanceof TTCN3Module)) continue;
            int counter = 0;
            List imports = ((TTCN3Module)m).getImportedModules();
            for (Module m2 : usedModules) {
                if (m.equals(m2) || !imports.contains(m2)) continue;
                ++counter;
            }
            importsCounter.put(m, usedModules.size() - counter - 1);
        }
        ArrayList<Map.Entry<Module, Integer>> list = new ArrayList<Map.Entry<Module, Integer>>(importsCounter.entrySet());
        Collections.sort(list, new Comparator<Map.Entry<Module, Integer>>(){

            @Override
            public int compare(Map.Entry<Module, Integer> e1, Map.Entry<Module, Integer> e2) {
                return e1.getValue().compareTo(e2.getValue());
            }
        });
        return list;
    }

    private void chooseModuleByLengthAndImports(List<Module> usedModules, FunctionData function) {
        List<Map.Entry<Module, Integer>> list = this.countMissingImports(usedModules, function);
        int leastMissingImports = list.get(0).getValue();
        Collections.sort(list, new Comparator<Map.Entry<Module, Integer>>(){

            @Override
            public int compare(Map.Entry<Module, Integer> m1, Map.Entry<Module, Integer> m2) {
                return m1.getKey().getLocation().getEndOffset() - m1.getKey().getLocation().getOffset() - (m2.getKey().getLocation().getEndOffset() - m2.getKey().getLocation().getOffset());
            }
        });
        Module shortestModule = list.get(0).getKey();
        int shortestLength = shortestModule.getLocation().getEndOffset() - shortestModule.getLocation().getOffset();
        for (Map.Entry<Module, Integer> entry : list) {
            int moduleLength = entry.getKey().getLocation().getEndOffset() - entry.getKey().getLocation().getOffset();
            double value1 = (double)shortestLength / (double)moduleLength;
            double value2 = (double)leastMissingImports / (double)entry.getValue().intValue();
            double value3 = value1 * value2 * 100.0;
            function.addDestination(entry.getKey(), (int)value3, entry.getValue());
        }
    }

    private List<Module> collectUsedModules(Def_Function function, Module ttcn3module) {
        ArrayList<Module> modules = new ArrayList<Module>();
        boolean dependent = false;
        for (Module m : ttcn3module.getImportedModules()) {
            dependent = false;
            if (!(m instanceof TTCN3Module)) continue;
            ReferenceVisitor refVis = new ReferenceVisitor();
            function.accept((ASTVisitor)refVis);
            for (ILocateableNode node2 : refVis.getLocations()) {
                Assignment assignment;
                if (!(node2 instanceof Reference) || (assignment = ((Reference)node2).getRefdAssignment(CompilationTimeStamp.getBaseTimestamp(), false, null)) == null || !assignment.getMyScope().getModuleScope().equals(m)) continue;
                dependent = true;
            }
            if (!dependent) continue;
            modules.add(m);
        }
        return modules;
    }

    public IProject getProject() {
        return this.projects.iterator().next();
    }

    public void chooseModuleByComponent(FunctionData function) {
        Component_Type comp = function.getDefiniton().getRunsOnType(CompilationTimeStamp.getBaseTimestamp());
        if (comp != null) {
            HashMap<Module, Integer> compCounter = new HashMap<Module, Integer>();
            ArrayList<Component_Type> extendedComps = new ArrayList<Component_Type>();
            for (ComponentTypeBody ctb : comp.getComponentBody().getExtensions().getComponentBodies()) {
                if (extendedComps.contains(ctb.getMyType())) continue;
                extendedComps.add(ctb.getMyType());
            }
            for (int i = 0; i < extendedComps.size(); ++i) {
                Component_Type ct = (Component_Type)extendedComps.get(i);
                for (ComponentTypeBody ctb : ct.getComponentBody().getExtensions().getComponentBodies()) {
                    if (extendedComps.contains(ctb.getMyType())) continue;
                    extendedComps.add(ctb.getMyType());
                }
            }
            for (IProject project : this.projects) {
                ProjectSourceParser projectSourceParser = GlobalParser.getProjectSourceParser((IProject)project);
                List<Module> modules = this.filterByExcludedNames(new ArrayList<Module>(projectSourceParser.getModules()));
                for (Module m : modules) {
                    if (m.equals(function.getModule())) continue;
                    ModuleVisitor vis = new ModuleVisitor(comp, extendedComps);
                    m.accept((ASTVisitor)vis);
                    compCounter.put(m, vis.getCounter());
                }
            }
            ArrayList list = new ArrayList(compCounter.entrySet());
            Collections.sort(list, new Comparator<Map.Entry<Module, Integer>>(){

                @Override
                public int compare(Map.Entry<Module, Integer> m1, Map.Entry<Module, Integer> m2) {
                    return -1 * m1.getValue().compareTo(m2.getValue());
                }
            });
            this.destinationModule = (Module)((Map.Entry)list.get(0)).getKey();
            int max = (Integer)((Map.Entry)list.get(0)).getValue();
            if (max > 0) {
                function.addDestination((Module)((Map.Entry)list.get(0)).getKey(), 100, -1);
            } else {
                function.addDestination((Module)((Map.Entry)list.get(0)).getKey(), 0, -1);
            }
            for (int i = 1; i < list.size(); ++i) {
                if ((Integer)((Map.Entry)list.get(i)).getValue() == 0 && !this.selectedModules.contains(((Map.Entry)list.get(i)).getKey())) continue;
                if (max == 0) {
                    function.addDestination((Module)((Map.Entry)list.get(i)).getKey(), 0, -1);
                    continue;
                }
                if ((Integer)((Map.Entry)list.get(i)).getValue() == max) {
                    function.addDestination((Module)((Map.Entry)list.get(i)).getKey(), 100, -1);
                    continue;
                }
                double val = (double)((Integer)((Map.Entry)list.get(i)).getValue()).intValue() / (double)max;
                function.addDestination((Module)((Map.Entry)list.get(i)).getKey(), (int)(val * 100.0), -1);
            }
        }
    }

    public void addUnusedModules(FunctionData fun, List<Module> usedModules) {
        for (Module m : this.selectedModules) {
            if (usedModules.contains(m) || m.equals(fun.getModule())) continue;
            fun.addDestination(m, 0, -1);
        }
    }

    public RefactoringStatus getStatus() {
        return this.result;
    }

    public Map<Module, List<FunctionData>> getDestinations() {
        return this.chooseDestination();
    }

    public MoveFunctionSettings getSettings() {
        return this.settings;
    }

    public static class MoveFunctionSettings {
        private MoveFunctionType type;
        private MoveFunctionMethod method;
        private Pattern excludedModuleNames = null;
        private boolean changed = true;

        public MoveFunctionType getType() {
            return this.type;
        }

        public void setType(MoveFunctionType type) {
            this.type = type;
        }

        public MoveFunctionMethod getMethod() {
            return this.method;
        }

        public boolean isChanged() {
            return this.changed;
        }

        public void setMethod(MoveFunctionMethod method) {
            this.method = method;
        }

        public Pattern getExcludedModuleNames() {
            return this.excludedModuleNames;
        }

        public void setExcludedModuleNames(Pattern excludedModuleNames) {
            this.excludedModuleNames = excludedModuleNames;
        }

        public void setChanged(boolean changed) {
            this.changed = changed;
        }
    }

    private static class ReferenceVisitor
    extends ASTVisitor {
        private final NavigableSet<ILocateableNode> locations = new TreeSet<ILocateableNode>(new LocationComparator());

        ReferenceVisitor() {
        }

        private NavigableSet<ILocateableNode> getLocations() {
            return this.locations;
        }

        public int visit(IVisitableNode node) {
            if (node instanceof Reference) {
                this.locations.add((ILocateableNode)((Reference)node));
            }
            return 3;
        }

        private static class LocationComparator
        implements Comparator<ILocateableNode> {
            private LocationComparator() {
            }

            @Override
            public int compare(ILocateableNode arg0, ILocateableNode arg1) {
                int o1;
                IResource f1;
                IResource f0 = arg0.getLocation().getFile();
                if (!f0.equals((Object)(f1 = arg1.getLocation().getFile()))) {
                    return f0.getFullPath().toString().compareTo(f1.getFullPath().toString());
                }
                int o0 = arg0.getLocation().getOffset();
                return o0 < (o1 = arg1.getLocation().getOffset()) ? -1 : (o0 == o1 ? 0 : 1);
            }
        }
    }

    private static class ModuleVisitor
    extends ASTVisitor {
        private int counter;
        private final Component_Type comp;
        private final List<Component_Type> components;

        public ModuleVisitor(Component_Type comp, List<Component_Type> components) {
            this.comp = comp;
            this.components = components;
            this.counter = 0;
        }

        public int visit(IVisitableNode node) {
            Def_Function fun;
            Component_Type componentType;
            if (node instanceof Def_Function && (componentType = (fun = (Def_Function)node).getRunsOnType(CompilationTimeStamp.getBaseTimestamp())) != null && (componentType.equals(this.comp) || this.components.contains(componentType))) {
                ++this.counter;
            }
            return 3;
        }

        public int getCounter() {
            return this.counter;
        }
    }

    private class SelectedModulesVisitor
    implements IResourceVisitor {
        private final List<Module> selectedModules = new ArrayList<Module>();

        public boolean visit(IResource resource) throws CoreException {
            if (resource instanceof IFile) {
                ProjectSourceParser sourceParser = GlobalParser.getProjectSourceParser((IProject)((IFile)resource).getProject());
                Module module = sourceParser.containedModule((IFile)resource);
                if (module != null) {
                    this.selectedModules.add(module);
                }
                return false;
            }
            return true;
        }

        public List<Module> getSelectedModules() {
            return this.selectedModules;
        }
    }
}

