/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.properties.pages;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.Activator;
import org.eclipse.titan.designer.core.TITANBuilder;
import org.eclipse.titan.designer.parsers.GlobalProjectStructureTracker;
import org.eclipse.titan.designer.properties.PropertyNotificationManager;
import org.eclipse.titan.designer.properties.data.ProjectBuildPropertyData;
import org.eclipse.titan.designer.properties.data.ProjectDocumentHandlingUtility;
import org.eclipse.titan.designer.properties.data.ProjectFileHandler;
import org.eclipse.titan.designer.properties.pages.CodeSplittingTab;
import org.eclipse.titan.designer.properties.pages.ConfigurationManagerControl;
import org.eclipse.titan.designer.properties.pages.InternalMakefileCreationTab;
import org.eclipse.titan.designer.properties.pages.MakeAttributesTab;
import org.eclipse.titan.designer.properties.pages.MakefileCreationTab;
import org.eclipse.titan.designer.wizards.projectFormat.TITANAutomaticProjectExporter;
import org.eclipse.ui.dialogs.PropertyPage;

public final class ProjectBuildPropertyPage
extends PropertyPage {
    public static final String BUILDER_IS_ENABLED = "This TITAN project has the TITAN C++ builder enabled.";
    public static final String BUILDER_IS_NOT_ENABLED = "This TITAN project has the TITAN C++ builder disabled.";
    private Composite pageComposite;
    private Label headLabel;
    private TabFolder makefileOperationsTabFolder;
    private Button generateMakefileButton;
    private static final String GENERATEMAKEFILE_TEXT = "Automatic makefile management";
    private Button generateInternalMakefileButton;
    private Button withoutSymbolicLinksButton;
    private MakefileCreationTab makefileCreationTab;
    private InternalMakefileCreationTab internalMakefileCreationTab;
    private MakeAttributesTab makeAttributesTab;
    private CodeSplittingTab codeSplittingTab;
    private final PreferenceStore tempStorage = new PreferenceStore();
    private IProject projectResource;
    private ConfigurationManagerControl configurationManager;
    private String firstConfiguration;

    public void dispose() {
        this.headLabel.dispose();
        this.generateMakefileButton.dispose();
        this.generateInternalMakefileButton.dispose();
        this.withoutSymbolicLinksButton.dispose();
        this.makefileCreationTab.dispose();
        this.internalMakefileCreationTab.dispose();
        this.makeAttributesTab.dispose();
        this.codeSplittingTab.dispose();
        this.makefileOperationsTabFolder.dispose();
        this.pageComposite.dispose();
        super.dispose();
    }

    protected void copyPropertyStore() {
        if (this.generateMakefileButton == null) {
            return;
        }
        this.copyProjectPersistentProperty("generateMakefile");
        this.copyProjectPersistentProperty("generateInternalMakefile");
        this.copyProjectPersistentProperty("symboliclinklessBuild");
        this.makefileCreationTab.copyPropertyStore(this.projectResource, this.tempStorage);
        this.makeAttributesTab.copyPropertyStore(this.projectResource, this.tempStorage);
        this.internalMakefileCreationTab.copyPropertyStore(this.projectResource, this.tempStorage);
        this.codeSplittingTab.copyPropertyStore(this.projectResource, this.tempStorage);
    }

    protected void copyProjectPersistentProperty(String propertyName) {
        String temp = null;
        try {
            temp = this.projectResource.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", propertyName));
        }
        catch (CoreException ce) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)ce));
        }
        if (temp != null) {
            this.tempStorage.setValue(propertyName, temp);
        }
    }

    protected boolean evaluatePersistentProperty(String propertyName) {
        String actualValue = null;
        String copyValue = null;
        try {
            actualValue = this.projectResource.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", propertyName));
        }
        catch (CoreException ce) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)ce));
        }
        copyValue = this.tempStorage.getString(propertyName);
        return actualValue != null && !actualValue.equals(copyValue) || actualValue == null && copyValue == null;
    }

    public void setVisible(boolean visible) {
        if (!visible) {
            return;
        }
        if (this.configurationManager != null) {
            this.configurationManager.refresh();
        }
        super.setVisible(visible);
    }

    protected void evaluatePropertyStore() {
        boolean configurationChanged;
        boolean removeExecutable = false;
        boolean removeMakefile = false;
        boolean saveXMLStore = false;
        saveXMLStore |= this.evaluatePersistentProperty("generateMakefile");
        saveXMLStore |= this.evaluatePersistentProperty("generateInternalMakefile");
        saveXMLStore |= this.evaluatePersistentProperty("symboliclinklessBuild");
        saveXMLStore |= this.makeAttributesTab.evaluatePropertyStore(this.projectResource, this.tempStorage);
        if (this.internalMakefileCreationTab.evaluatePropertyStore(this.projectResource, this.tempStorage) || this.makefileCreationTab.evaluatePropertyStore(this.projectResource, this.tempStorage) || this.codeSplittingTab.evaluatePropertyStore(this.projectResource, this.tempStorage)) {
            removeMakefile = true;
            removeExecutable = true;
            saveXMLStore = true;
        }
        if (saveXMLStore) {
            removeMakefile = true;
            this.copyPropertyStore();
        }
        boolean bl = configurationChanged = !this.firstConfiguration.equals(this.configurationManager.getActualSelection());
        if (configurationChanged || removeMakefile || removeExecutable) {
            PropertyNotificationManager.firePropertyChange((IResource)this.projectResource);
        }
    }

    public void changeConfiguration(String configuration) {
        this.configurationManager.changeActualConfiguration();
        this.copyPropertyStore();
        this.loadProperties();
        this.updateContents();
        this.checkProperties();
        PropertyNotificationManager.firePropertyChange((IResource)this.projectResource);
    }

    protected Control createContents(Composite parent) {
        this.projectResource = (IProject)this.getElement();
        this.pageComposite = new Composite(parent, 0);
        GridLayout pageCompositeLayout = new GridLayout();
        pageCompositeLayout.numColumns = 1;
        this.pageComposite.setLayout((Layout)pageCompositeLayout);
        GridData pageCompositeGridData = new GridData();
        pageCompositeGridData.horizontalAlignment = 4;
        pageCompositeGridData.verticalAlignment = 4;
        pageCompositeGridData.grabExcessHorizontalSpace = true;
        pageCompositeGridData.grabExcessVerticalSpace = true;
        this.pageComposite.setLayoutData((Object)pageCompositeGridData);
        if (TITANBuilder.isBuilderEnabled(this.projectResource)) {
            this.headLabel = new Label(this.pageComposite, 0);
            this.headLabel.setText(BUILDER_IS_ENABLED);
        } else {
            this.headLabel = new Label(this.pageComposite, 0);
            this.headLabel.setText(BUILDER_IS_NOT_ENABLED);
        }
        try {
            String loadLocation = this.projectResource.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "loadLocation"));
            if (loadLocation == null) {
                this.headLabel.setText(this.headLabel.getText() + "\nWas not yet saved ");
            } else {
                this.headLabel.setText(this.headLabel.getText() + "\nWas loaded from " + loadLocation);
            }
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
        }
        this.configurationManager = new ConfigurationManagerControl(this.pageComposite, this.projectResource);
        this.configurationManager.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ProjectBuildPropertyPage.this.configurationManager.hasConfigurationChanged()) {
                    ProjectBuildPropertyPage.this.changeConfiguration(ProjectBuildPropertyPage.this.configurationManager.getActualSelection());
                }
            }
        });
        this.firstConfiguration = this.configurationManager.getActualSelection();
        this.generateMakefileButton = new Button(this.pageComposite, 32);
        this.generateMakefileButton.setText(GENERATEMAKEFILE_TEXT);
        this.generateMakefileButton.setEnabled(true);
        this.generateMakefileButton.setToolTipText("If this option is set, the build process will refresh the makefile when needed,\notherwise this is the user's responsibility.");
        this.generateMakefileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectBuildPropertyPage.this.updateContents();
            }
        });
        this.generateInternalMakefileButton = new Button(this.pageComposite, 32);
        this.generateInternalMakefileButton.setText("Generate the makefile using the Eclipse internal Makefile generator");
        this.generateInternalMakefileButton.setEnabled(true);
        this.generateInternalMakefileButton.setToolTipText("If this option is set, the build process will refresh the Makefile using the Eclipse internal Makefile generator");
        this.generateInternalMakefileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectBuildPropertyPage.this.updateContents();
            }
        });
        this.withoutSymbolicLinksButton = new Button(this.pageComposite, 32);
        this.withoutSymbolicLinksButton.setText("Don't use symbolic links in the build process (internal only)");
        this.withoutSymbolicLinksButton.setToolTipText("If this option is set, the build process will be run without generating symbolic links for the files");
        this.withoutSymbolicLinksButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectBuildPropertyPage.this.updateContents();
            }
        });
        this.updateSymlinkLessbuild(this.generateMakefileButton.getEnabled());
        this.makefileOperationsTabFolder = new TabFolder(this.pageComposite, 2048);
        GridData makefileOperationsTabFolderGridData = new GridData();
        makefileOperationsTabFolderGridData.horizontalAlignment = 4;
        makefileOperationsTabFolderGridData.verticalAlignment = 4;
        makefileOperationsTabFolderGridData.grabExcessHorizontalSpace = true;
        makefileOperationsTabFolderGridData.grabExcessVerticalSpace = true;
        this.makefileOperationsTabFolder.setLayoutData((Object)makefileOperationsTabFolderGridData);
        this.makefileCreationTab = new MakefileCreationTab(this.projectResource, this);
        this.makefileCreationTab.createContents(this.makefileOperationsTabFolder);
        this.internalMakefileCreationTab = new InternalMakefileCreationTab(this.projectResource);
        this.internalMakefileCreationTab.createContents(this.makefileOperationsTabFolder);
        this.internalMakefileCreationTab.setMakefileGenerationEnabled(this.generateInternalMakefileButton.getSelection());
        this.makeAttributesTab = new MakeAttributesTab(this.projectResource, this);
        this.makeAttributesTab.createContents(this.makefileOperationsTabFolder);
        this.codeSplittingTab = new CodeSplittingTab(this.projectResource, this);
        this.codeSplittingTab.createContents(this.makefileOperationsTabFolder);
        this.codeSplittingTab.setMakefileGenerationEnabled(this.generateInternalMakefileButton.getSelection());
        this.copyPropertyStore();
        this.loadProperties();
        this.updateContents();
        this.checkProperties();
        return this.pageComposite;
    }

    private void updateSymlinkLessbuild(boolean enabled) {
        this.withoutSymbolicLinksButton.setEnabled(enabled);
        if (enabled) {
            this.withoutSymbolicLinksButton.setText("Don't use symbolic links in the build process");
        } else {
            this.withoutSymbolicLinksButton.setText("Don't use symbolic links in the build process (internal only)");
        }
    }

    protected void updateContents() {
        if (this.generateMakefileButton == null || this.generateInternalMakefileButton == null || this.withoutSymbolicLinksButton == null) {
            return;
        }
        if (this.generateMakefileButton.getSelection()) {
            this.generateInternalMakefileButton.setEnabled(true);
            this.makefileCreationTab.setMakefileGenerationEnabled(true);
            this.internalMakefileCreationTab.setMakefileGenerationEnabled(this.generateInternalMakefileButton.getSelection());
            this.makeAttributesTab.setMakefileGenerationEnabled(true);
            this.codeSplittingTab.setMakefileGenerationEnabled(true);
            this.updateSymlinkLessbuild(true);
        } else {
            this.makefileCreationTab.setMakefileGenerationEnabled(false);
            this.internalMakefileCreationTab.setMakefileGenerationEnabled(false);
            this.makeAttributesTab.setMakefileGenerationEnabled(false);
            this.generateInternalMakefileButton.setEnabled(false);
            this.codeSplittingTab.setMakefileGenerationEnabled(false);
            this.updateSymlinkLessbuild(false);
        }
    }

    protected void performDefaults() {
        if (this.generateMakefileButton == null) {
            return;
        }
        this.makefileCreationTab.performDefaults();
        this.internalMakefileCreationTab.performDefaults();
        this.makeAttributesTab.performDefaults();
        this.codeSplittingTab.performDefaults();
        this.generateMakefileButton.setSelection(true);
        this.generateInternalMakefileButton.setEnabled(true);
        this.generateInternalMakefileButton.setSelection(true);
        this.updateSymlinkLessbuild(true);
        this.withoutSymbolicLinksButton.setSelection(true);
        this.configurationManager.saveActualConfiguration();
    }

    public boolean performOk() {
        if (!this.checkProperties()) {
            return false;
        }
        if (!this.saveProperties()) {
            return false;
        }
        IPreferenceStore pluginPreferenceStore = Activator.getDefault().getPreferenceStore();
        if (!pluginPreferenceStore.isDefault("org.eclipse.titan.designer.temporalTargetExecutable")) {
            pluginPreferenceStore.setToDefault("org.eclipse.titan.designer.temporalTargetExecutable");
        }
        if (!pluginPreferenceStore.isDefault("org.eclipse.titan.designer.temporalMakefileUpdateScript")) {
            pluginPreferenceStore.setToDefault("org.eclipse.titan.designer.temporalMakefileUpdateScript");
        }
        if (!pluginPreferenceStore.isDefault("org.eclipse.titan.designer.temporalMakefileFlags")) {
            pluginPreferenceStore.setToDefault("org.eclipse.titan.designer.temporalMakefileFlags");
        }
        if (!pluginPreferenceStore.isDefault("org.eclipse.titan.designer.temporalWorkingDir")) {
            pluginPreferenceStore.setToDefault("org.eclipse.titan.designer.temporalWorkingDir");
        }
        this.configurationManager.saveActualConfiguration();
        ProjectDocumentHandlingUtility.saveDocument(this.projectResource);
        TITANAutomaticProjectExporter.saveAllAutomatically(this.projectResource);
        ProjectFileHandler projectFileHandler = new ProjectFileHandler(this.projectResource);
        projectFileHandler.saveProjectSettings();
        GlobalProjectStructureTracker.projectChanged(this.projectResource);
        this.evaluatePropertyStore();
        return true;
    }

    public boolean performCancel() {
        this.loadProperties();
        this.evaluatePropertyStore();
        this.configurationManager.clearActualConfiguration();
        return true;
    }

    public void loadProperty(String propertyName, Button button) {
        String temp = "";
        try {
            temp = this.projectResource.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", propertyName));
        }
        catch (CoreException ce) {
            this.generateMakefileButton.setSelection(false);
            this.generateInternalMakefileButton.setSelection(false);
            this.withoutSymbolicLinksButton.setSelection(false);
            this.withoutSymbolicLinksButton.setText("Don't use symbolic links in the build process (internal only)");
        }
        button.setSelection("true".equals(temp));
    }

    public void loadProperties() {
        if (this.generateMakefileButton == null) {
            return;
        }
        this.loadProperty("generateMakefile", this.generateMakefileButton);
        this.loadProperty("generateInternalMakefile", this.generateInternalMakefileButton);
        this.loadProperty("symboliclinklessBuild", this.withoutSymbolicLinksButton);
        this.makefileCreationTab.loadProperties(this.projectResource);
        this.internalMakefileCreationTab.loadProperties(this.projectResource);
        this.makeAttributesTab.loadProperties(this.projectResource);
        this.codeSplittingTab.loadProperties(this.projectResource);
    }

    public boolean saveProperty(String propertyName, Button button) {
        String temp = button.getSelection() ? "true" : "false";
        try {
            this.projectResource.setPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", propertyName), temp);
        }
        catch (CoreException ce) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)ce));
            return false;
        }
        return true;
    }

    public boolean checkProperties() {
        if (this.generateMakefileButton == null || this.generateMakefileButton.isDisposed()) {
            return false;
        }
        boolean result = true;
        result &= this.makefileCreationTab.checkProperties(this);
        result &= this.internalMakefileCreationTab.checkProperties(this);
        result &= this.makeAttributesTab.checkProperties(this);
        result &= this.codeSplittingTab.checkProperties(this);
        try {
            if (!this.generateInternalMakefileButton.getSelection()) {
                IProject[] projects;
                for (IProject referencedProject : projects = this.projectResource.getReferencedProjects()) {
                    if (!referencedProject.isAccessible()) {
                        this.setErrorMessage("The referenced project `" + referencedProject.getName() + "' is not accessible");
                        result = false;
                        continue;
                    }
                    if (ProjectBuildPropertyData.useSymbolicLinks(referencedProject)) continue;
                    this.setErrorMessage("Will not be able to generate a makefile to project `" + this.projectResource.getName() + "' with the external makefile generator as project `" + referencedProject.getName() + "' is set to build without generating symbolic links");
                    result = false;
                }
            }
        }
        catch (CoreException ce) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)ce));
        }
        return result;
    }

    public boolean saveProperties() {
        if (this.generateMakefileButton == null) {
            return false;
        }
        boolean success = true;
        success &= this.saveProperty("generateMakefile", this.generateMakefileButton);
        success &= this.saveProperty("generateInternalMakefile", this.generateInternalMakefileButton);
        success &= this.saveProperty("symboliclinklessBuild", this.withoutSymbolicLinksButton);
        success &= this.makefileCreationTab.saveProperties(this.projectResource);
        success &= this.internalMakefileCreationTab.saveProperties(this.projectResource);
        success &= this.makeAttributesTab.saveProperties(this.projectResource);
        this.setErrorMessage(null);
        return success &= this.codeSplittingTab.saveProperties(this.projectResource);
    }
}

