/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.configeditor.pages.logging;

import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.titan.common.parsers.AddedParseTree;
import org.eclipse.titan.common.parsers.cfg.ConfigTreeNodeUtilities;
import org.eclipse.titan.common.parsers.cfg.indices.LoggingSectionHandler;
import org.eclipse.titan.designer.editors.configeditor.ConfigEditor;
import org.eclipse.titan.designer.editors.configeditor.pages.logging.GeneralOptionsSubPage;
import org.eclipse.titan.designer.editors.configeditor.pages.logging.LoggingBitsSubPage;
import org.eclipse.titan.designer.editors.configeditor.pages.logging.LoggingTreeSubPage;
import org.eclipse.titan.designer.graphics.ImageCache;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public final class LoggingPage
extends FormPage {
    private ScrolledForm form;
    private final ConfigEditor editor;
    private LoggingSectionHandler loggingSectionHandler;
    private final GeneralOptionsSubPage generalOptions;
    private final LoggingTreeSubPage componentpluginSection;
    private final LoggingBitsSubPage loggingBitsSubPage;

    public LoggingPage(ConfigEditor editor) {
        super((FormEditor)editor, "Logging", "Logging");
        this.editor = editor;
        this.generalOptions = new GeneralOptionsSubPage(editor, this);
        this.componentpluginSection = new LoggingTreeSubPage(editor, this);
        this.loggingBitsSubPage = new LoggingBitsSubPage(editor, this);
    }

    protected void createFormContent(IManagedForm managedForm) {
        this.form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        this.form.setText("Logging section");
        this.form.setBackgroundImage(ImageCache.getImage("form_banner.gif"));
        GridLayout layoutParent = new GridLayout();
        this.form.getBody().setLayout((Layout)layoutParent);
        Composite composite = toolkit.createComposite(this.form.getBody());
        GridLayout layout = new GridLayout(2, true);
        layout.makeColumnsEqualWidth = true;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.componentpluginSection.createSectionComponent(toolkit, composite);
        this.generalOptions.createSectionGeneral(toolkit, composite);
        this.loggingBitsSubPage.createSectionLoggingBits(toolkit, managedForm.getForm(), composite);
        this.setErrorMessage();
    }

    public void refreshData(LoggingSectionHandler loggingSectionHandler) {
        this.loggingSectionHandler = loggingSectionHandler;
        this.componentpluginSection.refreshData(loggingSectionHandler);
        this.generalOptions.refreshData(loggingSectionHandler, null);
        this.loggingBitsSubPage.refreshData(loggingSectionHandler, null);
    }

    public void refreshData(LoggingSectionHandler loggingSectionHandler, LoggingSectionHandler.LogParamEntry logentry) {
        this.loggingSectionHandler = loggingSectionHandler;
        this.generalOptions.refreshData(loggingSectionHandler, logentry);
        this.loggingBitsSubPage.refreshData(loggingSectionHandler, logentry);
    }

    public LoggingSectionHandler.LoggerTreeElement getSelectedTreeElement() {
        return this.componentpluginSection.getSelection();
    }

    public void treeElementAdded(LoggingSectionHandler.LoggerTreeElement lte, LoggingSectionHandler.LogParamEntry logentry) {
        this.loggingSectionHandler = lte.getLsh();
        this.generalOptions.initializeEntry(lte, logentry);
        this.generalOptions.refreshData(this.loggingSectionHandler, logentry);
        this.loggingBitsSubPage.initializeEntry(lte, logentry);
        this.loggingBitsSubPage.refreshData(this.loggingSectionHandler, logentry);
    }

    public void treeElementSelected(LoggingSectionHandler.LoggerTreeElement lte) {
        LoggingSectionHandler.LogParamEntry logentry = this.loggingSectionHandler.componentPlugin(lte.getComponentName(), lte.getPluginName());
        this.generalOptions.refreshData(this.loggingSectionHandler, logentry);
        this.loggingBitsSubPage.refreshData(this.loggingSectionHandler, logentry);
    }

    public void createLoggingSection() {
        if (this.loggingSectionHandler == null || this.loggingSectionHandler.getLastSectionRoot() != null) {
            return;
        }
        ParserRuleContext sectionRoot = new ParserRuleContext();
        this.loggingSectionHandler.setLastSectionRoot(sectionRoot);
        AddedParseTree header = new AddedParseTree("\n[LOGGING]");
        ConfigTreeNodeUtilities.addChild((ParseTree)sectionRoot, (ParseTree)header);
        ParserRuleContext root = this.editor.getParseTreeRoot();
        if (root != null) {
            root.addChild((RuleContext)sectionRoot);
        }
    }

    public void removeLoggingSection() {
        if (this.loggingSectionHandler == null || this.loggingSectionHandler.getLastSectionRoot() == null) {
            return;
        }
        if (this.loggingSectionHandler.getComponents().isEmpty()) {
            ConfigTreeNodeUtilities.removeChild((ParseTree)this.editor.getParseTreeRoot(), (ParseTree)this.loggingSectionHandler.getLastSectionRoot());
            this.loggingSectionHandler.setLastSectionRoot(null);
        }
    }

    public void setActive(boolean active) {
        this.setErrorMessage();
        super.setActive(active);
    }

    public void setErrorMessage() {
        if (this.form != null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (LoggingPage.this.editor.getErrorMessage() == null) {
                        LoggingPage.this.form.getForm().setMessage(null, 0);
                    } else {
                        LoggingPage.this.form.getForm().setMessage(LoggingPage.this.editor.getErrorMessage(), 3);
                    }
                    LoggingPage.this.form.getForm().getHead().layout();
                    LoggingPage.this.form.getForm().getHead().redraw();
                }
            });
        }
    }
}

