/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.core.ant;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.RefreshUtil;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;

public final class AntLaunchConfigGenerator {
    private static final String ANT_LAUNCH_CONFIGURATION_NAME = "JarBuilder";
    private static final String ANT_LAUNCH_CONFIGURATION_EXTENSION = ".launch";
    private static final String ANT_LAUNCH_CONFIGURATION_FOLDER = ".externalToolBuilders";
    private static final String ANT_BUILDER_ARG1_KEY = "LaunchConfigHandle";
    private static final String ANT_BUILDER_ARG1_VALUE = "<project>/.externalToolBuilders/JarBuilder.launch";

    public static void addAntBuilder(IProject project) throws CoreException {
        IProjectDescription description = project.getDescription();
        ArrayList<ICommand> commands = new ArrayList<ICommand>(Arrays.asList(description.getBuildSpec()));
        for (ICommand command : commands) {
            if (!command.getBuilderName().equals("org.eclipse.ui.externaltools.ExternalToolBuilder")) continue;
            return;
        }
        ICommand antCommand = description.newCommand();
        HashMap<String, String> args = new HashMap<String, String>(1);
        args.put(ANT_BUILDER_ARG1_KEY, ANT_BUILDER_ARG1_VALUE);
        antCommand.setBuilderName("org.eclipse.ui.externaltools.ExternalToolBuilder");
        antCommand.setBuilding(15, false);
        antCommand.setArguments(args);
        commands.add(antCommand);
        description.setBuildSpec(commands.toArray(new ICommand[commands.size()]));
        project.setDescription(description, null);
        project.refreshLocal(2, null);
    }

    public static ILaunchConfiguration createAntLaunchConfiguration(IProject project) throws CoreException {
        if (project == null) {
            return null;
        }
        if (AntLaunchConfigGenerator.existAntLaunchConfiguration(project)) {
            return AntLaunchConfigGenerator.getAntLaunchConfiguration(project);
        }
        IFolder antLaunchConfigFolder = project.getFolder((IPath)new Path(ANT_LAUNCH_CONFIGURATION_FOLDER));
        if (!antLaunchConfigFolder.exists()) {
            antLaunchConfigFolder.create(false, true, null);
        }
        ILaunchConfigurationWorkingCopy wc = AntLaunchConfigGenerator.getAntLaunchConfigurationType().newInstance((IContainer)antLaunchConfigFolder, ANT_LAUNCH_CONFIGURATION_NAME);
        wc.setAttribute("org.eclipse.ant.ui.ATTR_ANT_MANUAL_TARGETS", "jar,");
        wc.setAttribute("org.eclipse.ant.ui.ATTR_TARGETS_UPDATED", true);
        wc.setAttribute("org.eclipse.ant.ui.DEFAULT_VM_INSTALL", false);
        wc.setAttribute(RefreshUtil.ATTR_REFRESH_SCOPE, "${project}");
        wc.setAttribute("org.eclipse.debug.ui.ATTR_LAUNCH_IN_BACKGROUND", false);
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH_PROVIDER, "org.eclipse.ant.ui.AntClasspathProvider");
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, true);
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, project.getName());
        wc.setAttribute("org.eclipse.ui.externaltools.ATTR_BUILDER_ENABLED", true);
        String location = "${workspace_loc:/" + project.getName() + "/" + "jarbuild.xml" + "}";
        wc.setAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION", location);
        wc.setAttribute("org.eclipse.ui.externaltools.ATTR_RUN_BUILD_KINDS", "incremental");
        wc.setAttribute("org.eclipse.ui.externaltools.ATTR_TRIGGERS_CONFIGURED", true);
        wc.setAttribute("org.eclipse.ui.externaltools.ATTR_WORKING_DIRECTORY", "${workspace_loc:/" + project.getName() + "}");
        return wc.doSave();
    }

    public static boolean existAntLaunchConfiguration(IProject project) {
        if (project == null) {
            return false;
        }
        IFile antLaunchConfigFile = project.getFile((IPath)new Path(ANT_LAUNCH_CONFIGURATION_FOLDER + File.separator + ANT_LAUNCH_CONFIGURATION_NAME + ANT_LAUNCH_CONFIGURATION_EXTENSION));
        return antLaunchConfigFile.exists();
    }

    public static ILaunchConfiguration getAntLaunchConfiguration(IProject project) throws CoreException {
        if (project == null) {
            return null;
        }
        IFile antLaunchConfigFile = project.getFile((IPath)new Path(ANT_LAUNCH_CONFIGURATION_FOLDER + File.separator + ANT_LAUNCH_CONFIGURATION_NAME + ANT_LAUNCH_CONFIGURATION_EXTENSION));
        if (antLaunchConfigFile.exists()) {
            return AntLaunchConfigGenerator.getLaunchManager().getLaunchConfiguration(antLaunchConfigFile);
        }
        return null;
    }

    public static ILaunchConfigurationType getAntLaunchConfigurationType() {
        return AntLaunchConfigGenerator.getLaunchManager().getLaunchConfigurationType("org.eclipse.ant.AntBuilderLaunchConfigurationType");
    }

    private static ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    public static boolean isAntBuilderEnabled(IProject project) throws CoreException {
        if (project == null) {
            return false;
        }
        ILaunchConfiguration config = AntLaunchConfigGenerator.getAntLaunchConfiguration(project);
        if (config == null) {
            return false;
        }
        return config.getAttribute("org.eclipse.ui.externaltools.ATTR_BUILDER_ENABLED", false);
    }

    public static void setAntBuilderEnabled(IProject project, boolean enabled) throws CoreException {
        if (project == null) {
            return;
        }
        ILaunchConfiguration config = AntLaunchConfigGenerator.getAntLaunchConfiguration(project);
        if (config == null) {
            return;
        }
        ILaunchConfigurationWorkingCopy wc = config.getWorkingCopy();
        wc.setAttribute("org.eclipse.ui.externaltools.ATTR_BUILDER_ENABLED", enabled);
        wc.doSave();
    }
}

