/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.types;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.ASN1.types.ASN1_Choice_Type;
import org.eclipse.titan.designer.AST.ASN1.types.ASN1_Set_Seq_Choice_BaseType;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.ArraySubReference;
import org.eclipse.titan.designer.AST.FieldSubReference;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IReferenceableElement;
import org.eclipse.titan.designer.AST.IReferencingType;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.ITypeWithComponents;
import org.eclipse.titan.designer.AST.IValue;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.ParameterisedSubReference;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceChain;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.Expected_Value_type;
import org.eclipse.titan.designer.AST.TTCN3.attributes.JsonAST;
import org.eclipse.titan.designer.AST.TTCN3.attributes.RawAST;
import org.eclipse.titan.designer.AST.TTCN3.attributes.RawASTStruct;
import org.eclipse.titan.designer.AST.TTCN3.definitions.IMemberInfo;
import org.eclipse.titan.designer.AST.TTCN3.types.CompField;
import org.eclipse.titan.designer.AST.TTCN3.types.CompFieldMap;
import org.eclipse.titan.designer.AST.TTCN3.types.RecordSetCodeGenerator;
import org.eclipse.titan.designer.AST.TTCN3.types.Referenced_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.TTCN3_Choice_Type;
import org.eclipse.titan.designer.AST.TTCN3.types.TTCN3_Sequence_Type;
import org.eclipse.titan.designer.AST.TTCN3.values.Enumerated_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.Expression_Value;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ExpressionStruct;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titan.designer.AST.Value;
import org.eclipse.titan.designer.compiler.BuildTimestamp;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.declarationsearch.Declaration;
import org.eclipse.titan.designer.editors.ProposalCollector;
import org.eclipse.titan.designer.editors.actions.DeclarationCollector;
import org.eclipse.titan.designer.editors.controls.Ttcn3HoverContent;
import org.eclipse.titan.designer.graphics.ImageCache;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public abstract class TTCN3_Set_Seq_Choice_BaseType
extends Type
implements ITypeWithComponents,
IReferenceableElement,
IMemberInfo {
    private static final String LENGTHTO_ERROR_MISSING_RESTRICTION = "The length of this field must be specified either with `length()` subtyping or with the `FIELDLENGTH` attribute";
    private static final String LENGTHTO_ERROR_WRONG_TYPE = "The union type LENGTHTO field must contain only integer, bitstring or octetstring fields";
    protected CompFieldMap compFieldMap;
    private boolean componentInternal;
    protected BuildTimestamp rawLengthCalculated;
    protected int rawLength;
    private boolean insideCanHaveCoding = false;

    public TTCN3_Set_Seq_Choice_BaseType(CompFieldMap compFieldMap) {
        this.compFieldMap = compFieldMap;
        this.componentInternal = false;
        compFieldMap.setMyType(this);
        compFieldMap.setFullNameParent(this);
    }

    @Override
    public final void setMyScope(Scope scope) {
        super.setMyScope(scope);
        this.compFieldMap.setMyScope(scope);
    }

    public final int getNofComponents() {
        if (this.compFieldMap == null) {
            return 0;
        }
        return this.compFieldMap.fields.size();
    }

    public final CompField getComponentByIndex(int index) {
        return this.compFieldMap.fields.get(index);
    }

    public final boolean hasComponentWithName(String name) {
        if (this.compFieldMap.componentFieldMap == null) {
            return false;
        }
        return this.compFieldMap.componentFieldMap.containsKey(name);
    }

    public int getComponentIndexByName(Identifier identifier) {
        for (int i = 0; i < this.compFieldMap.fields.size(); ++i) {
            if (!this.compFieldMap.fields.get(i).getIdentifier().equals(identifier)) continue;
            return i;
        }
        return -1;
    }

    public int getComponentIndexByName(String name) {
        for (int i = 0; i < this.compFieldMap.fields.size(); ++i) {
            if (!this.compFieldMap.fields.get(i).getIdentifier().getName().equals(name)) continue;
            return i;
        }
        return -1;
    }

    public final CompField getComponentByName(String name) {
        if (this.compFieldMap.componentFieldMap == null) {
            return null;
        }
        return this.compFieldMap.componentFieldMap.get(name);
    }

    public final Identifier getComponentIdentifierByIndex(int index) {
        return this.compFieldMap.fields.get(index).getIdentifier();
    }

    @Override
    public final IType getFieldType(CompilationTimeStamp timestamp, Reference reference, int actualSubReference, Expected_Value_type expectedIndex, IReferenceChain refChain, boolean interruptIfOptional) {
        List<ISubReference> subreferences = reference.getSubreferences();
        if (subreferences.size() <= actualSubReference) {
            return this;
        }
        ISubReference subreference = subreferences.get(actualSubReference);
        switch (subreference.getReferenceType()) {
            case arraySubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Type `{0}'' can not be indexed", this.getTypename()));
                return null;
            }
            case fieldSubReference: {
                Identifier id = subreference.getId();
                CompField compField = this.compFieldMap.getCompWithName(id);
                if (compField == null) {
                    subreference.getLocation().reportSemanticError(MessageFormat.format("Reference to a non-existent field `{0}'' in type `{1}''", ((FieldSubReference)subreference).getId().getDisplayName(), this.getTypename()));
                    return null;
                }
                Type fieldType = compField.getType();
                if (fieldType == null) {
                    return null;
                }
                if (interruptIfOptional && compField.isOptional()) {
                    return null;
                }
                Expected_Value_type internalExpectation = expectedIndex == Expected_Value_type.EXPECTED_TEMPLATE ? Expected_Value_type.EXPECTED_DYNAMIC_VALUE : expectedIndex;
                return fieldType.getFieldType(timestamp, reference, actualSubReference + 1, internalExpectation, refChain, interruptIfOptional);
            }
            case parameterisedSubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Invalid field reference `{0}'': type `{1}'' does not have fields.", ((ParameterisedSubReference)subreference).getId().getDisplayName(), this.getTypename()));
                return null;
            }
        }
        subreference.getLocation().reportSemanticError("Unsupported subreference kind.");
        return null;
    }

    @Override
    public boolean getSubrefsAsArray(CompilationTimeStamp timestamp, Reference reference, int actualSubReference, List<Integer> subrefsArray, List<IType> typeArray) {
        List<ISubReference> subreferences = reference.getSubreferences();
        if (subreferences.size() <= actualSubReference) {
            return true;
        }
        ISubReference subreference = subreferences.get(actualSubReference);
        switch (subreference.getReferenceType()) {
            case arraySubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Type `{0}'' can not be indexed", this.getTypename()));
                return false;
            }
            case fieldSubReference: {
                Identifier id = subreference.getId();
                CompField compField = this.compFieldMap.getCompWithName(id);
                if (compField == null) {
                    subreference.getLocation().reportSemanticError(MessageFormat.format("Reference to a non-existent field `{0}'' in type `{1}''", ((FieldSubReference)subreference).getId().getDisplayName(), this.getTypename()));
                    return false;
                }
                Type fieldType = compField.getType();
                if (fieldType == null) {
                    return false;
                }
                int fieldIndex = this.compFieldMap.fields.indexOf(compField);
                subrefsArray.add(fieldIndex);
                typeArray.add(this);
                return fieldType.getSubrefsAsArray(timestamp, reference, actualSubReference + 1, subrefsArray, typeArray);
            }
            case parameterisedSubReference: {
                subreference.getLocation().reportSemanticError(MessageFormat.format("Invalid field reference `{0}'': type `{1}'' does not have fields.", ((ParameterisedSubReference)subreference).getId().getDisplayName(), this.getTypename()));
                return false;
            }
        }
        subreference.getLocation().reportSemanticError("Unsupported subreference kind.");
        return false;
    }

    @Override
    public boolean getFieldTypesAsArray(Reference reference, int actualSubReference, List<IType> typeArray) {
        List<ISubReference> subreferences = reference.getSubreferences();
        if (subreferences.size() <= actualSubReference) {
            return true;
        }
        ISubReference subreference = subreferences.get(actualSubReference);
        switch (subreference.getReferenceType()) {
            case arraySubReference: {
                return false;
            }
            case fieldSubReference: {
                if (this.compFieldMap == null) {
                    return false;
                }
                Identifier id = subreference.getId();
                CompField compField = this.compFieldMap.getCompWithName(id);
                if (compField == null) {
                    return false;
                }
                Type fieldType = compField.getType();
                if (fieldType == null) {
                    return false;
                }
                typeArray.add(this);
                return fieldType.getFieldTypesAsArray(reference, actualSubReference + 1, typeArray);
            }
            case parameterisedSubReference: {
                return false;
            }
        }
        return false;
    }

    @Override
    public final boolean isComponentInternal(CompilationTimeStamp timestamp) {
        this.check(timestamp);
        return this.componentInternal;
    }

    @Override
    public final void check(CompilationTimeStamp timestamp) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.lastTimeChecked = timestamp;
        this.componentInternal = false;
        this.isErroneous = false;
        this.initAttributes(timestamp);
        this.compFieldMap.check(timestamp);
        int size = this.getNofComponents();
        for (int i = 0; i < size; ++i) {
            Type type = this.getComponentByIndex(i).getType();
            if (type == null || !type.isComponentInternal(timestamp)) continue;
            this.componentInternal = true;
            break;
        }
        if (this.constraints != null) {
            this.constraints.check(timestamp);
        }
        this.checkSubtypeRestrictions(timestamp);
        if (this.myScope != null) {
            this.checkEncode(timestamp);
            this.checkVariants(timestamp);
        }
    }

    @Override
    public final void checkComponentInternal(CompilationTimeStamp timestamp, Set<IType> typeSet, String operation) {
        if (typeSet.contains(this)) {
            return;
        }
        typeSet.add(this);
        int size = this.getNofComponents();
        for (int i = 0; i < size; ++i) {
            Type type = this.getComponentByIndex(i).getType();
            if (type == null || !type.isComponentInternal(timestamp)) continue;
            type.checkComponentInternal(timestamp, typeSet, operation);
        }
        typeSet.remove(this);
    }

    @Override
    public void getTypesWithNoCodingTable(CompilationTimeStamp timestamp, ArrayList<IType> typeList, boolean onlyOwnTable) {
        if (typeList.contains(this)) {
            return;
        }
        if (onlyOwnTable && this.codingTable.isEmpty() || !onlyOwnTable && this.getTypeWithCodingTable(timestamp, false) == null) {
            typeList.add(this);
        }
        int size = this.getNofComponents();
        for (int i = 0; i < size; ++i) {
            Type type = this.getComponentByIndex(i).getType();
            if (type == null) continue;
            type.getTypesWithNoCodingTable(timestamp, typeList, onlyOwnTable);
        }
    }

    @Override
    public void checkMapParameter(CompilationTimeStamp timestamp, IReferenceChain refChain, Location errorLocation) {
        if (refChain.contains(this)) {
            return;
        }
        refChain.add(this);
        int size = this.getNofComponents();
        for (int i = 0; i < size; ++i) {
            Type type = this.getComponentByIndex(i).getType();
            type.checkMapParameter(timestamp, refChain, errorLocation);
        }
    }

    @Override
    public final Object[] getOutlineChildren() {
        return this.compFieldMap.getOutlineChildren();
    }

    @Override
    public final void addProposal(ProposalCollector propCollector, int i) {
        List<ISubReference> subreferences = propCollector.getReference().getSubreferences();
        if (subreferences.size() <= i) {
            return;
        }
        ISubReference subreference = subreferences.get(i);
        if (ISubReference.Subreference_type.fieldSubReference.equals((Object)subreference.getReferenceType())) {
            if (subreferences.size() > i + 1) {
                CompField compField = this.compFieldMap.getCompWithName(subreference.getId());
                if (compField == null) {
                    return;
                }
                Type type = compField.getType();
                if (type != null) {
                    type.addProposal(propCollector, i + 1);
                }
            } else {
                List<CompField> compFields = this.compFieldMap.getComponentsWithPrefix(subreference.getId().getName());
                for (CompField compField : compFields) {
                    String proposalKind = compField.getType().getProposalDescription(new StringBuilder()).toString();
                    propCollector.addProposal(compField.getIdentifier(), " - " + proposalKind, ImageCache.getImage(this.getOutlineIcon()), proposalKind);
                    IType type = compField.getType();
                    if (type == null || !compField.getIdentifier().equals(subreference.getId())) continue;
                    type = type.getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp());
                    type.addProposal(propCollector, i + 1);
                }
            }
        }
    }

    @Override
    public final void addDeclaration(DeclarationCollector declarationCollector, int i) {
        List<ISubReference> subreferences = declarationCollector.getReference().getSubreferences();
        if (subreferences.size() <= i) {
            return;
        }
        ISubReference subreference = subreferences.get(i);
        if (ISubReference.Subreference_type.fieldSubReference.equals((Object)subreference.getReferenceType())) {
            if (subreferences.size() > i + 1) {
                CompField compField = this.compFieldMap.getCompWithName(subreference.getId());
                if (compField == null) {
                    return;
                }
                Type type = compField.getType();
                if (type != null) {
                    type.addDeclaration(declarationCollector, i + 1);
                }
            } else {
                List<CompField> compFields = this.compFieldMap.getComponentsWithPrefix(subreference.getId().getName());
                for (CompField compField : compFields) {
                    declarationCollector.addDeclaration(compField.getIdentifier().getDisplayName(), compField.getIdentifier().getLocation(), this);
                }
            }
        }
    }

    @Override
    public final void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            this.lastTimeChecked = null;
            boolean handled = false;
            if (this.compFieldMap != null && reparser.envelopsDamage(this.compFieldMap.getLocation())) {
                try {
                    this.compFieldMap.updateSyntax(reparser, true);
                }
                catch (ReParseException e) {
                    e.decreaseDepth();
                    throw e;
                }
                reparser.updateLocation(this.compFieldMap.getLocation());
                handled = true;
            }
            if (this.subType != null) {
                this.subType.updateSyntax(reparser, false);
                handled = true;
            }
            if (handled) {
                return;
            }
            throw new ReParseException();
        }
        reparser.updateLocation(this.compFieldMap.getLocation());
        this.compFieldMap.updateSyntax(reparser, false);
        if (this.subType != null) {
            this.subType.updateSyntax(reparser, false);
        }
        if (this.withAttributesPath != null) {
            this.withAttributesPath.updateSyntax(reparser, false);
            reparser.updateLocation(this.withAttributesPath.getLocation());
        }
    }

    @Override
    public void getEnclosingField(int offset, ReferenceFinder rf) {
        this.compFieldMap.getEnclosingField(offset, rf);
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        super.findReferences(referenceFinder, foundIdentifiers);
        if (this.compFieldMap != null) {
            this.compFieldMap.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (!super.memberAccept(v)) {
            return false;
        }
        return this.compFieldMap == null || this.compFieldMap.accept(v);
    }

    @Override
    public Identifier getComponentIdentifierByName(Identifier identifier) {
        if (identifier == null) {
            return null;
        }
        CompField cf = this.getComponentByName(identifier.getName());
        return cf == null ? null : cf.getIdentifier();
    }

    @Override
    public Declaration resolveReference(Reference reference, int subRefIdx, ISubReference lastSubreference) {
        int localIndex;
        List<ISubReference> subreferences = reference.getSubreferences();
        for (localIndex = subRefIdx; localIndex < subreferences.size() && subreferences.get(localIndex) instanceof ArraySubReference; ++localIndex) {
        }
        if (localIndex == subreferences.size()) {
            return null;
        }
        CompField compField = this.getComponentByName(subreferences.get(localIndex).getId().getName());
        if (compField == null) {
            return null;
        }
        if (subreferences.get(localIndex) == lastSubreference) {
            return Declaration.createInstance(this.getDefiningAssignment(), compField.getIdentifier());
        }
        IType compFieldType = compField.getType().getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp());
        if (compFieldType instanceof IReferenceableElement) {
            Declaration decl = ((IReferenceableElement)((Object)compFieldType)).resolveReference(reference, localIndex + 1, lastSubreference);
            return decl != null ? decl : Declaration.createInstance(this.getDefiningAssignment(), compField.getIdentifier());
        }
        return null;
    }

    @Override
    public boolean canHaveCoding(CompilationTimeStamp timestamp, IType.MessageEncoding_type coding) {
        if (this.insideCanHaveCoding) {
            return true;
        }
        this.insideCanHaveCoding = true;
        for (int i = 0; i < this.codingTable.size(); ++i) {
            IType.Coding_Type tempCodingType = (IType.Coding_Type)this.codingTable.get(i);
            if (!tempCodingType.builtIn || !tempCodingType.builtInCoding.equals((Object)coding)) continue;
            this.insideCanHaveCoding = false;
            return true;
        }
        if (coding == IType.MessageEncoding_type.BER) {
            boolean result = this.hasEncoding(timestamp, IType.MessageEncoding_type.BER, null);
            this.insideCanHaveCoding = false;
            return result;
        }
        for (CompField compField : this.compFieldMap.fields) {
            Type fieldType = compField.getType();
            if (fieldType == null) {
                return false;
            }
            IType refdLast = fieldType.getTypeRefdLast(timestamp);
            if (refdLast.canHaveCoding(timestamp, coding)) continue;
            this.insideCanHaveCoding = false;
            return false;
        }
        this.insideCanHaveCoding = false;
        return true;
    }

    protected void checkSetSeqJson(CompilationTimeStamp timestamp) {
        int i;
        if (this.jsonAttribute == null && !this.hasEncodeAttribute("JSON")) {
            return;
        }
        for (i = 0; i < this.getNofComponents(); ++i) {
            Type fieldType = this.getComponentByIndex(i).getType();
            fieldType.forceJson(timestamp);
        }
        if (this.jsonAttribute == null) {
            return;
        }
        if (this.jsonAttribute.omit_as_null && !this.isOptionalField()) {
            this.getLocation().reportSemanticError("Invalid attribute, 'omit as null' requires optional field of a record or set.");
        }
        if (this.jsonAttribute.as_value && this.getNofComponents() != 1) {
            this.getLocation().reportSemanticError("Invalid attribute, 'as value' is only allowed for unions, the anytype, or records or sets with one field");
        }
        if (this.jsonAttribute.alias != null) {
            IType parent = this.getParentType();
            if (parent == null) {
                this.getLocation().reportSemanticError("Invalid attribute, 'name as ...' requires field of a record, set or union.");
            } else {
                switch (parent.getTypetype()) {
                    case TYPE_TTCN3_SEQUENCE: 
                    case TYPE_TTCN3_SET: 
                    case TYPE_TTCN3_CHOICE: 
                    case TYPE_ANYTYPE: {
                        break;
                    }
                    default: {
                        this.getLocation().reportSemanticError("Invalid attribute, 'name as ...' requires field of a record, set or union.");
                    }
                }
            }
            if (parent != null && parent.getJsonAttribute() != null && parent.getJsonAttribute().as_value) {
                switch (parent.getTypetype()) {
                    case TYPE_TTCN3_CHOICE: 
                    case TYPE_ANYTYPE: {
                        this.getLocation().reportSemanticWarning(MessageFormat.format("Attribute 'name as ...' will be ignored, because parent {0} is encoded without field names.", parent.getTypename()));
                        break;
                    }
                    case TYPE_TTCN3_SEQUENCE: 
                    case TYPE_TTCN3_SET: {
                        if (((TTCN3_Set_Seq_Choice_BaseType)parent).getNofComponents() != 1) break;
                        this.getLocation().reportSemanticWarning(MessageFormat.format("Attribute 'name as ...' will be ignored, because parent {0} is encoded without field names.", parent.getTypename()));
                        break;
                    }
                }
            }
        }
        if (this.jsonAttribute.parsed_default_value != null) {
            this.checkJsonDefault(timestamp);
        }
        if (this.jsonAttribute.metainfo_unbound) {
            if (this.jsonAttribute.as_value && this.getNofComponents() == 1) {
                this.getLocation().reportSemanticWarning(MessageFormat.format("Attribute 'metainfo for unbound' will be ignored, because the {0} is encoded without field names.", this.getTypetype() == IType.Type_type.TYPE_TTCN3_SEQUENCE ? "record" : "set"));
            } else {
                for (i = 0; i < this.getNofComponents(); ++i) {
                    CompField cField = this.getComponentByIndex(i);
                    Type fieldType = cField.getType();
                    if (fieldType.jsonAttribute == null) {
                        fieldType.setJsonAttributes(new JsonAST());
                    }
                    fieldType.jsonAttribute.metainfo_unbound = true;
                }
            }
        }
        if (this.jsonAttribute.as_number) {
            this.getLocation().reportSemanticError("Invalid attribute, 'as number' is only allowed for enumerated types");
        }
        if (this.jsonAttribute.enum_texts.size() > 0) {
            this.getLocation().reportSemanticError("Invalid attribute, 'text ... as ...' requires an enumerated type");
        }
    }

    protected void checkSetSeqRawCodingAttributes(CompilationTimeStamp timestamp) {
        int a;
        if (this.rawAttribute != null) {
            Type fieldType;
            CompField cField;
            int i;
            if (this.rawAttribute.taglist != null) {
                for (int c = 0; c < this.rawAttribute.taglist.size(); ++c) {
                    RawAST.rawAST_single_tag singleTag = this.rawAttribute.taglist.get(c);
                    Identifier fieldname = singleTag.fieldName;
                    if (!this.hasComponentWithName(fieldname.getName())) {
                        fieldname.getLocation().reportSemanticError(MessageFormat.format("Invalid field name `{0}'' in RAW parameter TAG for type `{1}''", fieldname.getDisplayName(), this.getTypename()));
                        continue;
                    }
                    if (singleTag.keyList == null) continue;
                    for (int a2 = 0; a2 < singleTag.keyList.size(); ++a2) {
                        Value v;
                        Reference reference = new Reference(null);
                        reference.addSubReference(new FieldSubReference(fieldname));
                        for (int b = 0; b < singleTag.keyList.get((int)a2).keyField.names.size(); ++b) {
                            reference.addSubReference(new FieldSubReference(singleTag.keyList.get((int)a2).keyField.names.get(b)));
                        }
                        IType t = this.getFieldType(timestamp, reference, 0, Expected_Value_type.EXPECTED_DYNAMIC_VALUE, false);
                        if (t == null || (v = singleTag.keyList.get((int)a2).v_value) == null) continue;
                        v.setMyScope(this.getMyScope());
                        v.setMyGovernor(t);
                        IValue tempValue = t.checkThisValueRef(timestamp, v);
                        t.checkThisValue(timestamp, tempValue, null, new IType.ValueCheckingOptions(Expected_Value_type.EXPECTED_CONSTANT, false, false, false, false, false));
                    }
                }
            }
            if (this.rawAttribute.ext_bit_groups != null) {
                block34: for (a = 0; a < this.rawAttribute.ext_bit_groups.size(); ++a) {
                    RawAST.rawAST_ext_bit_group tempExtBitGroup = this.rawAttribute.ext_bit_groups.get(a);
                    Identifier fromIdentifier = tempExtBitGroup.from;
                    Identifier toIdentifier = tempExtBitGroup.to;
                    boolean foundError = false;
                    if (!this.hasComponentWithName(fromIdentifier.getName())) {
                        fromIdentifier.getLocation().reportSemanticError(MessageFormat.format("Invalid field name `{0}'' in RAW parameter EXTENSION_BIT_GROUP for type `{1}''", fromIdentifier.getDisplayName(), this.getTypename()));
                        foundError = true;
                    }
                    if (!this.hasComponentWithName(toIdentifier.getName())) {
                        toIdentifier.getLocation().reportSemanticError(MessageFormat.format("Invalid field name `{0}'' in RAW parameter EXTENSION_BIT_GROUP for type `{1}''", toIdentifier.getDisplayName(), this.getTypename()));
                        foundError = true;
                    }
                    if (foundError) continue;
                    boolean foundStart = false;
                    for (int i2 = 0; i2 < this.getNofComponents(); ++i2) {
                        Identifier tempId = this.getComponentByIndex(i2).getIdentifier();
                        if (tempId.equals(fromIdentifier)) {
                            foundStart = true;
                            continue;
                        }
                        if (!tempId.equals(toIdentifier)) continue;
                        if (foundStart) continue block34;
                        this.getLocation().reportSemanticError(MessageFormat.format("Invalid field order in RAW parameter EXTENSION_BIT_GROUP for type `{0}'': `{1}'', `{2}''", this.getTypename(), fromIdentifier.getDisplayName(), toIdentifier.getDisplayName()));
                        continue block34;
                    }
                }
            }
            if (this.rawAttribute.paddall != -1) {
                for (i = 0; i < this.getNofComponents(); ++i) {
                    cField = this.getComponentByIndex(i);
                    fieldType = cField.getType();
                    RawAST fieldRawAttribute = fieldType.rawAttribute;
                    if (fieldRawAttribute == null) {
                        IType t = fieldType;
                        if (t instanceof Referenced_Type) {
                            ReferenceChain referenceChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
                            t = ((Referenced_Type)t).getTypeRefd(timestamp, referenceChain);
                            referenceChain.release();
                        }
                        while (t.getRawAttribute() == null && t instanceof Referenced_Type) {
                            ReferenceChain referenceChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
                            t = ((Referenced_Type)t).getTypeRefd(timestamp, referenceChain);
                            referenceChain.release();
                        }
                        fieldRawAttribute = new RawAST(t.getRawAttribute(), fieldType.getDefaultRawFieldLength());
                        fieldType.setRawAttributes(fieldRawAttribute);
                    }
                    if (fieldRawAttribute.padding == 0) {
                        fieldRawAttribute.padding = this.rawAttribute.padding;
                    }
                    if (fieldRawAttribute.prepadding == 0) {
                        fieldRawAttribute.prepadding = this.rawAttribute.prepadding;
                    }
                    if (fieldRawAttribute.padding_pattern_length != 0 || this.rawAttribute.padding_pattern_length <= 0) continue;
                    fieldRawAttribute.padding_pattern = this.rawAttribute.padding_pattern;
                    fieldRawAttribute.padding_pattern_length = this.rawAttribute.padding_pattern_length;
                }
            }
            if (this.rawAttribute.fieldorder != -1 || this.rawAttribute.csn1lh) {
                for (i = 0; i < this.getNofComponents(); ++i) {
                    cField = this.getComponentByIndex(i);
                    fieldType = cField.getType();
                    RawAST fieldRawAttribute = fieldType.rawAttribute;
                    if (fieldRawAttribute == null) {
                        Type t = fieldType;
                        while (t.rawAttribute == null && t instanceof IReferencingType) {
                            ReferenceChain tempRefChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
                            t = (Type)((IReferencingType)((Object)t)).getTypeRefd(timestamp, tempRefChain);
                            tempRefChain.release();
                        }
                        fieldRawAttribute = new RawAST(t.rawAttribute, fieldType.getDefaultRawFieldLength());
                        fieldType.setRawAttributes(fieldRawAttribute);
                    }
                    if (this.rawAttribute.fieldorder != -1 && fieldRawAttribute.fieldorder == -1) {
                        fieldRawAttribute.fieldorder = this.rawAttribute.fieldorder;
                    }
                    if (!this.rawAttribute.csn1lh) continue;
                    fieldRawAttribute.csn1lh = true;
                }
            }
        }
        if (this.ownerType != IType.TypeOwner_type.OT_COMP_FIELD && this.rawAttribute != null && this.rawAttribute.presence != null && this.rawAttribute.presence.keyList != null) {
            for (a = 0; a < this.rawAttribute.presence.keyList.size(); ++a) {
                Value v;
                RawAST.rawAST_tag_field_value tempTagFieldValue = this.rawAttribute.presence.keyList.get(a);
                Reference reference = new Reference(null);
                reference.addSubReference(new FieldSubReference(tempTagFieldValue.keyField.names.get(0)));
                for (int b = 1; b < tempTagFieldValue.keyField.names.size(); ++b) {
                    reference.addSubReference(new FieldSubReference(tempTagFieldValue.keyField.names.get(b)));
                }
                IType t = this.getFieldType(timestamp, reference, 0, Expected_Value_type.EXPECTED_DYNAMIC_VALUE, false);
                if (t == null || (v = tempTagFieldValue.v_value) == null) continue;
                v.setMyScope(this.getMyScope());
                v.setMyGovernor(t);
                IValue tempValue = t.checkThisValueRef(timestamp, v);
                t.checkThisValue(timestamp, tempValue, null, new IType.ValueCheckingOptions(Expected_Value_type.EXPECTED_CONSTANT, false, false, false, false, false));
            }
        }
        int usedBits = 0;
        for (int i = 0; i < this.getNofComponents(); ++i) {
            CompField cField = this.getComponentByIndex(i);
            Type fieldType = cField.getType();
            fieldType.forceRaw(timestamp);
            RawAST rawPar = fieldType.rawAttribute;
            if (rawPar == null) continue;
            Identifier fieldId = cField.getIdentifier();
            IType fieldTypeLast = fieldType.getTypeRefdLast(timestamp);
            if (rawPar.prepadding != 0) {
                usedBits = (usedBits + rawPar.prepadding - 1) / rawPar.prepadding * rawPar.prepadding;
            }
            if (rawPar.intX && fieldTypeLast.getTypetype() == IType.Type_type.TYPE_INTEGER) {
                if (usedBits % 8 != 0 && (this.rawAttribute == null || this.rawAttribute.fieldorder != 1)) {
                    this.getLocation().reportSemanticError(MessageFormat.format("Using RAW parameter IntX in a record/set with FIELDORDER set to 'lsb' is only supported if the IntX field starts at the beginning of a new octet. There are {0} unused bits in the last octet before field {1}.", 8 - usedBits % 8, fieldId.getDisplayName()));
                }
            } else if (rawPar.fieldlength > 0) {
                usedBits += rawPar.fieldlength;
            }
            if (rawPar.padding != 0) {
                usedBits = (usedBits + rawPar.padding - 1) / rawPar.padding * rawPar.padding;
            }
            if (rawPar.lengthto != null) {
                for (int j = 0; j < rawPar.lengthto.size(); ++j) {
                    Identifier id = rawPar.lengthto.get(j);
                    if (this.hasComponentWithName(id.getName())) continue;
                    id.getLocation().reportSemanticError(MessageFormat.format("Invalid fieldname in RAW parameter LENGTHTO for field {0}: {1}", fieldId.getDisplayName(), id.getDisplayName()));
                }
            }
            if (rawPar.lengthto != null) {
                IType ft = fieldType;
                switch (ft.getTypeRefdLast(timestamp).getTypetype()) {
                    case TYPE_INTEGER: 
                    case TYPE_INTEGER_A: {
                        break;
                    }
                    case TYPE_BITSTRING: 
                    case TYPE_BITSTRING_A: 
                    case TYPE_OCTETSTRING: {
                        boolean isOk = false;
                        while (!isOk) {
                            if (rawPar.fieldlength > 0 || ft.getSubtype() != null && ft.getSubtype().get_length_restriction() > 0) {
                                isOk = true;
                                break;
                            }
                            if (!ft.isReference()) break;
                            ReferenceChain tempRefChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
                            ft = ((IReferencingType)((Object)ft)).getTypeRefd(timestamp, tempRefChain);
                            tempRefChain.release();
                        }
                        if (isOk) break;
                        fieldId.getLocation().reportSemanticError(LENGTHTO_ERROR_MISSING_RESTRICTION);
                        break;
                    }
                    case TYPE_TTCN3_CHOICE: {
                        int fi;
                        Type choiceType = (TTCN3_Choice_Type)fieldTypeLast;
                        block45: for (fi = 0; fi < ((TTCN3_Set_Seq_Choice_BaseType)choiceType).getNofComponents(); ++fi) {
                            Type compType = ((TTCN3_Set_Seq_Choice_BaseType)choiceType).getComponentByIndex(fi).getType();
                            Identifier compFieldId = ((TTCN3_Set_Seq_Choice_BaseType)choiceType).getComponentByIndex(fi).getIdentifier();
                            switch (compType.getTypeRefdLast(timestamp).getTypetype()) {
                                case TYPE_INTEGER: 
                                case TYPE_INTEGER_A: {
                                    continue block45;
                                }
                                case TYPE_BITSTRING: 
                                case TYPE_BITSTRING_A: 
                                case TYPE_OCTETSTRING: {
                                    boolean isOk = false;
                                    while (!isOk) {
                                        if (compType.rawAttribute != null && compType.rawAttribute.fieldlength > 0 || choiceType.getSubtype() != null && choiceType.getSubtype().get_length_restriction() > 0) {
                                            isOk = true;
                                            break;
                                        }
                                        if (!compType.isReference()) break;
                                        ReferenceChain tempRefChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
                                        compType = (Type)((IReferencingType)((Object)compType)).getTypeRefd(timestamp, tempRefChain);
                                        tempRefChain.release();
                                    }
                                    if (isOk) continue block45;
                                    compFieldId.getLocation().reportSemanticError(LENGTHTO_ERROR_MISSING_RESTRICTION);
                                    continue block45;
                                }
                                default: {
                                    compFieldId.getLocation().reportSemanticError(LENGTHTO_ERROR_WRONG_TYPE);
                                }
                            }
                        }
                        break;
                    }
                    case TYPE_ASN1_CHOICE: {
                        int fi;
                        Type choiceType = (ASN1_Choice_Type)fieldTypeLast;
                        block47: for (fi = 0; fi < ((ASN1_Choice_Type)choiceType).getNofComponents(); ++fi) {
                            Type compType = ((ASN1_Set_Seq_Choice_BaseType)choiceType).getComponentByIndex(fi).getType();
                            Identifier compFieldId = ((ASN1_Set_Seq_Choice_BaseType)choiceType).getComponentByIndex(fi).getIdentifier();
                            switch (compType.getTypeRefdLast(timestamp).getTypetype()) {
                                case TYPE_INTEGER: 
                                case TYPE_INTEGER_A: {
                                    continue block47;
                                }
                                case TYPE_BITSTRING: 
                                case TYPE_BITSTRING_A: 
                                case TYPE_OCTETSTRING: {
                                    boolean isOk = false;
                                    while (!isOk) {
                                        if (compType.rawAttribute != null && compType.rawAttribute.fieldlength > 0 || choiceType.getSubtype() != null && choiceType.getSubtype().get_length_restriction() > 0) {
                                            isOk = true;
                                            break;
                                        }
                                        if (!compType.isReference()) break;
                                        ReferenceChain tempRefChain = ReferenceChain.getInstance("Circular reference chain: `{0}''", true);
                                        compType = (Type)((IReferencingType)((Object)compType)).getTypeRefd(timestamp, tempRefChain);
                                        tempRefChain.release();
                                    }
                                    if (isOk) continue block47;
                                    compFieldId.getLocation().reportSemanticError(LENGTHTO_ERROR_MISSING_RESTRICTION);
                                    continue block47;
                                }
                                default: {
                                    compFieldId.getLocation().reportSemanticError(LENGTHTO_ERROR_WRONG_TYPE);
                                }
                            }
                        }
                        break;
                    }
                    case TYPE_TTCN3_SEQUENCE: 
                    case TYPE_TTCN3_SET: 
                    case TYPE_ANYTYPE: 
                    case TYPE_OPENTYPE: 
                    case TYPE_ASN1_SEQUENCE: 
                    case TYPE_ASN1_SET: {
                        if (rawPar.lengthindex != null) break;
                    }
                    default: {
                        fieldId.getLocation().reportSemanticError(MessageFormat.format("The LENGTHTO field must be an integer, bitstring, octetstring or union type instead of `{0}''", fieldTypeLast.getTypename()));
                    }
                }
            }
            if (rawPar.lengthto != null && rawPar.lengthindex != null) {
                Identifier id = rawPar.lengthindex.names.get(0);
                switch (fieldTypeLast.getTypetype()) {
                    case TYPE_TTCN3_SEQUENCE: 
                    case TYPE_TTCN3_SET: 
                    case TYPE_TTCN3_CHOICE: {
                        if (((TTCN3_Set_Seq_Choice_BaseType)fieldTypeLast).hasComponentWithName(id.getName())) break;
                        id.getLocation().reportSemanticError(MessageFormat.format("Invalid fieldname in RAW parameter LENGTHINDEX for field {0}: {1}", fieldId.getDisplayName(), id.getDisplayName()));
                        break;
                    }
                    case TYPE_ASN1_CHOICE: 
                    case TYPE_ASN1_SEQUENCE: 
                    case TYPE_ASN1_SET: {
                        if (((ASN1_Set_Seq_Choice_BaseType)fieldTypeLast).hasComponentWithName(id)) break;
                        id.getLocation().reportSemanticError(MessageFormat.format("Invalid fieldname in RAW parameter LENGTHINDEX for field {0}: {1}", fieldId.getDisplayName(), id.getDisplayName()));
                        break;
                    }
                    default: {
                        fieldId.getLocation().reportSemanticError(MessageFormat.format("Invalid fieldmember type in RAW parameter LENGTHINDEX for field {0}.", fieldId.getDisplayName()));
                    }
                }
            }
            if (rawPar.pointerto != null) {
                Identifier id = rawPar.pointerto;
                boolean errorFound = false;
                int pointed = 0;
                if (!this.hasComponentWithName(id.getName())) {
                    id.getLocation().reportSemanticError(MessageFormat.format("Invalid fieldname in RAW parameter POINTERTO for field {0}: {1}", fieldId.getDisplayName(), id.getDisplayName()));
                    errorFound = true;
                }
                if (!errorFound && (pointed = this.getComponentIndexByName(id)) <= i) {
                    id.getLocation().reportSemanticError(MessageFormat.format("Pointer must precede the pointed field. Incorrect field name `{0}'' in RAW parameter POINTERTO for field `{1}''", id.getDisplayName(), fieldId.getDisplayName()));
                    errorFound = true;
                }
                if (!errorFound && rawPar.ptrbase != null) {
                    Identifier idf2 = rawPar.ptrbase;
                    if (!this.hasComponentWithName(idf2.getName())) {
                        idf2.getLocation().reportSemanticError(MessageFormat.format("Invalid field name `{0}'' in RAW parameter PTROFFSET for field `{1}''", idf2.getDisplayName(), fieldId.getDisplayName()));
                        errorFound = true;
                    }
                    if (!errorFound && this.getComponentIndexByName(idf2) > pointed) {
                        idf2.getLocation().reportSemanticError(MessageFormat.format("Pointer base must precede the pointed field. Incorrect field name `{0}'' in RAW parameter PTROFFSET for field `{1}''", idf2.getDisplayName(), fieldId.getDisplayName()));
                    }
                }
            }
            if (rawPar.presence != null && rawPar.presence.keyList != null) {
                for (int a3 = 0; a3 < rawPar.presence.keyList.size(); ++a3) {
                    Value v;
                    RawAST.rawAST_tag_field_value tempTagFieldValue = rawPar.presence.keyList.get(a3);
                    Reference reference = new Reference(null);
                    reference.addSubReference(new FieldSubReference(tempTagFieldValue.keyField.names.get(0)));
                    for (int b = 1; b < tempTagFieldValue.keyField.names.size(); ++b) {
                        reference.addSubReference(new FieldSubReference(tempTagFieldValue.keyField.names.get(b)));
                    }
                    IType t = this.getFieldType(timestamp, reference, 0, Expected_Value_type.EXPECTED_DYNAMIC_VALUE, false);
                    if (t == null || (v = tempTagFieldValue.v_value) == null) continue;
                    v.setMyScope(this.getMyScope());
                    v.setMyGovernor(t);
                    IValue tempValue = t.checkThisValueRef(timestamp, v);
                    t.checkThisValue(timestamp, tempValue, null, new IType.ValueCheckingOptions(Expected_Value_type.EXPECTED_CONSTANT, false, false, false, false, false));
                }
            }
            if (rawPar.forceOmit != null) {
                for (int j = 0; j < rawPar.forceOmit.lists.size(); ++j) {
                    RawAST.rawAST_field_list fieldList = rawPar.forceOmit.lists.get(j);
                    IType t = fieldTypeLast;
                    boolean erroneous = false;
                    boolean isOptional = false;
                    block52: for (int k = 0; k < fieldList.names.size(); ++k) {
                        Identifier idf = fieldList.names.get(k);
                        t = t.getTypeRefdLast(timestamp);
                        switch (t.getTypetype()) {
                            case TYPE_TTCN3_SEQUENCE: 
                            case TYPE_TTCN3_SET: 
                            case TYPE_TTCN3_CHOICE: {
                                if (!((TTCN3_Set_Seq_Choice_BaseType)t).hasComponentWithName(idf.getName())) {
                                    idf.getLocation().reportSemanticError(MessageFormat.format("Invalid field name `{0}'' in RAW parameter FORCEOMIT for field {1}", idf.getDisplayName(), fieldId.getDisplayName()));
                                    erroneous = true;
                                    continue block52;
                                }
                                CompField cf = ((TTCN3_Set_Seq_Choice_BaseType)t).getComponentByName(idf.getName());
                                t = cf.getType();
                                isOptional = cf.isOptional();
                                continue block52;
                            }
                            case TYPE_ASN1_CHOICE: 
                            case TYPE_ASN1_SEQUENCE: 
                            case TYPE_ASN1_SET: {
                                if (!((ASN1_Set_Seq_Choice_BaseType)t).hasComponentWithName(idf)) {
                                    idf.getLocation().reportSemanticError(MessageFormat.format("Invalid field name `{0}'' in RAW parameter FORCEOMIT for field {1}", idf.getDisplayName(), fieldId.getDisplayName()));
                                    erroneous = true;
                                    continue block52;
                                }
                                CompField cf = ((ASN1_Set_Seq_Choice_BaseType)t).getComponentByName(idf);
                                t = cf.getType();
                                isOptional = cf.isOptional();
                                continue block52;
                            }
                            default: {
                                idf.getLocation().reportSemanticError(MessageFormat.format("Invalid field type in RAW parameter FORCEOMIT for field {0}.", fieldId.getDisplayName()));
                                erroneous = true;
                            }
                        }
                    }
                    if (erroneous || isOptional) continue;
                    fieldId.getLocation().reportSemanticError(MessageFormat.format("RAW parameter FORCEOMIT for field {0} does not refer to an optional field.", fieldId.getDisplayName()));
                }
            }
            if (rawPar.crosstaglist == null) continue;
            for (int c = 0; c < rawPar.crosstaglist.size(); ++c) {
                RawAST.rawAST_single_tag singleTag = rawPar.crosstaglist.get(c);
                Identifier idf = singleTag.fieldName;
                boolean errorFound = false;
                switch (fieldTypeLast.getTypetype()) {
                    case TYPE_TTCN3_SEQUENCE: 
                    case TYPE_TTCN3_SET: 
                    case TYPE_TTCN3_CHOICE: {
                        if (idf == null) {
                            this.getLocation().reportSemanticError("Field member in RAW parameter CROSSTAG cannot be 'omit'");
                            errorFound = true;
                            break;
                        }
                        if (((TTCN3_Set_Seq_Choice_BaseType)fieldTypeLast).hasComponentWithName(idf.getName())) break;
                        idf.getLocation().reportSemanticError(MessageFormat.format("Invalid fieldname in RAW parameter CROSSTAG for field {0}: {1}", fieldId.getDisplayName(), idf.getDisplayName()));
                        errorFound = true;
                        break;
                    }
                    case TYPE_ASN1_CHOICE: 
                    case TYPE_ASN1_SEQUENCE: 
                    case TYPE_ASN1_SET: {
                        if (idf == null) {
                            this.getLocation().reportSemanticError("Field member in RAW parameter CROSSTAG cannot be 'omit'");
                            errorFound = true;
                            break;
                        }
                        if (((ASN1_Set_Seq_Choice_BaseType)fieldTypeLast).hasComponentWithName(idf)) break;
                        idf.getLocation().reportSemanticError(MessageFormat.format("Invalid fieldname in RAW parameter CROSSTAG for field {0}: {1}", fieldId.getDisplayName(), idf.getDisplayName()));
                        errorFound = true;
                        break;
                    }
                    default: {
                        fieldId.getLocation().reportSemanticError(MessageFormat.format("Invalid fieldmember type in RAW parameter CROSSTAG for field {0}.", fieldId.getDisplayName()));
                        errorFound = true;
                    }
                }
                if (errorFound || singleTag.keyList == null) continue;
                for (int a4 = 0; a4 < singleTag.keyList.size(); ++a4) {
                    Value v;
                    IType t2 = this;
                    boolean errorFound2 = false;
                    boolean allow_omit = false;
                    RawAST.rawAST_tag_field_value tagField = singleTag.keyList.get(a4);
                    for (int b = 0; b < tagField.keyField.names.size() && !errorFound2; ++b) {
                        Identifier idf2 = tagField.keyField.names.get(b);
                        CompField cf2 = null;
                        switch (t2.getTypetype()) {
                            case TYPE_TTCN3_SEQUENCE: 
                            case TYPE_TTCN3_SET: 
                            case TYPE_TTCN3_CHOICE: {
                                if (!t2.hasComponentWithName(idf2.getName())) {
                                    idf2.getLocation().reportSemanticError(MessageFormat.format("Invalid fieldname in RAW parameter CROSSTAG for field {0}: {1}", fieldId.getDisplayName(), idf2.getDisplayName()));
                                    errorFound2 = true;
                                    break;
                                }
                                cf2 = t2.getComponentByName(idf2.getName());
                                break;
                            }
                            case TYPE_ASN1_CHOICE: 
                            case TYPE_ASN1_SEQUENCE: 
                            case TYPE_ASN1_SET: {
                                if (!((ASN1_Set_Seq_Choice_BaseType)t2).hasComponentWithName(idf2)) {
                                    idf2.getLocation().reportSemanticError(MessageFormat.format("Invalid fieldname in RAW parameter CROSSTAG for field {0}: {1}", fieldId.getDisplayName(), idf2.getDisplayName()));
                                    errorFound2 = true;
                                    break;
                                }
                                cf2 = ((ASN1_Set_Seq_Choice_BaseType)t2).getComponentByName(idf2);
                                break;
                            }
                            default: {
                                fieldId.getLocation().reportSemanticError(MessageFormat.format("Invalid fieldmember type in RAW parameter CROSSTAG for field {0}.", fieldId.getDisplayName()));
                                errorFound2 = true;
                            }
                        }
                        if (b == 0) {
                            int fieldIndex = this.getComponentIndexByName(idf2);
                            if (fieldIndex == i) {
                                idf2.getLocation().reportSemanticError(MessageFormat.format("RAW parameter CROSSTAG for field `{0}'' cannot refer to the field itself", idf2.getDisplayName()));
                                errorFound2 = true;
                            } else if (fieldIndex > i && cField.isOptional()) {
                                idf2.getLocation().reportSemanticError(MessageFormat.format("Field `{0}'' that CROSSTAG refers to must precede field `{1}'' or field `{1}'' must be mandatory with fixed length", idf2.getDisplayName(), fieldId.getDisplayName()));
                                errorFound2 = true;
                            }
                        }
                        if (errorFound2) continue;
                        t2 = cf2.getType().getTypeRefdLast(timestamp);
                        if (b != tagField.keyField.names.size() - 1 || !cf2.isOptional()) continue;
                        allow_omit = true;
                    }
                    if (errorFound2 || (v = singleTag.keyList.get((int)a4).v_value) == null) continue;
                    v.setMyScope(this.getMyScope());
                    v.setMyGovernor(t2);
                    IValue tempValue = t2.checkThisValueRef(timestamp, v);
                    t2.checkThisValue(timestamp, tempValue, null, new IType.ValueCheckingOptions(Expected_Value_type.EXPECTED_CONSTANT, false, allow_omit, false, false, false));
                }
            }
        }
    }

    protected RawASTStruct convertRAWCodingAttributes(JavaGenData aData, StringBuilder source, boolean hasRaw, List<RecordSetCodeGenerator.FieldInfo> namesList) {
        RawASTStruct raw = null;
        if (hasRaw) {
            Identifier idf;
            RawAST dummy_raw = this.rawAttribute == null ? new RawAST(this.getDefaultRawFieldLength()) : this.rawAttribute;
            raw = new RawASTStruct(dummy_raw, this.ownerType != IType.TypeOwner_type.OT_COMP_FIELD);
            int taglistSize = dummy_raw.taglist == null ? 0 : dummy_raw.taglist.size();
            for (int c = 0; c < taglistSize; ++c) {
                RawAST.rawAST_single_tag singleTag = dummy_raw.taglist.get(c);
                RawASTStruct.rawAST_coding_taglist codingSingleTag = raw.taglist.list.get(c);
                if (singleTag.keyList != null) {
                    codingSingleTag.fields = new ArrayList(singleTag.keyList.size());
                }
                codingSingleTag.fieldname = singleTag.fieldName.getName();
                codingSingleTag.varName = FieldSubReference.getJavaGetterName(codingSingleTag.fieldname);
                idf = singleTag.fieldName;
                codingSingleTag.fieldnum = this.getComponentIndexByName(idf);
                int keyListSize = singleTag.keyList == null ? 0 : singleTag.keyList.size();
                for (int a = 0; a < keyListSize; ++a) {
                    RawAST.rawAST_tag_field_value key = singleTag.keyList.get(a);
                    RawASTStruct.rawAST_coding_field_list codingKey = new RawASTStruct.rawAST_coding_field_list();
                    codingSingleTag.fields.add(codingKey);
                    codingKey.fields = new ArrayList(key.keyField.names.size());
                    ExpressionStruct expression = new ExpressionStruct();
                    key.v_value.generateCodeExpression(aData, expression, true);
                    codingKey.expression = expression;
                    ExpressionStruct nativeExpression = new ExpressionStruct();
                    key.v_value.generateCodeExpression(aData, nativeExpression, false);
                    codingKey.nativeExpression = nativeExpression;
                    codingKey.isOmitValue = key.v_value.getValuetype() == IValue.Value_type.OMIT_VALUE;
                    codingKey.start_pos = 0;
                    CompField cf = this.getComponentByIndex(codingSingleTag.fieldnum);
                    IType t = cf.getType().getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp());
                    RawASTStruct.rawAST_coding_fields tempField = new RawASTStruct.rawAST_coding_fields();
                    tempField.nthfield = codingSingleTag.fieldnum;
                    tempField.nthfieldname = singleTag.fieldName.getName();
                    tempField.fieldtype = RawASTStruct.rawAST_coding_field_type.UNION_FIELD;
                    tempField.type = t.getGenNameValue(aData, source);
                    tempField.typedesc = t.getGenNameTypeDescriptor(aData, source);
                    tempField.unionType = this.getGenNameValue(aData, source);
                    tempField.fieldtype = cf.isOptional() ? RawASTStruct.rawAST_coding_field_type.OPTIONAL_FIELD : RawASTStruct.rawAST_coding_field_type.MANDATORY_FIELD;
                    codingKey.fields.add(tempField);
                    for (int b = 0; b < key.keyField.names.size(); ++b) {
                        CompField cf2;
                        RawASTStruct.rawAST_coding_fields newField = new RawASTStruct.rawAST_coding_fields();
                        codingKey.fields.add(newField);
                        Identifier idf2 = key.keyField.names.get(b);
                        int comp_index = 0;
                        switch (t.getTypetype()) {
                            case TYPE_TTCN3_CHOICE: {
                                comp_index = ((TTCN3_Choice_Type)t).getComponentIndexByName(idf2);
                                cf2 = ((TTCN3_Choice_Type)t).getComponentByIndex(comp_index);
                                newField.nthfield = comp_index;
                                newField.nthfieldname = idf2.getName();
                                newField.fieldtype = RawASTStruct.rawAST_coding_field_type.UNION_FIELD;
                                newField.unionType = t.getGenNameValue(aData, source);
                                break;
                            }
                            case TYPE_TTCN3_SEQUENCE: 
                            case TYPE_TTCN3_SET: {
                                comp_index = ((TTCN3_Set_Seq_Choice_BaseType)t).getComponentIndexByName(idf2);
                                cf2 = ((TTCN3_Set_Seq_Choice_BaseType)t).getComponentByIndex(comp_index);
                                newField.nthfield = comp_index;
                                newField.nthfieldname = idf2.getName();
                                if (cf2.isOptional()) {
                                    newField.fieldtype = RawASTStruct.rawAST_coding_field_type.OPTIONAL_FIELD;
                                    break;
                                }
                                newField.fieldtype = RawASTStruct.rawAST_coding_field_type.MANDATORY_FIELD;
                                break;
                            }
                            default: {
                                return null;
                            }
                        }
                        Type field_type = cf2.getType();
                        newField.type = field_type.getGenNameValue(aData, source);
                        newField.typedesc = field_type.getGenNameTypeDescriptor(aData, source);
                        if (field_type.getTypetype() == IType.Type_type.TYPE_TTCN3_SEQUENCE && ((TTCN3_Sequence_Type)field_type).rawAttribute != null && (((TTCN3_Sequence_Type)field_type).rawAttribute.pointerto == null || ((TTCN3_Sequence_Type)field_type).rawAttribute.lengthto != null)) {
                            codingKey.start_pos = -1;
                        }
                        if (t.getTypetype() == IType.Type_type.TYPE_TTCN3_SEQUENCE) {
                            for (int i = 0; i < comp_index && codingKey.start_pos >= 0; ++i) {
                                Type t2 = ((TTCN3_Sequence_Type)t).getComponentByIndex(i).getType();
                                if (t2.getRawLength(aData.getBuildTimstamp()) >= 0) {
                                    if (t2.rawAttribute != null) {
                                        codingKey.start_pos += t2.rawAttribute.padding;
                                    }
                                    codingKey.start_pos += t2.getRawLength(aData.getBuildTimstamp());
                                    continue;
                                }
                                codingKey.start_pos = -1;
                            }
                        }
                        if ((t = field_type.getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp())).getTypetype() != IType.Type_type.TYPE_ASN1_ENUMERATED && t.getTypetype() != IType.Type_type.TYPE_TTCN3_ENUMERATED) continue;
                        newField.refersEnum = true;
                    }
                }
            }
            if (this.ownerType != IType.TypeOwner_type.OT_COMP_FIELD) {
                int presenceListSize = dummy_raw.presence == null || dummy_raw.presence.keyList == null ? 0 : dummy_raw.presence.keyList.size();
                for (int a = 0; a < presenceListSize; ++a) {
                    RawAST.rawAST_tag_field_value fieldValue = dummy_raw.presence.keyList.get(a);
                    RawASTStruct.rawAST_coding_field_list presences = new RawASTStruct.rawAST_coding_field_list();
                    raw.presence.fields.add(presences);
                    ExpressionStruct expression = new ExpressionStruct();
                    fieldValue.v_value.generateCodeExpression(aData, expression, true);
                    presences.expression = expression;
                    ExpressionStruct nativeExpression = new ExpressionStruct();
                    fieldValue.v_value.generateCodeExpression(aData, nativeExpression, false);
                    presences.nativeExpression = nativeExpression;
                    presences.isOmitValue = fieldValue.v_value.getValuetype() == IValue.Value_type.OMIT_VALUE;
                    int keySize = fieldValue.keyField == null || fieldValue.keyField.names == null ? 0 : fieldValue.keyField.names.size();
                    presences.fields = new ArrayList(keySize);
                    IType t = this;
                    for (int b = 0; b < keySize; ++b) {
                        CompField cf2;
                        RawASTStruct.rawAST_coding_fields newField = new RawASTStruct.rawAST_coding_fields();
                        presences.fields.add(newField);
                        Identifier idf2 = fieldValue.keyField.names.get(b);
                        int comp_index = 0;
                        switch (t.getTypetype()) {
                            case TYPE_TTCN3_CHOICE: {
                                comp_index = ((TTCN3_Choice_Type)t).getComponentIndexByName(idf2);
                                cf2 = ((TTCN3_Choice_Type)t).getComponentByIndex(comp_index);
                                newField.nthfield = comp_index;
                                newField.nthfieldname = idf2.getName();
                                newField.fieldtype = RawASTStruct.rawAST_coding_field_type.UNION_FIELD;
                                newField.unionType = t.getGenNameValue(aData, source);
                                break;
                            }
                            case TYPE_TTCN3_SEQUENCE: 
                            case TYPE_TTCN3_SET: {
                                comp_index = t.getComponentIndexByName(idf2);
                                cf2 = t.getComponentByIndex(comp_index);
                                newField.nthfield = comp_index;
                                newField.nthfieldname = idf2.getName();
                                if (cf2.isOptional()) {
                                    newField.fieldtype = RawASTStruct.rawAST_coding_field_type.OPTIONAL_FIELD;
                                    break;
                                }
                                newField.fieldtype = RawASTStruct.rawAST_coding_field_type.MANDATORY_FIELD;
                                break;
                            }
                            default: {
                                return null;
                            }
                        }
                        Type field_type = cf2.getType();
                        newField.type = field_type.getGenNameValue(aData, source);
                        newField.typedesc = field_type.getGenNameTypeDescriptor(aData, source);
                        t = field_type.getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp());
                    }
                }
            }
            int extBiGroupSize = dummy_raw.ext_bit_groups == null ? 0 : dummy_raw.ext_bit_groups.size();
            for (int c = 0; c < extBiGroupSize; ++c) {
                RawAST.rawAST_ext_bit_group tempGroup = dummy_raw.ext_bit_groups.get(c);
                idf = tempGroup.from;
                Identifier idf2 = tempGroup.to;
                RawASTStruct.rawAST_coding_ext_group codingGroup = new RawASTStruct.rawAST_coding_ext_group();
                raw.ext_bit_groups.add(codingGroup);
                codingGroup.ext_bit = tempGroup.ext_bit;
                codingGroup.from = this.getComponentIndexByName(idf);
                codingGroup.to = this.getComponentIndexByName(idf2);
            }
            for (int i = 0; i < this.getNofComponents(); ++i) {
                RecordSetCodeGenerator.FieldInfo element_i = namesList.get(i);
                CompField cf = this.getComponentByIndex(i);
                Type t_field = cf.getType();
                IType t_field_last = t_field.getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp());
                RawAST rawpar = t_field.getRawAttribute();
                if (rawpar != null) {
                    element_i.raw = new RawASTStruct(rawpar, true);
                    int lengthtoNum = rawpar.lengthto == null ? 0 : rawpar.lengthto.size();
                    for (int j = 0; j < lengthtoNum; ++j) {
                        Identifier idf2 = rawpar.lengthto.get(j);
                        element_i.raw.lengthto.add(this.getComponentIndexByName(idf2));
                    }
                    if (lengthtoNum > 0 && rawpar.lengthindex != null) {
                        CompField cf2;
                        Identifier idf3 = rawpar.lengthindex.names.get(0);
                        int comp_index = 0;
                        switch (t_field_last.getTypetype()) {
                            case TYPE_TTCN3_CHOICE: {
                                comp_index = ((TTCN3_Choice_Type)t_field_last).getComponentIndexByName(idf3);
                                cf2 = ((TTCN3_Choice_Type)t_field_last).getComponentByIndex(comp_index);
                                element_i.raw.lengthindex.nthfield = comp_index;
                                element_i.raw.lengthindex.nthfieldname = idf3.getName();
                                break;
                            }
                            case TYPE_TTCN3_SEQUENCE: 
                            case TYPE_TTCN3_SET: {
                                comp_index = ((TTCN3_Set_Seq_Choice_BaseType)t_field_last).getComponentIndexByName(idf3);
                                cf2 = ((TTCN3_Set_Seq_Choice_BaseType)t_field_last).getComponentByIndex(comp_index);
                                element_i.raw.lengthindex.nthfield = comp_index;
                                element_i.raw.lengthindex.nthfieldname = idf3.getName();
                                break;
                            }
                            default: {
                                return null;
                            }
                        }
                        Type t_field2 = cf2.getType();
                        if (t_field2.getTypetype() == IType.Type_type.TYPE_TTCN3_CHOICE) {
                            element_i.raw.lengthindex.fieldtype = RawASTStruct.rawAST_coding_field_type.UNION_FIELD;
                            element_i.raw.lengthindex.unionType = t_field2.getGenNameValue(aData, source);
                        } else {
                            element_i.raw.lengthindex.fieldtype = cf2.isOptional() ? RawASTStruct.rawAST_coding_field_type.OPTIONAL_FIELD : RawASTStruct.rawAST_coding_field_type.MANDATORY_FIELD;
                        }
                        element_i.raw.lengthindex.type = t_field2.getGenNameValue(aData, source);
                        element_i.raw.lengthindex.typedesc = t_field2.getGenNameTypeDescriptor(aData, source);
                    }
                    if (lengthtoNum > 0 && rawpar.lengthindex == null) {
                        switch (t_field_last.getTypetype()) {
                            case TYPE_TTCN3_SEQUENCE: 
                            case TYPE_TTCN3_SET: 
                            case TYPE_TTCN3_CHOICE: {
                                int componentsNumber;
                                element_i.raw.union_member_num = componentsNumber = ((TTCN3_Set_Seq_Choice_BaseType)t_field_last).getNofComponents();
                                element_i.raw.member_name = new ArrayList(componentsNumber + 1);
                                element_i.raw.member_name.add(t_field_last.getGenNameValue(aData, source));
                                for (int m = 1; m < componentsNumber + 1; ++m) {
                                    CompField compf = ((TTCN3_Set_Seq_Choice_BaseType)t_field_last).getComponentByIndex(m - 1);
                                    element_i.raw.member_name.add(compf.getIdentifier().getName());
                                }
                                break;
                            }
                        }
                    }
                    if (rawpar.pointerto != null) {
                        Identifier idf4 = rawpar.pointerto;
                        element_i.raw.pointerto = this.getComponentIndexByName(idf4);
                        if (rawpar.ptrbase != null) {
                            Identifier idf2 = rawpar.ptrbase;
                            element_i.raw.pointerbase = this.getComponentIndexByName(idf2);
                        } else {
                            element_i.raw.pointerbase = i;
                        }
                    }
                    int parPresenceListSize = rawpar.presence == null || rawpar.presence.keyList == null ? 0 : rawpar.presence.keyList.size();
                    for (int a = 0; a < parPresenceListSize; ++a) {
                        RawASTStruct.rawAST_coding_field_list presences = new RawASTStruct.rawAST_coding_field_list();
                        element_i.raw.presence.fields.add(presences);
                        RawAST.rawAST_tag_field_value fieldValue = rawpar.presence.keyList.get(a);
                        ExpressionStruct expression = new ExpressionStruct();
                        fieldValue.v_value.generateCodeExpression(aData, expression, true);
                        presences.expression = expression;
                        ExpressionStruct nativeExpression = new ExpressionStruct();
                        fieldValue.v_value.generateCodeExpression(aData, nativeExpression, false);
                        presences.nativeExpression = nativeExpression;
                        presences.isOmitValue = fieldValue.v_value.getValuetype() == IValue.Value_type.OMIT_VALUE;
                        presences.fields = new ArrayList(fieldValue.keyField.names.size());
                        IType t = this;
                        for (int b = 0; b < fieldValue.keyField.names.size(); ++b) {
                            CompField cf2;
                            RawASTStruct.rawAST_coding_fields newField = new RawASTStruct.rawAST_coding_fields();
                            presences.fields.add(newField);
                            Identifier idf2 = fieldValue.keyField.names.get(b);
                            int comp_index = 0;
                            switch (t.getTypetype()) {
                                case TYPE_TTCN3_CHOICE: {
                                    comp_index = ((TTCN3_Choice_Type)t).getComponentIndexByName(idf2);
                                    cf2 = ((TTCN3_Choice_Type)t).getComponentByIndex(comp_index);
                                    newField.nthfield = comp_index;
                                    newField.nthfieldname = idf2.getName();
                                    newField.fieldtype = RawASTStruct.rawAST_coding_field_type.UNION_FIELD;
                                    newField.unionType = t.getGenNameValue(aData, source);
                                    break;
                                }
                                case TYPE_TTCN3_SEQUENCE: 
                                case TYPE_TTCN3_SET: {
                                    comp_index = t.getComponentIndexByName(idf2);
                                    cf2 = t.getComponentByIndex(comp_index);
                                    newField.nthfield = comp_index;
                                    newField.nthfieldname = idf2.getName();
                                    if (cf2.isOptional()) {
                                        newField.fieldtype = RawASTStruct.rawAST_coding_field_type.OPTIONAL_FIELD;
                                        break;
                                    }
                                    newField.fieldtype = RawASTStruct.rawAST_coding_field_type.MANDATORY_FIELD;
                                    break;
                                }
                                default: {
                                    return null;
                                }
                            }
                            Type field_type = cf2.getType();
                            newField.type = field_type.getGenNameValue(aData, source);
                            newField.typedesc = field_type.getGenNameTypeDescriptor(aData, source);
                            t = field_type.getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp());
                        }
                    }
                    int crossTaglistSize = rawpar.crosstaglist == null ? 0 : rawpar.crosstaglist.size();
                    block39: for (int c = 0; c < crossTaglistSize; ++c) {
                        RawAST.rawAST_single_tag singleTag = rawpar.crosstaglist.get(c);
                        RawASTStruct.rawAST_coding_taglist codingSingleTag = element_i.raw.crosstaglist.list.get(c);
                        if (singleTag.keyList != null) {
                            codingSingleTag.fields = new ArrayList(singleTag.keyList.size());
                        }
                        codingSingleTag.fieldname = singleTag.fieldName.getName();
                        codingSingleTag.varName = FieldSubReference.getJavaGetterName(codingSingleTag.fieldname);
                        Identifier idf5 = singleTag.fieldName;
                        switch (t_field_last.getTypetype()) {
                            case TYPE_TTCN3_SEQUENCE: 
                            case TYPE_TTCN3_SET: 
                            case TYPE_TTCN3_CHOICE: {
                                codingSingleTag.fieldnum = ((TTCN3_Set_Seq_Choice_BaseType)t_field_last).getComponentIndexByName(idf5);
                                break;
                            }
                            case TYPE_ASN1_CHOICE: {
                                codingSingleTag.fieldnum = ((ASN1_Set_Seq_Choice_BaseType)t_field_last).getComponentIndexByName(idf5);
                                break;
                            }
                            default: {
                                codingSingleTag.fieldnum = -1;
                            }
                        }
                        int keyListSize = singleTag.keyList == null ? 0 : singleTag.keyList.size();
                        for (int a = 0; a < keyListSize; ++a) {
                            RawAST.rawAST_tag_field_value key = singleTag.keyList.get(a);
                            RawASTStruct.rawAST_coding_field_list codingKey = new RawASTStruct.rawAST_coding_field_list();
                            codingSingleTag.fields.add(codingKey);
                            codingKey.fields = new ArrayList(key.keyField.names.size());
                            ExpressionStruct expression = new ExpressionStruct();
                            key.v_value.generateCodeExpression(aData, expression, true);
                            codingKey.expression = expression;
                            ExpressionStruct nativeExpression = new ExpressionStruct();
                            key.v_value.generateCodeExpression(aData, nativeExpression, false);
                            codingKey.nativeExpression = nativeExpression;
                            boolean bl = codingKey.isOmitValue = key.v_value.getValuetype() == IValue.Value_type.OMIT_VALUE;
                            if (codingKey.isOmitValue && key.keyField.names.size() != 1) {
                                this.getLocation().reportSemanticError("omit value with multiple fields in CROSSTAG");
                                continue block39;
                            }
                            IType t = this;
                            for (int b = 0; b < key.keyField.names.size(); ++b) {
                                CompField cf2;
                                RawASTStruct.rawAST_coding_fields newField = new RawASTStruct.rawAST_coding_fields();
                                codingKey.fields.add(newField);
                                Identifier idf2 = key.keyField.names.get(b);
                                int comp_index = 0;
                                switch (t.getTypetype()) {
                                    case TYPE_TTCN3_CHOICE: {
                                        comp_index = ((TTCN3_Choice_Type)t).getComponentIndexByName(idf2);
                                        cf2 = ((TTCN3_Choice_Type)t).getComponentByIndex(comp_index);
                                        newField.nthfield = comp_index;
                                        newField.nthfieldname = idf2.getName();
                                        newField.fieldtype = RawASTStruct.rawAST_coding_field_type.UNION_FIELD;
                                        newField.unionType = t.getGenNameValue(aData, source);
                                        break;
                                    }
                                    case TYPE_TTCN3_SEQUENCE: 
                                    case TYPE_TTCN3_SET: {
                                        comp_index = ((TTCN3_Set_Seq_Choice_BaseType)t).getComponentIndexByName(idf2);
                                        cf2 = ((TTCN3_Set_Seq_Choice_BaseType)t).getComponentByIndex(comp_index);
                                        newField.nthfield = comp_index;
                                        newField.nthfieldname = idf2.getName();
                                        if (cf2.isOptional()) {
                                            newField.fieldtype = RawASTStruct.rawAST_coding_field_type.OPTIONAL_FIELD;
                                            break;
                                        }
                                        newField.fieldtype = RawASTStruct.rawAST_coding_field_type.MANDATORY_FIELD;
                                        break;
                                    }
                                    default: {
                                        return null;
                                    }
                                }
                                Type field_type = cf2.getType();
                                newField.type = field_type.getGenNameValue(aData, source);
                                newField.typedesc = field_type.getGenNameTypeDescriptor(aData, source);
                                t = field_type.getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp());
                                if (t.getTypetype() != IType.Type_type.TYPE_ASN1_ENUMERATED && t.getTypetype() != IType.Type_type.TYPE_TTCN3_ENUMERATED) continue;
                                newField.refersEnum = true;
                                IValue last = key.v_value.getValueRefdLast(CompilationTimeStamp.getBaseTimestamp(), null);
                                if (last.getValuetype() != IValue.Value_type.ENUMERATED_VALUE) continue;
                                newField.enumValue = ((Enumerated_Value)last).getValue().getName();
                            }
                        }
                    }
                    element_i.raw.length = t_field.getRawLength(aData.getBuildTimstamp());
                    element_i.hasRaw = true;
                    continue;
                }
                element_i.hasRaw = false;
            }
        }
        return raw;
    }

    @Override
    public void setGenerateCoderFunctions(CompilationTimeStamp timestamp, IType.MessageEncoding_type encodingType) {
        switch (encodingType) {
            case RAW: 
            case JSON: {
                break;
            }
            default: {
                return;
            }
        }
        if (this.getGenerateCoderFunctions(encodingType)) {
            return;
        }
        this.codersToGenerate.add(encodingType);
        for (CompField compField : this.compFieldMap.fields) {
            Type cftype = compField.getType();
            if (cftype == null) continue;
            cftype.getTypeRefdLast(timestamp).setGenerateCoderFunctions(timestamp, encodingType);
        }
    }

    @Override
    public boolean needsOwnRawDescriptor(JavaGenData aData) {
        return true;
    }

    @Override
    public String getGenNameRawDescriptor(JavaGenData aData, StringBuilder source) {
        return this.getGenNameOwn(aData) + "_raw_";
    }

    @Override
    public boolean needsOwnJsonDescriptor(JavaGenData aData) {
        return true;
    }

    @Override
    public String getGenNameJsonDescriptor(JavaGenData aData, StringBuilder source) {
        return this.getGenNameOwn(aData) + "_json_";
    }

    @Override
    public void generateCodeIsPresentBoundChosen(JavaGenData aData, ExpressionStruct expression, List<ISubReference> subreferences, int subReferenceIndex, String globalId, String externalId, boolean isTemplate, Expression_Value.Operation_type optype, String field, Scope targetScope) {
        boolean nextOptional;
        ISubReference subReference;
        if (subreferences == null || this.getIsErroneous(CompilationTimeStamp.getBaseTimestamp())) {
            return;
        }
        if (subReferenceIndex >= subreferences.size()) {
            return;
        }
        StringBuilder closingBrackets = new StringBuilder();
        if (isTemplate) {
            boolean anyvalueReturnValue = true;
            if (optype == Expression_Value.Operation_type.ISPRESENT_OPERATION) {
                anyvalueReturnValue = this.isPresentAnyvalueEmbeddedField(expression, subreferences, subReferenceIndex);
            } else if (optype == Expression_Value.Operation_type.ISCHOOSEN_OPERATION || optype == Expression_Value.Operation_type.ISVALUE_OPERATION) {
                anyvalueReturnValue = false;
            }
            expression.expression.append(MessageFormat.format("if({0}) '{'\n", globalId));
            expression.expression.append(MessageFormat.format("switch({0}.get_selection()) '{'\n", externalId));
            expression.expression.append("case UNINITIALIZED_TEMPLATE:\n");
            expression.expression.append(MessageFormat.format("{0} = false;\n", globalId));
            expression.expression.append("break;\n");
            expression.expression.append("case ANY_VALUE:\n");
            expression.expression.append(MessageFormat.format("{0} = {1};\n", globalId, anyvalueReturnValue ? "true" : "false"));
            expression.expression.append("break;\n");
            expression.expression.append("case SPECIFIC_VALUE:{\n");
            closingBrackets.append("break;}\n");
            closingBrackets.append("default:\n");
            closingBrackets.append(MessageFormat.format("{0} = false;\n", globalId));
            closingBrackets.append("break;\n");
            closingBrackets.append("}\n");
            closingBrackets.append("}\n");
        }
        if (!((subReference = subreferences.get(subReferenceIndex)) instanceof FieldSubReference)) {
            ErrorReporter.INTERNAL_ERROR((String)("Code generator reached erroneous type reference `" + this.getFullName() + "''"));
            expression.expression.append("FATAL_ERROR encountered while processing `" + this.getFullName() + "''\n");
            return;
        }
        Identifier fieldId = ((FieldSubReference)subReference).getId();
        CompField compField = this.getComponentByName(fieldId.getName());
        Type nextType = compField.getType();
        String currentTypeGenName = isTemplate ? this.getGenNameTemplate(aData, expression.expression) : this.getGenNameValue(aData, expression.expression);
        String nextTypeGenName = isTemplate ? nextType.getGenNameTemplate(aData, expression.expression) : nextType.getGenNameValue(aData, expression.expression);
        boolean bl = nextOptional = !isTemplate && compField.isOptional();
        if (nextOptional) {
            expression.expression.append(MessageFormat.format("if({0}) '{'\n", globalId));
            closingBrackets.insert(0, "}\n");
            String temporalId = aData.getTemporaryVariableName();
            aData.addBuiltinTypeImport("Optional");
            expression.expression.append(MessageFormat.format("final Optional<{0}> {1} = {2}.get_field_{3}();\n", nextTypeGenName, temporalId, externalId, FieldSubReference.getJavaGetterName(fieldId.getName())));
            if (subReferenceIndex == subreferences.size() - 1) {
                expression.expression.append(MessageFormat.format("switch({0}.get_selection()) '{'\n", temporalId));
                expression.expression.append("case OPTIONAL_UNBOUND:\n");
                expression.expression.append(MessageFormat.format("{0} = false;\n", globalId));
                expression.expression.append("break;\n");
                expression.expression.append("case OPTIONAL_OMIT:\n");
                expression.expression.append(MessageFormat.format("{0} = {1};\n", globalId, optype == Expression_Value.Operation_type.ISBOUND_OPERATION ? "true" : "false"));
                expression.expression.append("break;\n");
                expression.expression.append("default:\n");
                expression.expression.append("{\n");
                String temporalId2 = aData.getTemporaryVariableName();
                expression.expression.append(MessageFormat.format("final {0} {1} = {2}.constGet();\n", nextTypeGenName, temporalId2, temporalId));
                if (optype == Expression_Value.Operation_type.ISBOUND_OPERATION) {
                    expression.expression.append(MessageFormat.format("{0} = {1}.is_bound();\n", globalId, temporalId2));
                } else if (optype == Expression_Value.Operation_type.ISVALUE_OPERATION) {
                    expression.expression.append(MessageFormat.format("{0} = {1}.is_value();\n", globalId, temporalId2));
                } else if (optype == Expression_Value.Operation_type.ISPRESENT_OPERATION) {
                    expression.expression.append(MessageFormat.format("{0} = {1}.is_present({2});\n", globalId, temporalId2, isTemplate && aData.getAllowOmitInValueList() ? "true" : ""));
                } else if (optype == Expression_Value.Operation_type.ISCHOOSEN_OPERATION) {
                    expression.expression.append(MessageFormat.format("{0} = {1}.ischosen({2});\n", globalId, temporalId2, field));
                }
                expression.expression.append("break;}\n");
                expression.expression.append("}\n");
                nextType.generateCodeIsPresentBoundChosen(aData, expression, subreferences, subReferenceIndex + 1, globalId, temporalId2, isTemplate, optype, field, targetScope);
            } else {
                expression.expression.append(MessageFormat.format("switch({0}.get_selection()) '{'\n", temporalId));
                expression.expression.append("case OPTIONAL_UNBOUND:\n");
                expression.expression.append("case OPTIONAL_OMIT:\n");
                expression.expression.append(MessageFormat.format("{0} = false;\n", globalId));
                expression.expression.append("break;\n");
                expression.expression.append("default:\n");
                expression.expression.append("break;\n");
                expression.expression.append("}\n");
                expression.expression.append(MessageFormat.format("if({0}) '{'\n", globalId));
                closingBrackets.insert(0, "}\n");
                String temporalId2 = aData.getTemporaryVariableName();
                expression.expression.append(MessageFormat.format("final {0} {1} = {2}.constGet();\n", nextTypeGenName, temporalId2, temporalId));
                expression.expression.append(MessageFormat.format("{0} = {1}.is_bound();\n", globalId, temporalId2));
                nextType.generateCodeIsPresentBoundChosen(aData, expression, subreferences, subReferenceIndex + 1, globalId, temporalId2, isTemplate, optype, field, targetScope);
            }
        } else {
            expression.expression.append(MessageFormat.format("if({0}) '{'\n", globalId));
            closingBrackets.insert(0, "}\n");
            String temporalId = aData.getTemporaryVariableName();
            String temporalId2 = aData.getTemporaryVariableName();
            expression.expression.append(MessageFormat.format("final {0} {1} = {2};\n", currentTypeGenName, temporalId, externalId));
            expression.expression.append(MessageFormat.format("final {0} {1} = {2}.get_field_{3}();\n", nextTypeGenName, temporalId2, temporalId, FieldSubReference.getJavaGetterName(fieldId.getName())));
            if (optype == Expression_Value.Operation_type.ISBOUND_OPERATION) {
                expression.expression.append(MessageFormat.format("{0} = {1}.is_bound();\n", globalId, temporalId2));
            } else if (optype == Expression_Value.Operation_type.ISVALUE_OPERATION) {
                expression.expression.append(MessageFormat.format("{0} = {1}.is_value();\n", globalId, temporalId2));
            } else if (optype == Expression_Value.Operation_type.ISPRESENT_OPERATION) {
                expression.expression.append(MessageFormat.format("{0} = {1}.{2}({3});\n", globalId, temporalId2, subReferenceIndex != subreferences.size() - 1 ? "is_bound" : "is_present", subReferenceIndex == subreferences.size() - 1 && isTemplate && aData.getAllowOmitInValueList() ? "true" : ""));
            } else if (optype == Expression_Value.Operation_type.ISCHOOSEN_OPERATION) {
                expression.expression.append(MessageFormat.format("{0} = {1}.is_bound();\n", globalId, temporalId2));
                if (subReferenceIndex == subreferences.size() - 1) {
                    expression.expression.append(MessageFormat.format("if ({0}) '{'\n", globalId));
                    expression.expression.append(MessageFormat.format("{0} = {1}.ischosen({2});\n", globalId, temporalId2, field));
                    expression.expression.append("}\n");
                }
            }
            nextType.generateCodeIsPresentBoundChosen(aData, expression, subreferences, subReferenceIndex + 1, globalId, temporalId2, isTemplate, optype, field, targetScope);
        }
        expression.expression.append((CharSequence)closingBrackets);
    }

    protected String generateConversionTTCNSetSeqToTTCNSetSeq(JavaGenData aData, TTCN3_Set_Seq_Choice_BaseType fromType, String fromName, boolean forValue, ExpressionStruct expression) {
        String tempId = aData.getTemporaryVariableName();
        String name = forValue ? this.getGenNameValue(aData, expression.preamble) : this.getGenNameTemplate(aData, expression.preamble);
        expression.preamble.append(MessageFormat.format("final {0} {1} = new {0}();\n", name, tempId));
        String ConversionFunctionName = Type.getConversionFunction(aData, fromType, this, forValue, expression.preamble);
        expression.preamble.append(MessageFormat.format("if(!{0}({1}, {2})) '{'\n", ConversionFunctionName, tempId, fromName));
        expression.preamble.append(MessageFormat.format("throw new TtcnError(\"Values or templates of type `{0}'' and `{1}'' are not compatible at run-time\");\n", this.getTypename(), fromType.getTypename()));
        expression.preamble.append("}\n");
        if (!aData.hasTypeConversion(ConversionFunctionName)) {
            StringBuilder conversionFunctionBody = new StringBuilder();
            String fromTypeName = forValue ? fromType.getGenNameValue(aData, conversionFunctionBody) : fromType.getGenNameTemplate(aData, conversionFunctionBody);
            conversionFunctionBody.append(MessageFormat.format("\tpublic static boolean {0}(final {1} to, final {2} from) '{'\n", ConversionFunctionName, name, fromTypeName));
            for (int i = 0; i < this.getNofComponents(); ++i) {
                String tempId2;
                String fromFieldTypeName;
                CompField toComp = this.getComponentByIndex(i);
                CompField fromComp = fromType.getComponentByIndex(i);
                Identifier toFieldName = toComp.getIdentifier();
                Identifier fromFieldName = fromComp.getIdentifier();
                IType toFieldType = toComp.getType().getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp());
                IType fromFieldType = fromComp.getType().getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp());
                String string = fromFieldTypeName = forValue ? fromFieldType.getGenNameValue(aData, conversionFunctionBody) : fromFieldType.getGenNameTemplate(aData, conversionFunctionBody);
                if (fromComp.isOptional()) {
                    tempId2 = MessageFormat.format("from.constGet_field_{0}()", FieldSubReference.getJavaGetterName(fromFieldName.getName()));
                    conversionFunctionBody.append(MessageFormat.format("\t\tif(from.constGet_field_{0}().is_bound()) '{'\n", FieldSubReference.getJavaGetterName(fromFieldName.getName())));
                } else {
                    tempId2 = aData.getTemporaryVariableName();
                    conversionFunctionBody.append(MessageFormat.format("\t\tfinal {0} {1} = from.constGet_field_{2}();\n", fromFieldTypeName, tempId2, FieldSubReference.getJavaGetterName(fromFieldName.getName())));
                    conversionFunctionBody.append(MessageFormat.format("\t\tif({0}.is_bound()) '{'\n", tempId2));
                }
                ExpressionStruct tempExpression = new ExpressionStruct();
                String tempId3 = toFieldType.generateConversion(aData, fromFieldType, tempId2, forValue, tempExpression);
                tempExpression.openMergeExpression(conversionFunctionBody);
                conversionFunctionBody.append(MessageFormat.format("\t\t\tto.get_field_{0}().operator_assign({1});\n", FieldSubReference.getJavaGetterName(toFieldName.getName()), tempId3));
                conversionFunctionBody.append("\t\t}\n");
            }
            conversionFunctionBody.append("\t\treturn true;\n");
            conversionFunctionBody.append("\t}\n\n");
            aData.addTypeConversion(ConversionFunctionName, conversionFunctionBody.toString());
        }
        return tempId;
    }

    protected String generateConversionASNSetSeqToTTCNSetSeq(JavaGenData aData, ASN1_Set_Seq_Choice_BaseType fromType, String fromName, boolean forValue, ExpressionStruct expression) {
        String tempId = aData.getTemporaryVariableName();
        String name = forValue ? this.getGenNameValue(aData, expression.preamble) : this.getGenNameTemplate(aData, expression.preamble);
        expression.preamble.append(MessageFormat.format("final {0} {1} = new {0}();\n", name, tempId));
        String ConversionFunctionName = Type.getConversionFunction(aData, fromType, this, forValue, expression.preamble);
        expression.preamble.append(MessageFormat.format("if(!{0}({1}, {2})) '{'\n", ConversionFunctionName, tempId, fromName));
        expression.preamble.append(MessageFormat.format("throw new TtcnError(\"Values or templates of type `{0}'' and `{1}'' are not compatible at run-time\");\n", this.getTypename(), fromType.getTypename()));
        expression.preamble.append("}\n");
        if (!aData.hasTypeConversion(ConversionFunctionName)) {
            StringBuilder conversionFunctionBody = new StringBuilder();
            String fromTypeName = forValue ? fromType.getGenNameValue(aData, conversionFunctionBody) : fromType.getGenNameTemplate(aData, conversionFunctionBody);
            conversionFunctionBody.append(MessageFormat.format("\tpublic static boolean {0}(final {1} to, final {2} from) '{'\n", ConversionFunctionName, name, fromTypeName));
            for (int i = 0; i < this.getNofComponents(); ++i) {
                CompField toComp = this.getComponentByIndex(i);
                CompField fromComp = fromType.getComponentByIndex(i);
                Identifier toFieldName = toComp.getIdentifier();
                Identifier fromFieldName = fromComp.getIdentifier();
                IType toFieldType = toComp.getType().getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp());
                IType fromFieldType = fromComp.getType().getTypeRefdLast(CompilationTimeStamp.getBaseTimestamp());
                String tempId2 = aData.getTemporaryVariableName();
                String fromFieldTypeName = forValue ? fromFieldType.getGenNameValue(aData, conversionFunctionBody) : fromFieldType.getGenNameTemplate(aData, conversionFunctionBody);
                conversionFunctionBody.append(MessageFormat.format("\t\tfinal {0} {1} = from.constGet_field_{2}(){3};\n", fromFieldTypeName, tempId2, FieldSubReference.getJavaGetterName(fromFieldName.getName()), forValue && fromComp.isOptional() ? ".constGet()" : ""));
                conversionFunctionBody.append(MessageFormat.format("\t\tif({0}.is_bound()) '{'\n", tempId2));
                ExpressionStruct tempExpression = new ExpressionStruct();
                String tempId3 = toFieldType.generateConversion(aData, fromFieldType, tempId2, forValue, tempExpression);
                tempExpression.openMergeExpression(conversionFunctionBody);
                conversionFunctionBody.append(MessageFormat.format("\t\t\tto.get_field_{0}().operator_assign({1});\n", FieldSubReference.getJavaGetterName(toFieldName.getName()), tempId3));
                conversionFunctionBody.append("\t\t}\n");
            }
            conversionFunctionBody.append("\t\treturn true;\n");
            conversionFunctionBody.append("\t}\n\n");
            aData.addTypeConversion(ConversionFunctionName, conversionFunctionBody.toString());
        }
        return tempId;
    }

    @Override
    public void addMembersContent(Ttcn3HoverContent content) {
        if (this.getNofComponents() > 0) {
            content.addTag("Members");
            for (int i = 0; i < this.getNofComponents(); ++i) {
                CompField field = this.getComponentByIndex(i);
                Type memberType = field.getType();
                String memberTypeName = "";
                if (memberType != null) {
                    memberTypeName = memberType.getTypename();
                }
                content.addStyledText(memberTypeName + " ", 1);
                content.addStyledText(field.getIdentifier().getDisplayName(), 2).addText("<br>");
            }
        }
    }
}

