/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.definitions;

import java.util.ArrayList;
import org.eclipse.titan.designer.AST.ASTNode;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.INamedNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.IIncrementallyUpdateable;
import org.eclipse.titan.designer.AST.TTCN3.definitions.ActualParameter;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FormalParameter;
import org.eclipse.titan.designer.AST.TTCN3.definitions.FormalParameterList;
import org.eclipse.titan.designer.AST.TTCN3.values.expressions.ExpressionStruct;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class ActualParameterList
extends ASTNode
implements IIncrementallyUpdateable {
    private static final String FULLNAMEPART = ".<parameter";
    private ArrayList<ActualParameter> parameters;

    @Override
    public synchronized void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (this.parameters == null) {
            return;
        }
        this.parameters.trimToSize();
        for (int i = 0; i < this.parameters.size(); ++i) {
            this.parameters.get(i).setMyScope(scope);
        }
    }

    public void setCodeSection(GovernedSimple.CodeSectionType codeSection) {
        if (this.parameters == null) {
            return;
        }
        for (int i = 0; i < this.parameters.size(); ++i) {
            this.parameters.get(i).setCodeSection(codeSection);
        }
    }

    @Override
    public StringBuilder getFullName(INamedNode child) {
        StringBuilder builder = super.getFullName(child);
        if (this.parameters == null) {
            return builder;
        }
        for (int i = 0; i < this.parameters.size(); ++i) {
            if (this.parameters.get(i) != child) continue;
            return builder.append(FULLNAMEPART).append(String.valueOf(i + 1)).append(">");
        }
        return builder;
    }

    public synchronized void addParameter(ActualParameter parameter) {
        if (parameter != null) {
            if (this.parameters == null) {
                this.parameters = new ArrayList(1);
            }
            this.parameters.add(parameter);
            parameter.setFullNameParent(this);
        }
    }

    public int getNofParameters() {
        if (this.parameters == null) {
            return 0;
        }
        return this.parameters.size();
    }

    public ActualParameter getParameter(int index) {
        if (this.parameters == null) {
            return null;
        }
        return this.parameters.get(index);
    }

    public void checkRecursions(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        if (this.parameters == null) {
            return;
        }
        for (int i = 0; i < this.parameters.size(); ++i) {
            this.parameters.get(i).checkRecursions(timestamp, referenceChain);
        }
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        if (this.parameters == null) {
            return;
        }
        for (ActualParameter parameter : this.parameters) {
            parameter.updateSyntax(reparser, false);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        if (this.parameters != null) {
            for (ActualParameter ap : this.parameters) {
                if (ap.accept(v)) continue;
                return false;
            }
        }
        return true;
    }

    public void generateCodeNoAlias(JavaGenData aData, ExpressionStruct expression, FormalParameterList formalParameterList) {
        if (this.parameters == null) {
            return;
        }
        int size = this.parameters.size();
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                expression.expression.append(", ");
            }
            this.parameters.get(i).generateCode(aData, expression, formalParameterList == null ? null : formalParameterList.getParameterByIndex(i));
        }
    }

    public void generateCodeAlias(JavaGenData aData, ExpressionStruct expression, FormalParameterList formalParameterList) {
        this.generateCodeNoAlias(aData, expression, formalParameterList);
    }

    public void reArrangeInitCode(JavaGenData aData, StringBuilder source, Module usageModule) {
        if (this.parameters == null) {
            return;
        }
        for (ActualParameter parameter : this.parameters) {
            parameter.reArrangeInitCode(aData, source, usageModule);
        }
    }

    public boolean hasSingleExpression(FormalParameterList formalParameterList) {
        if (this.parameters == null) {
            return true;
        }
        for (int i = 0; i < this.parameters.size(); ++i) {
            FormalParameter formalPar;
            ActualParameter actualParameter = this.parameters.get(i);
            FormalParameter formalParameter = formalPar = formalParameterList == null ? null : formalParameterList.getParameterByIndex(i);
            if (actualParameter.hasSingleExpression(formalPar)) continue;
            return false;
        }
        return true;
    }
}

