/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.runtime.core;

import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.titan.runtime.core.Base_Template;
import org.eclipse.titan.runtime.core.Base_Type;
import org.eclipse.titan.runtime.core.Optional;
import org.eclipse.titan.runtime.core.Param_Types;
import org.eclipse.titan.runtime.core.TTCN_Logger;
import org.eclipse.titan.runtime.core.Text_Buf;
import org.eclipse.titan.runtime.core.TitanFloat;
import org.eclipse.titan.runtime.core.Ttcn3Float;
import org.eclipse.titan.runtime.core.TtcnError;

public class TitanFloat_template
extends Base_Template {
    private TitanFloat single_value;
    private ArrayList<TitanFloat_template> value_list;
    private boolean min_is_present;
    private boolean max_is_present;
    private boolean min_is_exclusive;
    private boolean max_is_exclusive;
    private TitanFloat min_value;
    private TitanFloat max_value;

    public TitanFloat_template() {
    }

    public TitanFloat_template(Base_Template.template_sel otherValue) {
        super(otherValue);
        TitanFloat_template.check_single_selection(otherValue);
    }

    public TitanFloat_template(double otherValue) {
        super(Base_Template.template_sel.SPECIFIC_VALUE);
        this.single_value = new TitanFloat(otherValue);
    }

    public TitanFloat_template(Ttcn3Float otherValue) {
        super(Base_Template.template_sel.SPECIFIC_VALUE);
        this.single_value = new TitanFloat(otherValue);
    }

    public TitanFloat_template(TitanFloat otherValue) {
        super(Base_Template.template_sel.SPECIFIC_VALUE);
        otherValue.must_bound("Creating a template from an unbound float value.");
        this.single_value = new TitanFloat(otherValue);
    }

    public TitanFloat_template(Optional<TitanFloat> otherValue) {
        switch (otherValue.get_selection()) {
            case OPTIONAL_PRESENT: {
                this.set_selection(Base_Template.template_sel.SPECIFIC_VALUE);
                this.single_value = new TitanFloat(otherValue.constGet());
                break;
            }
            case OPTIONAL_OMIT: {
                this.set_selection(Base_Template.template_sel.OMIT_VALUE);
                break;
            }
            case OPTIONAL_UNBOUND: {
                throw new TtcnError("Creating a float template from an unbound optional field.");
            }
        }
    }

    public TitanFloat_template(TitanFloat_template otherValue) {
        this.copy_template(otherValue);
    }

    @Override
    public void clean_up() {
        switch (this.template_selection) {
            case SPECIFIC_VALUE: {
                this.single_value = null;
                break;
            }
            case VALUE_LIST: 
            case COMPLEMENTED_LIST: {
                this.value_list.clear();
                this.value_list = null;
                break;
            }
            case VALUE_RANGE: {
                this.min_value = null;
                this.max_value = null;
                break;
            }
        }
        this.template_selection = Base_Template.template_sel.UNINITIALIZED_TEMPLATE;
    }

    @Override
    public TitanFloat_template operator_assign(Base_Type otherValue) {
        if (otherValue instanceof TitanFloat) {
            return this.operator_assign((TitanFloat)otherValue);
        }
        throw new TtcnError(MessageFormat.format("Internal Error: value `{0}'' can not be cast to float", otherValue));
    }

    @Override
    public TitanFloat_template operator_assign(Base_Template otherValue) {
        if (otherValue instanceof TitanFloat_template) {
            return this.operator_assign((TitanFloat_template)otherValue);
        }
        throw new TtcnError(MessageFormat.format("Internal Error: value `{0}'' can not be cast to float template", otherValue));
    }

    @Override
    public TitanFloat_template operator_assign(Base_Template.template_sel otherValue) {
        TitanFloat_template.check_single_selection(otherValue);
        this.clean_up();
        this.set_selection(otherValue);
        return this;
    }

    public TitanFloat_template operator_assign(double otherValue) {
        this.clean_up();
        this.set_selection(Base_Template.template_sel.SPECIFIC_VALUE);
        this.single_value = new TitanFloat(otherValue);
        return this;
    }

    public TitanFloat_template operator_assign(Ttcn3Float otherValue) {
        this.clean_up();
        this.set_selection(Base_Template.template_sel.SPECIFIC_VALUE);
        this.single_value = new TitanFloat(otherValue);
        return this;
    }

    public TitanFloat_template operator_assign(TitanFloat otherValue) {
        otherValue.must_bound("Assignment of an unbound float value to a template.");
        this.clean_up();
        this.set_selection(Base_Template.template_sel.SPECIFIC_VALUE);
        this.single_value = new TitanFloat(otherValue);
        return this;
    }

    public TitanFloat_template operator_assign(TitanFloat_template otherValue) {
        if (otherValue != this) {
            this.clean_up();
            this.copy_template(otherValue);
        }
        return this;
    }

    private void copy_template(TitanFloat_template otherValue) {
        switch (otherValue.template_selection) {
            case SPECIFIC_VALUE: {
                this.single_value = new TitanFloat(otherValue.single_value);
                break;
            }
            case OMIT_VALUE: 
            case ANY_VALUE: 
            case ANY_OR_OMIT: {
                break;
            }
            case VALUE_LIST: 
            case COMPLEMENTED_LIST: {
                this.value_list = new ArrayList(otherValue.value_list.size());
                for (int i = 0; i < otherValue.value_list.size(); ++i) {
                    TitanFloat_template temp = new TitanFloat_template(otherValue.value_list.get(i));
                    this.value_list.add(temp);
                }
                break;
            }
            case VALUE_RANGE: {
                this.min_is_present = otherValue.min_is_present;
                this.min_is_exclusive = otherValue.min_is_exclusive;
                if (this.min_is_present) {
                    this.min_value = new TitanFloat(otherValue.min_value);
                }
                this.max_is_present = otherValue.max_is_present;
                this.max_is_exclusive = otherValue.max_is_exclusive;
                if (!this.max_is_present) break;
                this.max_value = new TitanFloat(otherValue.max_value);
                break;
            }
            default: {
                throw new TtcnError("Copying an uninitialized/unsupported float template.");
            }
        }
        this.set_selection(otherValue);
    }

    @Override
    public boolean match(Base_Type otherValue, boolean legacy) {
        if (otherValue instanceof TitanFloat) {
            return this.match((TitanFloat)otherValue, legacy);
        }
        throw new TtcnError(MessageFormat.format("Internal Error: value `{0}'' can not be cast to float", otherValue));
    }

    @Override
    public void log_match(Base_Type match_value, boolean legacy) {
        if (match_value instanceof TitanFloat) {
            this.log_match((TitanFloat)match_value, legacy);
            return;
        }
        throw new TtcnError(MessageFormat.format("Internal Error: value `{0}'' can not be cast to float", match_value));
    }

    public boolean match(TitanFloat otherValue) {
        return this.match(otherValue, false);
    }

    public boolean match(TitanFloat otherValue, boolean legacy) {
        if (!otherValue.is_bound()) {
            return false;
        }
        switch (this.template_selection) {
            case SPECIFIC_VALUE: {
                return this.single_value.operator_equals(otherValue);
            }
            case OMIT_VALUE: {
                return false;
            }
            case ANY_VALUE: 
            case ANY_OR_OMIT: {
                return true;
            }
            case VALUE_LIST: 
            case COMPLEMENTED_LIST: {
                for (int i = 0; i < this.value_list.size(); ++i) {
                    if (!this.value_list.get(i).match(otherValue, legacy)) continue;
                    return this.template_selection == Base_Template.template_sel.VALUE_LIST;
                }
                return this.template_selection == Base_Template.template_sel.COMPLEMENTED_LIST;
            }
            case VALUE_RANGE: {
                boolean lowerMatch = false;
                boolean upperMatch = false;
                if (this.min_is_present) {
                    if (!this.min_is_exclusive && this.min_value.is_less_than_or_equal(otherValue)) {
                        lowerMatch = true;
                    } else if (this.min_is_exclusive && this.min_value.is_less_than(otherValue)) {
                        lowerMatch = true;
                    }
                } else if (!this.min_is_exclusive || otherValue.is_greater_than(Double.NEGATIVE_INFINITY)) {
                    lowerMatch = true;
                }
                if (this.max_is_present) {
                    if (!this.max_is_exclusive && this.max_value.is_greater_than_or_equal(otherValue)) {
                        upperMatch = true;
                    } else if (this.max_is_exclusive && this.max_value.is_greater_than(otherValue)) {
                        upperMatch = true;
                    }
                } else if (!this.max_is_exclusive || otherValue.is_less_than(Double.POSITIVE_INFINITY)) {
                    upperMatch = true;
                }
                return lowerMatch && upperMatch;
            }
        }
        throw new TtcnError("Matching with an uninitialized/unsupported float template.");
    }

    @Override
    public void set_type(Base_Template.template_sel templateType, int listLength) {
        this.clean_up();
        switch (templateType) {
            case VALUE_LIST: 
            case COMPLEMENTED_LIST: {
                this.set_selection(templateType);
                this.value_list = new ArrayList(listLength);
                for (int i = 0; i < listLength; ++i) {
                    this.value_list.add(new TitanFloat_template());
                }
                break;
            }
            case VALUE_RANGE: {
                this.set_selection(Base_Template.template_sel.VALUE_RANGE);
                this.min_is_present = false;
                this.max_is_present = false;
                this.min_is_exclusive = false;
                this.max_is_exclusive = false;
                break;
            }
            default: {
                throw new TtcnError("Setting an invalid type for a float template.");
            }
        }
    }

    @Override
    public int n_list_elem() {
        if (this.template_selection != Base_Template.template_sel.VALUE_LIST && this.template_selection != Base_Template.template_sel.COMPLEMENTED_LIST) {
            throw new TtcnError("Accessing a list element of a non-list float template.");
        }
        return this.value_list.size();
    }

    @Override
    public TitanFloat_template list_item(int listIndex) {
        if (this.template_selection != Base_Template.template_sel.VALUE_LIST && this.template_selection != Base_Template.template_sel.COMPLEMENTED_LIST) {
            throw new TtcnError("Accessing a list element of a non-list float template.");
        }
        if (listIndex < 0) {
            throw new TtcnError("Accessing an bitstring value list template using a negative index (" + listIndex + ").");
        }
        if (listIndex >= this.value_list.size()) {
            throw new TtcnError("Index overflow in a float value list template.");
        }
        return this.value_list.get(listIndex);
    }

    public void set_min(double minValue) {
        if (this.template_selection != Base_Template.template_sel.VALUE_RANGE) {
            throw new TtcnError("Float template is not range when setting lower limit.");
        }
        if (this.max_is_present && this.min_is_present && this.max_value.is_less_than(this.min_value)) {
            throw new TtcnError("The lower limit of the range is greater than the upper limit in a float template.");
        }
        this.min_is_present = true;
        this.min_is_exclusive = false;
        this.min_value = new TitanFloat(minValue);
    }

    public void set_min(Ttcn3Float minValue) {
        if (this.template_selection != Base_Template.template_sel.VALUE_RANGE) {
            throw new TtcnError("Float template is not range when setting lower limit.");
        }
        if (this.max_is_present && this.min_is_present && this.max_value.is_less_than(this.min_value)) {
            throw new TtcnError("The lower limit of the range is greater than the upper limit in a float template.");
        }
        this.min_is_present = true;
        this.min_is_exclusive = false;
        this.min_value = new TitanFloat(minValue);
    }

    public void set_min(TitanFloat minValue) {
        minValue.must_bound("Using an unbound value when setting the lower bound in a float range template.");
        this.set_min(minValue.get_value());
    }

    public void set_max(double maxValue) {
        if (this.template_selection != Base_Template.template_sel.VALUE_RANGE) {
            throw new TtcnError("Float template is not range when setting upper limit.");
        }
        if (this.min_is_present && this.max_is_present && this.min_value.is_greater_than(this.max_value)) {
            throw new TtcnError("The upper limit of the range is smaller than the lower limit in a float template.");
        }
        this.max_is_present = true;
        this.max_is_exclusive = false;
        this.max_value = new TitanFloat(maxValue);
    }

    public void set_max(Ttcn3Float maxValue) {
        if (this.template_selection != Base_Template.template_sel.VALUE_RANGE) {
            throw new TtcnError("Float template is not range when setting upper limit.");
        }
        if (this.min_is_present && this.max_is_present && this.min_value.is_greater_than(this.max_value)) {
            throw new TtcnError("The upper limit of the range is smaller than the lower limit in a float template.");
        }
        this.max_is_present = true;
        this.max_is_exclusive = false;
        this.max_value = new TitanFloat(maxValue);
    }

    public void set_max(TitanFloat maxValue) {
        maxValue.must_bound("Using an unbound value when setting the upper bound in a float range template.");
        this.set_max(maxValue.get_value());
    }

    public void set_min_exclusive(boolean minExclusive) {
        if (this.template_selection != Base_Template.template_sel.VALUE_RANGE) {
            throw new TtcnError("Float template is not range when setting lower limit exclusiveness.");
        }
        this.min_is_exclusive = minExclusive;
    }

    public void set_max_exclusive(boolean maxExclusive) {
        if (this.template_selection != Base_Template.template_sel.VALUE_RANGE) {
            throw new TtcnError("Float template is not range when setting upper limit exclusiveness.");
        }
        this.max_is_exclusive = maxExclusive;
    }

    @Override
    public TitanFloat valueof() {
        if (this.template_selection != Base_Template.template_sel.SPECIFIC_VALUE || this.is_ifPresent) {
            throw new TtcnError("Performing a valueof or send operation on a non-specific float template.");
        }
        return this.single_value;
    }

    @Override
    public void log() {
        switch (this.template_selection) {
            case SPECIFIC_VALUE: {
                TitanFloat.log_float(this.single_value.get_value());
                break;
            }
            case COMPLEMENTED_LIST: {
                TTCN_Logger.log_event_str("complement");
            }
            case VALUE_LIST: {
                TTCN_Logger.log_char('(');
                for (int i = 0; i < this.value_list.size(); ++i) {
                    if (i > 0) {
                        TTCN_Logger.log_event_str(", ");
                    }
                    this.value_list.get(i).log();
                }
                TTCN_Logger.log_char(')');
                break;
            }
            case VALUE_RANGE: {
                TTCN_Logger.log_char('(');
                if (this.min_is_exclusive) {
                    TTCN_Logger.log_char('!');
                }
                if (this.min_is_present) {
                    TitanFloat.log_float(this.min_value.get_value());
                } else {
                    TTCN_Logger.log_event_str("-infinity");
                }
                TTCN_Logger.log_event_str(" .. ");
                if (this.max_is_exclusive) {
                    TTCN_Logger.log_char('!');
                }
                if (this.max_is_present) {
                    TitanFloat.log_float(this.max_value.get_value());
                } else {
                    TTCN_Logger.log_event_str("infinity");
                }
                TTCN_Logger.log_char(')');
                break;
            }
            default: {
                this.log_generic();
            }
        }
        this.log_ifpresent();
    }

    public void log_match(TitanFloat match_value, boolean legacy) {
        if (TTCN_Logger.matching_verbosity_t.VERBOSITY_COMPACT == TTCN_Logger.get_matching_verbosity() && TTCN_Logger.get_logmatch_buffer_len() != 0) {
            TTCN_Logger.print_logmatch_buffer();
            TTCN_Logger.log_event_str(" := ");
        }
        match_value.log();
        TTCN_Logger.log_event_str(" with ");
        this.log();
        if (this.match(match_value)) {
            TTCN_Logger.log_event_str(" matched");
        } else {
            TTCN_Logger.log_event_str(" unmatched");
        }
    }

    @Override
    public boolean match_omit(boolean legacy) {
        if (this.is_ifPresent) {
            return true;
        }
        switch (this.template_selection) {
            case OMIT_VALUE: 
            case ANY_OR_OMIT: {
                return true;
            }
            case VALUE_LIST: 
            case COMPLEMENTED_LIST: {
                if (legacy) {
                    for (int i = 0; i < this.value_list.size(); ++i) {
                        if (!this.value_list.get(i).match_omit()) continue;
                        return this.template_selection == Base_Template.template_sel.VALUE_LIST;
                    }
                    return this.template_selection == Base_Template.template_sel.COMPLEMENTED_LIST;
                }
                return false;
            }
        }
        return false;
    }

    @Override
    public void encode_text(Text_Buf text_buf) {
        this.encode_text_base(text_buf);
        switch (this.template_selection) {
            case OMIT_VALUE: 
            case ANY_VALUE: 
            case ANY_OR_OMIT: {
                break;
            }
            case SPECIFIC_VALUE: {
                text_buf.push_double(this.single_value.get_value());
                break;
            }
            case VALUE_LIST: 
            case COMPLEMENTED_LIST: {
                text_buf.push_int(this.value_list.size());
                for (int i = 0; i < this.value_list.size(); ++i) {
                    this.value_list.get(i).encode_text(text_buf);
                }
                break;
            }
            case VALUE_RANGE: {
                text_buf.push_int(this.min_is_present ? 1 : 0);
                if (this.min_is_present) {
                    text_buf.push_double(this.min_value.get_value());
                }
                text_buf.push_int(this.max_is_present ? 1 : 0);
                if (!this.max_is_present) break;
                text_buf.push_double(this.max_value.get_value());
                break;
            }
            default: {
                throw new TtcnError("Text encoder: Encoding an uninitialized/unsupported float template.");
            }
        }
    }

    @Override
    public void decode_text(Text_Buf text_buf) {
        this.clean_up();
        this.decode_text_base(text_buf);
        switch (this.template_selection) {
            case OMIT_VALUE: 
            case ANY_VALUE: 
            case ANY_OR_OMIT: {
                break;
            }
            case SPECIFIC_VALUE: {
                this.single_value = new TitanFloat(text_buf.pull_double());
                break;
            }
            case VALUE_LIST: 
            case COMPLEMENTED_LIST: {
                int size = text_buf.pull_int().get_int();
                this.value_list = new ArrayList(size);
                for (int i = 0; i < size; ++i) {
                    TitanFloat_template temp = new TitanFloat_template();
                    temp.decode_text(text_buf);
                    this.value_list.add(temp);
                }
                break;
            }
            case VALUE_RANGE: {
                boolean bl = this.min_is_present = text_buf.pull_int().get_int() != 0;
                if (this.min_is_present) {
                    this.min_value = new TitanFloat(text_buf.pull_double());
                }
                boolean bl2 = this.max_is_present = text_buf.pull_int().get_int() != 0;
                if (this.max_is_present) {
                    this.max_value = new TitanFloat(text_buf.pull_double());
                }
                this.min_is_exclusive = false;
                this.max_is_exclusive = false;
                break;
            }
            default: {
                throw new TtcnError("Text decoder: An unknown/unsupported selection was received for a float template.");
            }
        }
    }

    @Override
    public void set_param(Param_Types.Module_Parameter param) {
        param.basic_check(Param_Types.Module_Parameter.basic_check_bits_t.BC_TEMPLATE.getValue(), "float template");
        if (param.get_type() == Param_Types.Module_Parameter.type_t.MP_Reference) {
            param = param.get_referenced_param().get();
        }
        block0 : switch (param.get_type()) {
            case MP_Omit: {
                this.operator_assign(Base_Template.template_sel.OMIT_VALUE);
                break;
            }
            case MP_Any: {
                this.operator_assign(Base_Template.template_sel.ANY_VALUE);
                break;
            }
            case MP_AnyOrNone: {
                this.operator_assign(Base_Template.template_sel.ANY_OR_OMIT);
                break;
            }
            case MP_List_Template: 
            case MP_ComplementList_Template: {
                TitanFloat_template temp = new TitanFloat_template();
                temp.set_type(param.get_type() == Param_Types.Module_Parameter.type_t.MP_List_Template ? Base_Template.template_sel.VALUE_LIST : Base_Template.template_sel.COMPLEMENTED_LIST, param.get_size());
                for (int i = 0; i < param.get_size(); ++i) {
                    temp.list_item(i).set_param(param.get_elem(i));
                }
                this.operator_assign(temp);
                break;
            }
            case MP_Float: {
                this.operator_assign(param.get_float());
                break;
            }
            case MP_FloatRange: {
                this.set_type(Base_Template.template_sel.VALUE_RANGE);
                if (param.has_lower_float()) {
                    this.set_min(param.get_lower_float());
                }
                this.set_min_exclusive(param.get_is_min_exclusive());
                if (param.has_upper_float()) {
                    this.set_max(param.get_upper_float());
                }
                this.set_max_exclusive(param.get_is_max_exclusive());
                break;
            }
            case MP_Expression: {
                switch (param.get_expr_type()) {
                    case EXPR_NEGATE: {
                        TitanFloat operand = new TitanFloat();
                        operand.set_param(param.get_operand1());
                        this.operator_assign(operand.sub());
                        break block0;
                    }
                    case EXPR_ADD: {
                        TitanFloat operand1 = new TitanFloat();
                        TitanFloat operand2 = new TitanFloat();
                        operand1.set_param(param.get_operand1());
                        operand2.set_param(param.get_operand2());
                        this.operator_assign(operand1.add(operand2));
                        break block0;
                    }
                    case EXPR_SUBTRACT: {
                        TitanFloat operand1 = new TitanFloat();
                        TitanFloat operand2 = new TitanFloat();
                        operand1.set_param(param.get_operand1());
                        operand2.set_param(param.get_operand2());
                        this.operator_assign(operand1.sub(operand2));
                        break block0;
                    }
                    case EXPR_MULTIPLY: {
                        TitanFloat operand1 = new TitanFloat();
                        TitanFloat operand2 = new TitanFloat();
                        operand1.set_param(param.get_operand1());
                        operand2.set_param(param.get_operand2());
                        this.operator_assign(operand1.mul(operand2));
                        break block0;
                    }
                    case EXPR_DIVIDE: {
                        TitanFloat operand1 = new TitanFloat();
                        TitanFloat operand2 = new TitanFloat();
                        operand1.set_param(param.get_operand1());
                        operand2.set_param(param.get_operand2());
                        if (operand2.operator_equals(0.0)) {
                            param.error("Floating point division by zero.", new Object[0]);
                        }
                        this.operator_assign(operand1.div(operand2));
                        break block0;
                    }
                }
                param.expr_type_error("a float");
                break;
            }
            default: {
                param.type_error("float template");
            }
        }
        this.is_ifPresent = param.get_ifpresent() || param.get_ifpresent();
    }

    @Override
    public Param_Types.Module_Parameter get_param(Param_Types.Module_Param_Name param_name) {
        Param_Types.Module_Parameter mp = null;
        switch (this.template_selection) {
            case UNINITIALIZED_TEMPLATE: {
                mp = new Param_Types.Module_Param_Unbound();
                break;
            }
            case OMIT_VALUE: {
                mp = new Param_Types.Module_Param_Omit();
                break;
            }
            case ANY_VALUE: {
                mp = new Param_Types.Module_Param_Any();
                break;
            }
            case ANY_OR_OMIT: {
                mp = new Param_Types.Module_Param_AnyOrNone();
                break;
            }
            case SPECIFIC_VALUE: {
                mp = new Param_Types.Module_Param_Float(this.single_value.get_value());
                break;
            }
            case VALUE_LIST: 
            case COMPLEMENTED_LIST: {
                mp = this.template_selection == Base_Template.template_sel.VALUE_LIST ? new Param_Types.Module_Param_List_Template() : new Param_Types.Module_Param_ComplementList_Template();
                for (int i = 0; i < this.value_list.size(); ++i) {
                    mp.add_elem(this.value_list.get(i).get_param(param_name));
                }
                break;
            }
            case VALUE_RANGE: {
                mp = new Param_Types.Module_Param_FloatRange(this.min_value.get_value(), this.min_is_present, this.max_value.get_value(), this.max_is_present, this.min_is_exclusive, this.max_is_exclusive);
                break;
            }
            default: {
                throw new TtcnError("Referencing an uninitialized/unsupported float template.");
            }
        }
        if (this.is_ifPresent) {
            mp.set_ifpresent();
        }
        return mp;
    }

    @Override
    public void check_restriction(Base_Template.template_res restriction, String name, boolean legacy) {
        if (this.template_selection == Base_Template.template_sel.UNINITIALIZED_TEMPLATE) {
            return;
        }
        switch (name != null && restriction == Base_Template.template_res.TR_VALUE ? Base_Template.template_res.TR_OMIT : restriction) {
            case TR_VALUE: {
                if (this.is_ifPresent || this.template_selection != Base_Template.template_sel.SPECIFIC_VALUE) break;
                return;
            }
            case TR_OMIT: {
                if (this.is_ifPresent || this.template_selection != Base_Template.template_sel.OMIT_VALUE && this.template_selection != Base_Template.template_sel.SPECIFIC_VALUE) break;
                return;
            }
            case TR_PRESENT: {
                if (this.match_omit(legacy)) break;
                return;
            }
            default: {
                return;
            }
        }
        throw new TtcnError(MessageFormat.format("Restriction `{0}'' on template of type {1} violated.", TitanFloat_template.get_res_name(restriction), name == null ? "float" : name));
    }
}

