/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.runtime.core;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.titan.runtime.core.Base_Template;
import org.eclipse.titan.runtime.core.Restricted_Length_Template;
import org.eclipse.titan.runtime.core.Text_Buf;
import org.eclipse.titan.runtime.core.TitanInteger;
import org.eclipse.titan.runtime.core.TtcnError;
import org.eclipse.titan.runtime.utils.StringUtils;

public abstract class Record_Of_Template
extends Restricted_Length_Template {
    List<Pair_of_elements> permutation_intervals = null;

    public Record_Of_Template() {
    }

    public Record_Of_Template(Base_Template.template_sel other_value) {
        super(other_value);
    }

    void clean_up_intervals() {
        this.permutation_intervals = null;
    }

    @Override
    protected void set_selection(Base_Template.template_sel other_value) {
        super.set_selection(other_value);
        this.clean_up_intervals();
    }

    void set_selection(Record_Of_Template other_value) {
        super.set_selection(other_value);
        this.clean_up_intervals();
        if (other_value.template_selection == Base_Template.template_sel.SPECIFIC_VALUE) {
            this.permutation_intervals = this.copy_permutations(other_value.permutation_intervals);
        }
    }

    public final List<Pair_of_elements> copy_permutations(List<Pair_of_elements> srcList) {
        if (srcList == null) {
            return null;
        }
        ArrayList<Pair_of_elements> newList = new ArrayList<Pair_of_elements>(srcList.size());
        for (Pair_of_elements srcElem : srcList) {
            Pair_of_elements newElem = new Pair_of_elements(srcElem.start_index, srcElem.end_index);
            newList.add(newElem);
        }
        return newList;
    }

    protected void encode_text_permutation(Text_Buf text_buf) {
        this.encode_text_restricted(text_buf);
        int number_of_permutations = this.get_number_of_permutations();
        text_buf.push_int(number_of_permutations);
        for (int i = 0; i < number_of_permutations; ++i) {
            Pair_of_elements temp = this.permutation_intervals.get(i);
            text_buf.push_int(temp.start_index);
            text_buf.push_int(temp.end_index);
        }
    }

    protected void decode_text_permutation(Text_Buf text_buf) {
        this.decode_text_restricted(text_buf);
        int number_of_permutations = text_buf.pull_int().get_int();
        this.permutation_intervals = new ArrayList<Pair_of_elements>(number_of_permutations);
        for (int i = 0; i < number_of_permutations; ++i) {
            int start_index = text_buf.pull_int().get_int();
            int end_index = text_buf.pull_int().get_int();
            this.permutation_intervals.add(new Pair_of_elements(start_index, end_index));
        }
    }

    public void add_permutation(int start_index, int end_index) {
        if (start_index > end_index) {
            throw new TtcnError(MessageFormat.format("wrong permutation interval settings start ({0})can not be greater than end ({1})", start_index, end_index));
        }
        int number_of_permutations = this.get_number_of_permutations();
        if (number_of_permutations > 0 && this.permutation_intervals.get(number_of_permutations - 1).end_index >= start_index) {
            throw new TtcnError(MessageFormat.format("the {0}{1} permutation overlaps the previous one", number_of_permutations, StringUtils.getOrdinalIndicator(number_of_permutations)));
        }
        if (this.permutation_intervals == null) {
            this.permutation_intervals = new ArrayList<Pair_of_elements>();
        }
        Pair_of_elements newElem = new Pair_of_elements(start_index, end_index);
        this.permutation_intervals.add(newElem);
    }

    public void remove_all_permutations() {
        this.clean_up_intervals();
    }

    public int get_number_of_permutations() {
        return this.permutation_intervals != null ? this.permutation_intervals.size() : 0;
    }

    public int get_permutation_start(int index_value) {
        if (index_value >= this.get_number_of_permutations()) {
            throw new TtcnError(MessageFormat.format("Index overflow ({0})", index_value));
        }
        return this.permutation_intervals.get(index_value).start_index;
    }

    public int get_permutation_end(int index_value) {
        if (index_value >= this.get_number_of_permutations()) {
            throw new TtcnError(MessageFormat.format("Index overflow ({0})", index_value));
        }
        return this.permutation_intervals.get(index_value).end_index;
    }

    public int get_permutation_size(int index_value) {
        if (index_value >= this.get_number_of_permutations()) {
            throw new TtcnError(MessageFormat.format("Index overflow ({0})", index_value));
        }
        return this.permutation_intervals.get(index_value).end_index - this.permutation_intervals.get(index_value).start_index + 1;
    }

    public boolean permutation_starts_at(int index_value) {
        int number_of_permutations = this.get_number_of_permutations();
        for (int i = 0; i < number_of_permutations; ++i) {
            if (this.permutation_intervals.get(i).start_index != index_value) continue;
            return true;
        }
        return false;
    }

    public boolean permutation_ends_at(int index_value) {
        int number_of_permutations = this.get_number_of_permutations();
        for (int i = 0; i < number_of_permutations; ++i) {
            if (this.permutation_intervals.get(i).end_index != index_value) continue;
            return true;
        }
        return false;
    }

    public abstract int n_elem();

    public abstract Base_Template get_at(int var1);

    public abstract Base_Template get_at(TitanInteger var1);

    public abstract Base_Template constGet_at(int var1);

    public abstract Base_Template constGet_at(TitanInteger var1);

    class Pair_of_elements {
        private final int start_index;
        private final int end_index;

        public Pair_of_elements(int start_index, int end_index) {
            this.start_index = start_index;
            this.end_index = end_index;
        }
    }
}

