/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.preferences.pages;

import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.Activator;
import org.eclipse.titan.designer.OutOfMemoryCheck;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public final class OnTheFlyCheckerPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private static final String DESCRIPTION = "Preferences of the on-the-fly checker";
    private static final String CHECK_MEMORY = "Warn and disable parsing before the system runs out of memory";
    private static final String ENABLE_PARSING = "Enable parsing of TTCN-3, ASN.1 and Runtime Configuration files";
    private static final String ENABLE_INCREMENTAL_PARSING = "Enable the incremental parsing of TTCN-3 files (EXPERIMENTAL)";
    private static final String DELAY_SEMANTIC_CHECKING = "Delay the on-the-fly semantic check till the file is saved";
    private static final String RECONCILER_TIMEOUT = "Timeout in seconds before on-the-fly check starts";
    private static final String ENABLE_REALTIME = "Enable support for the realtime extension";
    private static final String ENABLE_OOP = "Enable support for the OOP extension (EXPERIMENTAL)";
    private static final String ENABLE_DOCCOMMENT = "Enable on-the-fly checking of document comments";
    private Composite composite;
    private BooleanFieldEditor checkForLowMemory;
    private BooleanFieldEditor useOnTheFlyParsing;
    private BooleanFieldEditor useIncrementalParsing;
    private BooleanFieldEditor delaySemanticCheckTillSave;
    private IntegerFieldEditor reconcilerTimeout;
    private BooleanFieldEditor enableRealtimeSupport;
    private BooleanFieldEditor enableOOPSupport;
    private BooleanFieldEditor enableDocCommentCheck;
    private Boolean realtimeSupport;
    private Boolean oopSupport;

    public OnTheFlyCheckerPreferencePage() {
        super(1);
    }

    protected void createFieldEditors() {
        Composite tempParent = this.getFieldEditorParent();
        this.checkForLowMemory = new BooleanFieldEditor("org.eclipse.titan.designer.checkForLowMemory", CHECK_MEMORY, tempParent);
        this.addField((FieldEditor)this.checkForLowMemory);
        this.useOnTheFlyParsing = new BooleanFieldEditor("org.eclipse.titan.designer.useOnTheFlyParsing", ENABLE_PARSING, tempParent);
        this.addField((FieldEditor)this.useOnTheFlyParsing);
        this.useIncrementalParsing = new BooleanFieldEditor("org.eclipse.titan.designer.useIncrementalParsing", ENABLE_INCREMENTAL_PARSING, tempParent);
        this.addField((FieldEditor)this.useIncrementalParsing);
        this.composite = new Composite(tempParent, 0);
        GridLayout compositeLayout = new GridLayout();
        this.composite.setLayout((Layout)compositeLayout);
        GridData compositeData = new GridData(4);
        compositeData.grabExcessHorizontalSpace = true;
        compositeData.horizontalAlignment = 4;
        this.composite.setLayoutData((Object)compositeData);
        this.reconcilerTimeout = new IntegerFieldEditor("org.eclipse.titan.designer.reconcilerTimeout", RECONCILER_TIMEOUT, this.composite);
        this.reconcilerTimeout.setValidRange(0, 10);
        this.reconcilerTimeout.setTextLimit(2);
        this.addField((FieldEditor)this.reconcilerTimeout);
        this.delaySemanticCheckTillSave = new BooleanFieldEditor("org.eclipse.titan.designer.delaySemantiCheckingTillSave", DELAY_SEMANTIC_CHECKING, tempParent);
        this.addField((FieldEditor)this.delaySemanticCheckTillSave);
        this.enableRealtimeSupport = new BooleanFieldEditor("org.eclipse.titan.designer.enableRealtimeExtension", ENABLE_REALTIME, tempParent);
        this.addField((FieldEditor)this.enableRealtimeSupport);
        this.realtimeSupport = this.enableRealtimeSupport.getBooleanValue();
        this.enableOOPSupport = new BooleanFieldEditor("org.eclipse.titan.designer.enableOOPExtension", ENABLE_OOP, tempParent);
        this.addField((FieldEditor)this.enableOOPSupport);
        this.oopSupport = this.enableOOPSupport.getBooleanValue();
        this.enableDocCommentCheck = new BooleanFieldEditor("org.eclipse.titan.designer.enableDocumentCommentOnTheFlyCheck", ENABLE_DOCCOMMENT, tempParent);
        this.addField((FieldEditor)this.enableDocCommentCheck);
    }

    public void init(IWorkbench workbench) {
        this.setDescription(DESCRIPTION);
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return Activator.getDefault().getPreferenceStore();
    }

    public void dispose() {
        if (this.getPreferenceStore().getBoolean("org.eclipse.titan.designer.useOnTheFlyParsing")) {
            OutOfMemoryCheck.resetOutOfMemoryflag();
        }
        this.useOnTheFlyParsing.dispose();
        this.useIncrementalParsing.dispose();
        this.delaySemanticCheckTillSave.dispose();
        this.reconcilerTimeout.dispose();
        this.enableRealtimeSupport.dispose();
        this.enableOOPSupport.dispose();
        this.enableDocCommentCheck.dispose();
        this.composite.dispose();
        super.dispose();
    }

    private boolean isImportantChanged() {
        return false;
    }

    public void performApply() {
        if (this.isImportantChanged() && this.getPreferenceStore().getBoolean("org.eclipse.titan.designer.useOnTheFlyParsing")) {
            ErrorReporter.parallelWarningDisplayInMessageDialog((String)"On-the-fly analyzer", (String)"Settings of the on-the-fly analyzer have changed, the known projects have to be re-analyzed completly.\nThis might take some time.");
            GlobalParser.clearSemanticInformation();
            GlobalParser.reAnalyzeSemantically();
        }
        if (this.getPreferenceStore().getBoolean("org.eclipse.titan.designer.useOnTheFlyParsing")) {
            OutOfMemoryCheck.resetOutOfMemoryflag();
        }
        if (this.realtimeSupport != null && this.realtimeSupport.booleanValue() != this.enableRealtimeSupport.getBooleanValue()) {
            this.realtimeSupport = this.enableRealtimeSupport.getBooleanValue();
            ErrorReporter.parallelWarningDisplayInMessageDialog((String)"On-the-fly analyzer", (String)"The setting of the on-the-fly analyzer's support for the realtime extension has changed.\nEclipse will need to be restarted for this change to take effect.");
        }
        if (this.oopSupport != null && this.oopSupport.booleanValue() != this.enableOOPSupport.getBooleanValue()) {
            this.oopSupport = this.enableOOPSupport.getBooleanValue();
            ErrorReporter.parallelWarningDisplayInMessageDialog((String)"On-the-fly analyzer", (String)"The setting of the on-the-fly analyzer's support for the OOP extension has changed.\nEclipse will need to be restarted for this change to take effect.");
        }
        super.performApply();
    }

    public boolean performOk() {
        boolean result = super.performOk();
        if (this.realtimeSupport != null && this.realtimeSupport.booleanValue() != this.getPreferenceStore().getBoolean("org.eclipse.titan.designer.enableRealtimeExtension")) {
            ErrorReporter.parallelWarningDisplayInMessageDialog((String)"On-the-fly analyzer", (String)"The setting of the on-the-fly analyzer's support for the realtime extension has changed.\nEclipse needs to be restarted for this change to take effect.");
        }
        if (this.oopSupport != null && this.oopSupport.booleanValue() != this.getPreferenceStore().getBoolean("org.eclipse.titan.designer.enableOOPExtension")) {
            ErrorReporter.parallelWarningDisplayInMessageDialog((String)"On-the-fly analyzer", (String)"The setting of the on-the-fly analyzer's support for the OOP extension has changed.\nEclipse needs to be restarted for this change to take effect.");
        }
        return result;
    }
}

