/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.nativewin32actions;

import java.util.ArrayList;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.action.IAction;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.actions.ExternalTitanAction;
import org.eclipse.titan.designer.consoles.TITANConsole;
import org.eclipse.titan.designer.core.TITANInstallationValidator;
import org.eclipse.titan.designer.license.LicenseValidator;
import org.eclipse.titan.designer.nativewin32actions.NativeWIN32TITANJob;
import org.eclipse.titan.designer.properties.data.TITANFlagsOptionsData;

public final class CheckSemantic
extends ExternalTitanAction {
    private static final String JOB_TITLE = "Semantic check";

    public void run(IAction action) {
        this.doCheck();
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.doCheck();
        return null;
    }

    protected void doCheck() {
        if (!TITANInstallationValidator.check(true)) {
            return;
        }
        if (!LicenseValidator.check()) {
            return;
        }
        this.processSelection();
        if (this.files == null || this.files.isEmpty()) {
            ErrorReporter.parallelErrorDisplayInMessageDialog((String)"Semantic check ...failed", (String)"No valid files were selected.");
            return;
        }
        this.reportOnTheFlyOutdating();
        NativeWIN32TITANJob titanJob = new NativeWIN32TITANJob(JOB_TITLE, this.files, this.workingDir, this.project);
        titanJob.setPriority(50);
        titanJob.setUser(true);
        titanJob.setRule((ISchedulingRule)this.project);
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.getCompilerPath().toOSString());
        String titanFlags = "-s";
        if (this.singleSelectedProject == null) {
            TITANConsole.println("Using the general preferences to do the external semantic check");
            titanFlags = titanFlags + this.getTITANActionFlags();
            command.add(titanFlags);
        } else {
            TITANConsole.println("Using the project properties to do the external semantic check");
            boolean useRuntime2 = false;
            try {
                if ("true".equals(this.project.getPersistentProperty(new QualifiedName("org.eclipse.titan.designer.Properties.Project", "Function test runtime")))) {
                    useRuntime2 = true;
                }
            }
            catch (CoreException e) {
                ErrorReporter.logExceptionStackTrace((String)("While collecting properties of project`" + this.project.getName() + "'"), (Throwable)e);
            }
            command.add(titanFlags);
            String flags = TITANFlagsOptionsData.getTITANFlags(this.singleSelectedProject, useRuntime2);
            if (flags != null && flags.length() > 0) {
                command.add(flags);
            }
        }
        command.addAll(this.files.keySet());
        titanJob.addCommand(command, JOB_TITLE);
        titanJob.removeCompilerMarkers();
        String markersAfterCompiler = Platform.getPreferencesService().getString("org.eclipse.titan.designer", "org.eclipse.titan.designer.ontheflyMarkersAfterCompiler", "Are removed", null);
        if ("Are removed".equals(markersAfterCompiler)) {
            titanJob.removeOnTheFlyMarkers();
        }
        titanJob.schedule();
    }
}

