/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.editors.controls;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.RewriteSessionEditProcessor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.Module;
import org.eclipse.titan.designer.AST.TTCN3.definitions.TTCN3Module;
import org.eclipse.titan.designer.AST.TTCN3.types.ClassTypeBody;
import org.eclipse.titan.designer.editors.ttcn3editor.TTCN3Editor;
import org.eclipse.titan.designer.parsers.GlobalParser;
import org.eclipse.titan.designer.parsers.ProjectSourceParser;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.MarkerAnnotation;
import org.eclipse.ui.views.markers.WorkbenchMarkerResolution;

public class HoverProposal
extends WorkbenchMarkerResolution {
    public static final String PROPOSAL = "proposal";
    private String label;
    private String image;
    private IEditorPart editor = null;
    private Location location;
    private int offset;
    private int indent;
    private IMarker marker;
    private MarkerAnnotation model;
    private Object data;
    private Map<Integer, String> inserts = new HashMap<Integer, String>();

    public HoverProposal(String label, String image) {
        this.label = label;
        this.image = image;
    }

    public HoverProposal(String label, String image, Location location, int offset, String textToInsert) {
        this.label = label;
        this.image = image;
        this.location = location;
        this.inserts.put(offset, textToInsert);
    }

    public HoverProposal(String label, String image, Map<Integer, String> textsToInsert) {
        this.label = label;
        this.image = image;
        this.inserts = textsToInsert;
    }

    public void addProposal(int offset, String textToInsert) {
        this.inserts.put(offset, textToInsert);
    }

    public void setMarker(IMarker marker, MarkerAnnotation model) {
        this.marker = marker;
        this.model = model;
    }

    public String getLabel() {
        return this.label;
    }

    public void run(IMarker marker) {
        this.insertText();
    }

    public String getDescription() {
        return null;
    }

    public Image getImage() {
        return this.image != null ? PlatformUI.getWorkbench().getSharedImages().getImage(this.image) : null;
    }

    public IMarker[] findOtherMarkers(IMarker[] markers) {
        return new IMarker[0];
    }

    protected void insertText() {
        for (Map.Entry<Integer, String> insert : this.inserts.entrySet()) {
            this.insertText(insert.getValue(), insert.getKey());
        }
    }

    public void insertTextAtDefs(int offsetKey) {
        if (this.data == null) {
            int offset = this.getDefinitionsLocation();
            this.insertText(this.inserts.get(offsetKey), offset);
        } else if (this.data instanceof ClassTypeBody) {
            ClassTypeBody body = (ClassTypeBody)this.data;
            this.insertText(this.inserts.get(offsetKey), body.getDefinitionsLocation());
        }
    }

    private void getActiveEditor() {
        this.editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
    }

    protected void calculateIndent() {
        this.getActiveEditor();
        IDocument doc = ((TTCN3Editor)this.editor).getDocument();
        int indent = 0;
        try {
            while (this.offset > 0) {
                char c = doc.getChar(this.offset - indent);
                if (c == '\t') {
                    indent += 4;
                    continue;
                }
                if (c == ' ') {
                    ++indent;
                    continue;
                }
                break;
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        this.indent = indent;
    }

    private int getDefinitionsLocation() {
        this.getActiveEditor();
        IFile file = (IFile)this.editor.getEditorInput().getAdapter(IFile.class);
        ProjectSourceParser projectSourceParser = GlobalParser.getProjectSourceParser(file.getProject());
        Module actualModule = projectSourceParser.containedModule(file);
        return ((TTCN3Module)actualModule).getAssignmentsScope().getLocation().getOffset() + 1;
    }

    protected void insertText(String text, int newOffset) {
        int i;
        this.getActiveEditor();
        StringBuilder indentedText = new StringBuilder();
        for (i = 0; i < this.indent / 4; ++i) {
            indentedText.append('\t');
        }
        for (i = 0; i < this.indent % 4; ++i) {
            indentedText.append(' ');
        }
        indentedText.append('\t');
        indentedText.append(text);
        MultiTextEdit multiEdit = new MultiTextEdit(newOffset, 0);
        RewriteSessionEditProcessor processor = new RewriteSessionEditProcessor(((TTCN3Editor)this.editor).getDocument(), (TextEdit)multiEdit, 3);
        multiEdit.addChild((TextEdit)new InsertEdit(newOffset, indentedText.toString()));
        try {
            processor.performEdits();
            if (this.editor instanceof TTCN3Editor) {
                IFile file = (IFile)this.editor.getEditorInput().getAdapter(IFile.class);
                ((TTCN3Editor)this.editor).analyzeCurrentFile(file);
            }
        }
        catch (BadLocationException e) {
            ErrorReporter.logExceptionStackTrace((Exception)((Object)e));
        }
    }

    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public void setData(Object data) {
        this.data = data;
    }
}

