/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.statements;

import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.GovernedSimple;
import org.eclipse.titan.designer.AST.Identifier;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.TTCN3.statements.Statement;
import org.eclipse.titan.designer.AST.TTCN3.statements.StatementBlock;
import org.eclipse.titan.designer.compiler.JavaGenData;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;

public final class Label_Statement
extends Statement {
    private static final String STATEMENT_NAME = "label";
    private final Identifier identifier;
    private boolean used;
    private int statementIndex;

    public Label_Statement(Identifier identifier) {
        this.identifier = identifier;
        this.used = false;
    }

    @Override
    public Statement.Statement_type getType() {
        return Statement.Statement_type.S_LABEL;
    }

    @Override
    public String getStatementName() {
        return STATEMENT_NAME;
    }

    @Override
    public void setMyStatementBlock(StatementBlock statementBlock, int index) {
        super.setMyStatementBlock(statementBlock, index);
        this.statementIndex = index;
    }

    public int getMyStatementBlockIndex() {
        return this.statementIndex;
    }

    public Identifier getLabelIdentifier() {
        return this.identifier;
    }

    public void setUsed(boolean used) {
        this.used = used;
    }

    public boolean labelIsUsed() {
        return this.used;
    }

    @Override
    public void setCodeSection(GovernedSimple.CodeSectionType codeSection) {
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.lastTimeChecked = timestamp;
    }

    @Override
    public void checkAllowedInterleave() {
        this.location.reportSemanticError("Label statement is not allowed within an interleave statment");
    }

    @Override
    public void updateSyntax(TTCN3ReparseUpdater reparser, boolean isDamaged) throws ReParseException {
        if (isDamaged) {
            throw new ReParseException();
        }
        reparser.updateLocation(this.identifier.getLocation());
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        return this.identifier == null || this.identifier.accept(v);
    }

    @Override
    public void generateCode(JavaGenData aData, StringBuilder source) {
        source.append("/* 'label' instruction is not supported */\n");
    }
}

