/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.executor.tabpages.testset;

import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.titan.executor.executors.TreeLeaf;
import org.eclipse.titan.executor.tabpages.testset.TestCaseTreeElement;
import org.eclipse.titan.executor.tabpages.testset.TestSetTab;
import org.eclipse.titan.executor.tabpages.testset.TestcaseTransfer;
import org.eclipse.titan.executor.tabpages.testset.TestsetTreeElement;

public final class TestsetTreeDropTargetListener
extends DropTargetAdapter {
    private final TreeViewer testsetViewer;
    private final TestSetTab testsetTab;

    public TestsetTreeDropTargetListener(TreeViewer testsetViewer, TestSetTab testsetTab) {
        this.testsetViewer = testsetViewer;
        this.testsetTab = testsetTab;
    }

    public void dragEnter(DropTargetEvent event) {
        if (event.detail == 16 && 0 == (event.operations & 3)) {
            event.detail = 0;
        }
    }

    public void dragOperationChanged(DropTargetEvent event) {
        if (event.detail == 16 && 0 == (event.operations & 3)) {
            event.detail = 0;
        }
    }

    public void dragOver(DropTargetEvent event) {
        if (null == event.item) {
            event.feedback = 8;
            event.detail = 0;
        } else {
            TreeLeaf element = (TreeLeaf)event.item.getData();
            event.feedback = element instanceof TestsetTreeElement ? 25 : 10;
            if (event.detail == 0) {
                if (0 != (event.operations & 2)) {
                    event.detail = 2;
                } else if (0 != (event.operations & 1)) {
                    event.detail = 1;
                }
            }
        }
    }

    public void drop(DropTargetEvent event) {
        if (!TestcaseTransfer.getInstance().isSupportedType(event.currentDataType) || null == event.item) {
            return;
        }
        TreeLeaf element = (TreeLeaf)event.item.getData();
        TestCaseTreeElement[] treeElements = (TestCaseTreeElement[])event.data;
        if (element instanceof TestsetTreeElement) {
            for (TestCaseTreeElement treeElement : treeElements) {
                ((TestsetTreeElement)element).addChildToEnd(treeElement);
            }
            this.testsetViewer.refresh((Object)element);
        } else {
            for (TestCaseTreeElement treeElement : treeElements) {
                ((TestsetTreeElement)element.parent()).addChildBefore(treeElement, element);
            }
            this.testsetViewer.refresh((Object)element.parent());
        }
        this.testsetTab.update();
    }
}

