/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.refactoring.function;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ltk.core.refactoring.RefactoringStatusEntry;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.ISubReference;
import org.eclipse.titan.designer.AST.IType;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.Type;
import org.eclipse.titanium.refactoring.function.ArgumentPassingType;
import org.eclipse.titanium.refactoring.function.IModelProvider;
import org.eclipse.titanium.refactoring.function.Param;
import org.eclipse.titanium.refactoring.function.ParamTableItem;
import org.eclipse.titanium.refactoring.function.ReturnVisitor;
import org.eclipse.titanium.refactoring.function.StatementList;
import org.eclipse.titanium.refactoring.function.TextReplaceItem;

class FunctionCreator
implements IModelProvider<ParamTableItem> {
    private static final String FUNCTION_TEXT_NL = "\r\n";
    private static final String FUNCTION_TEXT_PREFIX = "function ";
    private static final String FUNCTION_TEXT_PARAMS_START = "(";
    private static final String FUNCTION_TEXT_PARAMS_END = ")";
    private static final String FUNCTION_TEXT_RUNS_ON_PREFIX = " runs on ";
    private static final String FUNCTION_TEXT_RETURN_PREFIX = " return ";
    private static final String FUNCTION_TEXT_BODY_START = "\r\n{\r\n";
    private static final String FUNCTION_TEXT_BODY_END = "\r\n}\r\n";
    private static final String FUNCTION_CALL_RETURN_PREFIX = "return ";
    private static final String FUNCTION_CALL_RETURN_SUFFIX = "return; ";
    private static final String FUNCTION_CALL_PARAMS_START = "(";
    private static final String FUNCTION_CALL_PARAMS_END = ");";
    private final StatementList selectedStatements;
    private final IFile selectedFile;
    private final List<Param> params;
    private final Reference runsOnRef;
    private final Type returnType;
    private final StringBuilder newFuncName;
    private final List<RefactoringStatusEntry> warnings;
    private final ReturnVisitor.ReturnCertainty returnCertainity;
    private List<StringBuilder> functionText;
    private List<StringBuilder> functionCallText;

    FunctionCreator(StatementList selectedStatements, IFile selectedFile, StringBuilder funcName, List<Param> params, Reference runsOnRef, Type returnType, ReturnVisitor.ReturnCertainty returnCertainty) {
        this.selectedStatements = selectedStatements;
        this.selectedFile = selectedFile;
        this.newFuncName = funcName;
        this.params = params;
        this.runsOnRef = runsOnRef;
        this.returnType = returnType;
        this.warnings = new ArrayList<RefactoringStatusEntry>();
        this.returnCertainity = returnCertainty;
    }

    void perform() {
        this.createFunctionText();
        this.createFunctionCallText();
    }

    public List<RefactoringStatusEntry> getWarnings() {
        return this.warnings;
    }

    List<StringBuilder> getFunctionText() {
        return this.functionText;
    }

    List<StringBuilder> getFunctionCallText() {
        return this.functionCallText;
    }

    @Override
    public List<ParamTableItem> getItems() {
        LinkedList<ParamTableItem> items = new LinkedList<ParamTableItem>();
        if (this.params == null) {
            return items;
        }
        for (Param p : this.params) {
            if (p.getPassingType() == ArgumentPassingType.NONE) continue;
            items.add(new ParamTableItem(p.getPassingType(), p.getTypeName(), p.getName()));
        }
        return items;
    }

    private SortedSet<TextReplaceItem> createSortedTextReplaceItemSet(String sourceText, int sourceOffset) {
        TreeSet<TextReplaceItem> hitSet = new TreeSet<TextReplaceItem>();
        if (this.params == null) {
            return hitSet;
        }
        for (Param p : this.params) {
            List<ISubReference> srs = p.getRefs();
            for (ISubReference isr : srs) {
                hitSet.add(new TextReplaceItem(isr, p, sourceText, sourceOffset));
            }
            if (!p.isDeclaredInside()) continue;
            hitSet.add(new TextReplaceItem(p.getDef(), p, sourceText, sourceOffset));
        }
        return hitSet;
    }

    private void createFunctionText() {
        if (this.params == null) {
            ErrorReporter.logError((String)"FunctionCreator.createFunctionText(): 'params' is null! ");
            return;
        }
        ArrayList<StringBuilder> declarationsBeforeFunc = new ArrayList<StringBuilder>();
        this.functionText = new ArrayList<StringBuilder>();
        this.functionCallText = new ArrayList<StringBuilder>();
        this.functionText.add(new StringBuilder(FUNCTION_TEXT_NL));
        this.functionText.add(new StringBuilder(FUNCTION_TEXT_NL));
        this.functionText.add(new StringBuilder(FUNCTION_TEXT_NL));
        this.functionText.add(new StringBuilder(FUNCTION_TEXT_PREFIX));
        this.functionText.add(this.newFuncName);
        this.functionText.add(new StringBuilder("("));
        ListIterator<Param> it = this.params.listIterator();
        if (it.hasNext()) {
            Param first = it.next();
            this.functionText.addAll(first.createParamText(false));
        }
        while (it.hasNext()) {
            Param curr = it.next();
            this.functionText.addAll(curr.createParamText(true));
        }
        this.functionText.add(new StringBuilder(FUNCTION_TEXT_PARAMS_END));
        if (this.runsOnRef != null) {
            this.functionText.add(new StringBuilder(FUNCTION_TEXT_RUNS_ON_PREFIX));
            this.functionText.add(new StringBuilder(this.runsOnRef.getId().toString()));
        }
        if (this.returnType != null) {
            this.functionText.add(new StringBuilder(FUNCTION_TEXT_RETURN_PREFIX));
            this.functionText.add(new StringBuilder(Param.getShortTypename((IType)this.returnType)));
        }
        this.functionText.add(new StringBuilder(FUNCTION_TEXT_BODY_START));
        this.functionText.addAll(this.createFunctionBody(declarationsBeforeFunc));
        this.functionText.add(new StringBuilder(FUNCTION_TEXT_BODY_END));
        this.functionText.add(new StringBuilder(FUNCTION_TEXT_NL));
        this.functionText.add(new StringBuilder(FUNCTION_TEXT_NL));
        this.functionCallText.addAll(declarationsBeforeFunc);
    }

    private List<StringBuilder> createFunctionBody(List<StringBuilder> declarationsBeforeFunc) {
        ArrayList<StringBuilder> body = new ArrayList<StringBuilder>();
        try {
            InputStream istream = this.selectedFile.getContents();
            BufferedReader br = new BufferedReader(new InputStreamReader(istream, this.selectedFile.getCharset()));
            int startOffset = this.selectedStatements.getLocation().getOffset();
            int endOffset = this.selectedStatements.getLocation().getEndOffset();
            br.skip(startOffset);
            char[] contentBuf = new char[endOffset - startOffset];
            br.read(contentBuf, 0, endOffset - startOffset);
            br.close();
            istream.close();
            String selectedContent = new String(contentBuf);
            SortedSet<TextReplaceItem> itemSet = this.createSortedTextReplaceItemSet(selectedContent, startOffset);
            Iterator it = itemSet.iterator();
            TextReplaceItem last = null;
            if (!it.hasNext()) {
                body.add(new StringBuilder(selectedContent));
            }
            while (it.hasNext()) {
                TextReplaceItem curr = (TextReplaceItem)it.next();
                if (last == null) {
                    body.add(curr.createBeginningText());
                } else {
                    body.add(last.createIntermediateText(curr));
                }
                if (curr.isReference()) {
                    body.add(curr.getNewParamName());
                } else {
                    body.addAll(curr.createInitOnlyText());
                    declarationsBeforeFunc.add(curr.createPreDeclarationText());
                    declarationsBeforeFunc.add(new StringBuilder(FUNCTION_TEXT_NL));
                }
                if (!it.hasNext()) {
                    body.add(curr.createEndingText());
                }
                last = curr;
            }
        }
        catch (CoreException ce) {
            ErrorReporter.logError((String)("FunctionCreator.createFunctionBody(): Unable to read file contents: " + this.selectedFile));
            return new ArrayList<StringBuilder>();
        }
        catch (IOException ioe) {
            ErrorReporter.logError((String)("FunctionCreator.createFunctionBody(): Unable to read file contents: " + this.selectedFile));
            return new ArrayList<StringBuilder>();
        }
        return body;
    }

    private void createFunctionCallText() {
        boolean returnOnAllBranches;
        boolean bl = returnOnAllBranches = this.returnCertainity == ReturnVisitor.ReturnCertainty.YES;
        if (this.returnType != null && returnOnAllBranches) {
            this.functionCallText.add(new StringBuilder(FUNCTION_CALL_RETURN_PREFIX));
        }
        this.functionCallText.add(this.newFuncName);
        this.functionCallText.add(new StringBuilder("("));
        ListIterator<Param> it = this.params.listIterator();
        if (it.hasNext()) {
            Param first = it.next();
            this.functionCallText.addAll(first.createParamCallText(false));
        }
        while (it.hasNext()) {
            Param curr = it.next();
            this.functionCallText.addAll(curr.createParamCallText(true));
        }
        this.functionCallText.add(new StringBuilder(FUNCTION_CALL_PARAMS_END));
        this.functionCallText.add(new StringBuilder(FUNCTION_TEXT_NL));
        if (this.returnType == null && returnOnAllBranches) {
            this.functionCallText.add(new StringBuilder(FUNCTION_CALL_RETURN_SUFFIX));
        }
    }
}

