/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.runtime.core;

import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.titan.runtime.core.BER;
import org.eclipse.titan.runtime.core.JSON;
import org.eclipse.titan.runtime.core.JSON_Tokenizer;
import org.eclipse.titan.runtime.core.Optional;
import org.eclipse.titan.runtime.core.Param_Types;
import org.eclipse.titan.runtime.core.RAW;
import org.eclipse.titan.runtime.core.TTCN_Buffer;
import org.eclipse.titan.runtime.core.TTCN_EncDec;
import org.eclipse.titan.runtime.core.TTCN_EncDec_ErrorContext;
import org.eclipse.titan.runtime.core.TTCN_Logger;
import org.eclipse.titan.runtime.core.Text_Buf;
import org.eclipse.titan.runtime.core.TitanInteger;
import org.eclipse.titan.runtime.core.TtcnError;

public abstract class Base_Type {
    public static final TTCN_Typedescriptor TitanExternal_descr_ = new TTCN_Typedescriptor("EXTERNAL", BER.TitanExternal_Ber_, null, null, null);
    public static final TTCN_Typedescriptor TitanEmbedded_PDV_descr_ = new TTCN_Typedescriptor("EMBEDDED PDV", BER.TitanEmbedded_PDV_Ber_, null, null, null);
    public static final JSON.TTCN_JSONdescriptor TitanCharString_json_ = new JSON.TTCN_JSONdescriptor(false, null, false, null, false, false, false, 0, null, false, JSON.json_string_escaping.ESCAPE_AS_SHORT);
    public static final TTCN_Typedescriptor TitanCharacter_String_descr_ = new TTCN_Typedescriptor("CHARACTER STRING", BER.TitanCharacter_String_Ber_, null, TitanCharString_json_, null);
    public static final TTCN_Typedescriptor TitanObjectDescriptor_descr_ = new TTCN_Typedescriptor("ObjectDescriptor", BER.TitanObjectDescriptor_Ber_, null, null, null);

    public abstract void clean_up();

    public abstract boolean is_present();

    public abstract boolean is_bound();

    public boolean is_value() {
        return this.is_bound();
    }

    public boolean is_optional() {
        return false;
    }

    public void must_bound(String errorMessage) {
        if (!this.is_bound()) {
            throw new TtcnError(errorMessage);
        }
    }

    public abstract boolean operator_equals(Base_Type var1);

    public abstract Base_Type operator_assign(Base_Type var1);

    public Base_Type operator_assign(Optional<?> otherValue) {
        return this.operator_assign((Base_Type)otherValue.constGet());
    }

    public abstract void log();

    public abstract void set_param(Param_Types.Module_Parameter var1);

    public Param_Types.Module_Parameter get_param(Param_Types.Module_Param_Name param_name) {
        return null;
    }

    public void set_implicit_omit() {
    }

    public abstract void encode_text(Text_Buf var1);

    public abstract void decode_text(Text_Buf var1);

    public void encode(TTCN_Typedescriptor p_td, TTCN_Buffer p_buf, TTCN_EncDec.coding_type p_coding, int flavour) {
        TTCN_Logger.begin_event(TTCN_Logger.Severity.ERROR_UNQUALIFIED);
        TTCN_Logger.log_event_str("//TODO: ");
        TTCN_Logger.log_event_str(this.getClass().getSimpleName());
        TTCN_Logger.log_event_str(".encode() is not yet implemented!\n");
        TTCN_Logger.end_event();
    }

    public void decode(TTCN_Typedescriptor p_td, TTCN_Buffer p_buf, TTCN_EncDec.coding_type p_coding, int flavour) {
        TTCN_Logger.begin_event(TTCN_Logger.Severity.ERROR_UNQUALIFIED);
        TTCN_Logger.log_event_str("//TODO: ");
        TTCN_Logger.log_event_str(this.getClass().getSimpleName());
        TTCN_Logger.log_event_str(".decode() is not yet implemented!\n");
        TTCN_Logger.end_event();
    }

    public int RAW_encode(TTCN_Typedescriptor p_td, RAW.RAW_enc_tree myleaf) {
        throw new TtcnError(MessageFormat.format("RAW encoding requested for type `{0}'' which has no RAW encoding method.", p_td.name));
    }

    public int RAW_decode(TTCN_Typedescriptor p_td, TTCN_Buffer buff, int limit, TTCN_EncDec.raw_order_t top_bit_ord) {
        return this.RAW_decode(p_td, buff, limit, top_bit_ord, false, -1, true, null);
    }

    public int RAW_decode(TTCN_Typedescriptor p_td, TTCN_Buffer buff, int limit, TTCN_EncDec.raw_order_t top_bit_ord, boolean no_err, int sel_field, boolean first_call, RAW.RAW_Force_Omit force_omit) {
        throw new TtcnError(MessageFormat.format("RAW decoding requested for type `{0}'' which has no RAW encoding method.", p_td.name));
    }

    public int JSON_encode(TTCN_Typedescriptor p_td, JSON_Tokenizer p_tok, boolean p_parent_is_map) {
        throw new TtcnError(MessageFormat.format("JSON encoding requested for type `{0}'' which has no JSON encoding method.", p_td.name));
    }

    public int JSON_decode(TTCN_Typedescriptor p_td, JSON_Tokenizer p_tok, boolean p_silent, boolean p_parent_is_map, int p_chosen_field) {
        throw new TtcnError(MessageFormat.format("JSON decoding requested for type `{0}'' which has no JSON decoding method.", p_td.name));
    }

    public int JSON_encode(TTCN_Typedescriptor p_td, JSON_Tokenizer p_tok) {
        return this.JSON_encode(p_td, p_tok, false);
    }

    public final int JSON_decode(TTCN_Typedescriptor p_td, JSON_Tokenizer p_tok, boolean p_silent) {
        return this.JSON_decode(p_td, p_tok, p_silent, false, -1);
    }

    public final int JSON_decode(TTCN_Typedescriptor p_td, JSON_Tokenizer p_tok, boolean p_silent, boolean p_parent_is_map) {
        return this.JSON_decode(p_td, p_tok, p_silent, p_parent_is_map, -1);
    }

    public BER.ASN_BER_TLV BER_encode_TLV_Integer(TTCN_Typedescriptor p_td, boolean nativeFlag, int p_int_val, BigInteger p_openssl) {
        if (nativeFlag) {
            int uVal = p_int_val >= 0 ? p_int_val : ~p_int_val;
            int Vlen = 1;
            uVal >>>= 7;
            while (uVal != 0) {
                ++Vlen;
                uVal >>>= 8;
            }
            BER.ASN_BER_TLV newTlv = new BER.ASN_BER_TLV(Vlen, null);
            uVal = p_int_val;
            byte[] Vstr = new byte[Vlen];
            for (int i = Vlen; i > 0; --i) {
                Vstr[i - 1] = (byte)(uVal & 0xFF);
                uVal >>>= 8;
            }
            newTlv.setVstr(Vstr);
            return newTlv;
        }
        BigInteger D = p_openssl;
        if (D.equals(BigInteger.ZERO)) {
            BER.ASN_BER_TLV newTlv = new BER.ASN_BER_TLV(1, null);
            newTlv.Vstr = new byte[1];
            newTlv.Vstr[0] = 0;
            return newTlv;
        }
        byte[] bnAsBytes = D.toByteArray();
        int numBytes = bnAsBytes.length;
        BER.ASN_BER_TLV newTlv = new BER.ASN_BER_TLV(numBytes, null);
        newTlv.Vstr = bnAsBytes;
        return newTlv;
    }

    public void BER_encode_chk_coding(int p_coding) {
        switch (p_coding) {
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            default: {
                p_coding = 2;
            }
        }
    }

    public static void BER_decode_chk_tag(BER.ASN_Tag tag, BER.ASN_BER_TLV tlv) {
        if (tlv.isTagComplete && (tag.tagclass != tlv.tagclass || tag.tagnumber != tlv.tagnumber)) {
            BER.ASN_Tag recievedTag = new BER.ASN_Tag(tag.tagclass, tag.tagnumber);
            String string = recievedTag.print();
        }
    }

    public void BER_decode_str2TLV(TTCN_Buffer p_buf, BER.ASN_BER_TLV p_tlv, int L_form) {
        if (!p_tlv.ASN_BER_str2TLV(p_buf.get_read_len(), p_buf.get_read_data(), L_form)) {
            throw new TtcnError("TLV is not complete.");
        }
    }

    public boolean BER_decode_constdTLV_next(BER.ASN_BER_TLV p_tlv, int V_pos, int L_form, BER.ASN_BER_TLV p_target_tlv) {
        if (p_tlv.Vlen <= V_pos && !p_tlv.isLenDefinite) {
            return false;
        }
        if (!p_target_tlv.ASN_BER_str2TLV(p_tlv.Vlen - V_pos, p_tlv.subArray(p_tlv.Vstr, V_pos, p_tlv.Vlen), L_form)) {
            throw new TtcnError("Incomplete TLV in the constructed TLV.");
        }
        if (!p_tlv.isLenDefinite && p_target_tlv.tagnumber == 0 && p_target_tlv.tagclass == BER.ASN_TagClass.ASN_TAG_UNIV) {
            return false;
        }
        V_pos += p_target_tlv.Tlen + p_target_tlv.Llen + p_target_tlv.Vlen;
        return true;
    }

    public void BER_decode_constdTLV_end(BER.ASN_BER_TLV p_tlv, int V_pos, int L_form, BER.ASN_BER_TLV p_target_tlv, boolean tlv_present) {
        if (tlv_present || this.BER_decode_constdTLV_next(p_tlv, V_pos, L_form, p_target_tlv)) {
            throw new TtcnError("Superfluous TLV(s) at the end of constructed TLV.");
        }
    }

    public BER.ASN_BER_TLV BER_decode_strip_tags(BER.ASN_BERdescriptor p_ber, BER.ASN_BER_TLV p_tlv, int L_form, BER.ASN_BER_TLV stripped_tlv) {
        int i = p_ber.number_of_tags;
        if (i == 0) {
            stripped_tlv = p_tlv;
            return stripped_tlv;
        }
        if (i == 1) {
            Base_Type.BER_decode_chk_tag(p_ber.tags[0], p_tlv);
            stripped_tlv = p_tlv;
            return stripped_tlv;
        }
        BER.ASN_BER_TLV currentTlv = p_tlv;
        boolean doIt = true;
        --i;
        while (doIt) {
            Base_Type.BER_decode_chk_tag(p_ber.tags[i], currentTlv);
            if (i != 0) {
                if (!currentTlv.isConstructed) {
                    TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_TAG, "The other (innermost %lu) tag(s) are missing.", i);
                    doIt = false;
                    stripped_tlv = currentTlv;
                    continue;
                }
                int Vpos = 0;
                this.BER_decode_constdTLV_next(currentTlv, Vpos, L_form, stripped_tlv);
                BER.ASN_BER_TLV endchecker_tlv = new BER.ASN_BER_TLV();
                this.BER_decode_constdTLV_end(currentTlv, Vpos, L_form, endchecker_tlv, false);
                currentTlv = stripped_tlv;
                --i;
                continue;
            }
            doIt = false;
        }
        return stripped_tlv;
    }

    public Map<Boolean, TitanInteger> BER_decode_TLV_Integer(BER.ASN_BER_TLV p_tlv, int p_unsigned, TitanInteger p_int_val) {
        int i;
        p_tlv.chk_constructedFlag(false);
        HashMap<Boolean, TitanInteger> result = new HashMap<Boolean, TitanInteger>();
        if (!p_tlv.isComplete) {
            result.put(false, p_int_val);
            return result;
        }
        if (p_tlv.Vlen == 0) {
            TTCN_EncDec_ErrorContext.error(TTCN_EncDec.error_type.ET_INVAL_MSG, "Length of V-part is 0.", new Object[0]);
            result.put(false, p_int_val);
            return result;
        }
        int Vlen = p_tlv.Vlen;
        if (Vlen >= 4) {
            BigInteger D = new BigInteger(p_tlv.Vstr);
            result.put(true, new TitanInteger(D));
            return result;
        }
        byte[] Vstr = p_tlv.Vstr;
        int intVal = 0;
        if ((Vstr[0] & 0x80) < 0) {
            for (i = 0; i < 4 - Vlen; ++i) {
                intVal |= 0xFF;
                intVal <<= 8;
            }
        }
        intVal |= p_tlv.Vstr[0];
        for (i = 1; i < Vlen; ++i) {
            intVal <<= 8;
            intVal |= p_tlv.Vstr[i];
        }
        p_int_val = new TitanInteger(intVal);
        result.put(true, p_int_val);
        return result;
    }

    public BER.ASN_BER_TLV BER_encode_chk_bound(boolean p_isbound) {
        if (!p_isbound) {
            BER.ASN_BER_TLV newTlv = new BER.ASN_BER_TLV(0, null);
            return newTlv;
        }
        return null;
    }

    public static class TTCN_Typedescriptor {
        public final String name;
        public final BER.ASN_BERdescriptor ber;
        public final RAW.TTCN_RAWdescriptor raw;
        public final JSON.TTCN_JSONdescriptor json;
        public TTCN_Typedescriptor oftype_descr;

        public TTCN_Typedescriptor(String name, BER.ASN_BERdescriptor ber, RAW.TTCN_RAWdescriptor raw, JSON.TTCN_JSONdescriptor json, TTCN_Typedescriptor oftype_descr) {
            this.name = name;
            this.ber = ber;
            this.raw = raw;
            this.json = json;
            this.oftype_descr = oftype_descr;
        }

        public TTCN_Typedescriptor(String name, BER.ASN_BERdescriptor ber, RAW.TTCN_RAWdescriptor raw, JSON.TTCN_JSONdescriptor json) {
            this.name = name;
            this.ber = ber;
            this.raw = raw;
            this.json = json;
            this.oftype_descr = null;
        }

        public TTCN_Typedescriptor(String name, BER.ASN_BERdescriptor ber) {
            this.name = name;
            this.ber = ber;
            this.raw = null;
            this.json = null;
            this.oftype_descr = null;
        }

        public TTCN_Typedescriptor(String name, RAW.TTCN_RAWdescriptor raw) {
            this.name = name;
            this.ber = null;
            this.raw = raw;
            this.json = null;
            this.oftype_descr = null;
        }

        public TTCN_Typedescriptor(String name, JSON.TTCN_JSONdescriptor json) {
            this.name = name;
            this.ber = null;
            this.raw = null;
            this.json = json;
            this.oftype_descr = null;
        }

        public TTCN_Typedescriptor(String name) {
            this.name = name;
            this.ber = null;
            this.raw = null;
            this.json = null;
            this.oftype_descr = null;
        }
    }
}

