/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titanium.graph.clustering;

import edu.uci.ics.jung.graph.DirectedSparseGraph;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.titanium.graph.clustering.ClusteringTools;
import org.eclipse.titanium.graph.clustering.ModuleLocationCluster;
import org.eclipse.titanium.graph.components.EdgeDescriptor;
import org.eclipse.titanium.graph.components.NodeDescriptor;

public class LinkedFileCluster
extends ModuleLocationCluster {
    public LinkedFileCluster(DirectedSparseGraph<NodeDescriptor, EdgeDescriptor> graph, IProject project) {
        super(graph, project);
    }

    @Override
    protected void checkProject(IProgressMonitor progress) throws CoreException {
        IResource[] contents;
        progress.subTask("Cheking " + this.project.getName());
        for (IResource content : contents = this.project.members()) {
            this.check(content, progress);
        }
    }

    protected void checkFile(IFile file) {
        String name = this.parser.containedModuleName(file);
        if (name == null) {
            return;
        }
        this.checkLinkedFile(name, ClusteringTools.truncate(file.getLocation().removeLastSegments(1).toOSString()));
    }

    @Override
    protected void checkFolder(IFolder folder, IProgressMonitor monitor) throws CoreException {
        IResource[] contents;
        monitor.subTask("Checking " + folder.getName());
        for (IResource content : contents = folder.members()) {
            this.check(content, monitor);
        }
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        monitor.worked(1);
    }

    protected void check(IResource content, IProgressMonitor monitor) throws CoreException {
        switch (content.getType()) {
            case 1: {
                this.checkFile((IFile)content);
                break;
            }
            case 2: {
                this.checkFolder((IFolder)content, monitor);
                break;
            }
        }
    }

    @Override
    protected String getType() {
        return "Clustering by absolute path";
    }
}

