/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.time4sys.transformations;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.polarsys.time4sys.mapping.Context;
import org.polarsys.time4sys.mapping.Link;
import org.polarsys.time4sys.mapping.Mapping;
import org.polarsys.time4sys.mapping.MappingFactory;

public class CopierMapper
extends EcoreUtil.Copier {
    protected static final MappingFactory mappingFactory = MappingFactory.eINSTANCE;
    private static final long serialVersionUID = 7035636184301115392L;
    protected final Context identityRule;
    protected final Mapping mapping;
    protected Stack<Link> stack;
    protected final Map<EObject, List<Link>> maps;
    private Collection<Observer> observers = new LinkedList<Observer>();

    public CopierMapper(Mapping mapping, Context identityRule) {
        this.identityRule = identityRule;
        this.mapping = mapping;
        this.stack = new Stack();
        this.stack.push((Link)mapping);
        this.maps = new HashMap<EObject, List<Link>>();
    }

    public EObject copy(EObject eObject) {
        Link lnk = mappingFactory.createLink();
        this.stack.push(lnk);
        EObject theCopy = super.copy(eObject);
        Link o = this.stack.pop();
        assert (lnk == o);
        lnk.getSources().add((Object)mappingFactory.createMappableArtefact("original", eObject));
        lnk.getTargets().add((Object)mappingFactory.createMappableArtefact("copy", theCopy));
        lnk.setRationale(this.identityRule);
        this.stack.peek().getSubLinks().add((Object)lnk);
        this.addMapEntry(eObject, lnk);
        this.addMapEntry(theCopy, lnk);
        this.fireCopied(eObject, lnk, theCopy);
        return theCopy;
    }

    protected void addMapEntry(EObject key, Link lnk) {
        List<Link> links = this.maps.get(key);
        if (links == null) {
            links = new LinkedList<Link>();
            this.maps.put(key, links);
        }
        links.add(lnk);
    }

    public List<Link> getLinksFor(EObject key) {
        return this.maps.get(key);
    }

    public <T extends EObject> T copyAndMap(T eObject) {
        EObject result = this.copy(eObject);
        this.copyReferences();
        EObject t = result;
        return (T)t;
    }

    protected void fireCopied(EObject source, Link lnk, EObject theCopy) {
        for (Observer obs : this.observers) {
            obs.copied(source, lnk, theCopy);
        }
    }

    public boolean addObserver(Observer obs) {
        return this.observers.add(obs);
    }

    protected static interface Observer {
        public void copied(EObject var1, Link var2, EObject var3);
    }
}

