/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.time4sys.builder.design;

import org.polarsys.time4sys.builder.design.DesignBuilder;
import org.polarsys.time4sys.builder.design.StepBuilder;
import org.polarsys.time4sys.builder.design.TaskBuilder;
import org.polarsys.time4sys.marte.gqam.BehaviorScenario;
import org.polarsys.time4sys.marte.gqam.Step;
import org.polarsys.time4sys.marte.gqam.WorkloadEvent;
import org.polarsys.time4sys.marte.nfp.Duration;
import org.polarsys.time4sys.marte.nfp.NfpFactory;
import org.polarsys.time4sys.marte.sam.EndToEndFlow;
import org.polarsys.time4sys.marte.sam.SamFactory;

public class EndToEndFlowConstraintBuilder {
    private StepBuilder stimuli;
    private StepBuilder response;
    private Duration deadline;
    private EndToEndFlow endToEndFlow;

    public static EndToEndFlowConstraintBuilder anEndToEndConstraint() {
        return new EndToEndFlowConstraintBuilder();
    }

    public EndToEndFlowConstraintBuilder() {
    }

    public EndToEndFlowConstraintBuilder(EndToEndFlow value) {
        this.endToEndFlow = value;
    }

    public EndToEndFlowConstraintBuilder from(TaskBuilder task) {
        this.stimuli = task.firstStep();
        return this;
    }

    public EndToEndFlowConstraintBuilder from(StepBuilder step) {
        this.stimuli = step;
        return this;
    }

    public EndToEndFlowConstraintBuilder to(TaskBuilder task) {
        this.response = task.firstStep();
        return this;
    }

    public EndToEndFlowConstraintBuilder withDeadline(String value) {
        this.deadline = NfpFactory.eINSTANCE.createDurationFromString(value);
        return this;
    }

    public void build(DesignBuilder designBuilder) {
        if (this.endToEndFlow == null) {
            this.endToEndFlow = SamFactory.eINSTANCE.createEndToEndFlow();
            designBuilder.build().getEndToEndFlows().add((Object)this.endToEndFlow);
        }
        if (this.stimuli != null) {
            Step initiator = this.stimuli.build();
            for (WorkloadEvent cause : initiator.getCause()) {
                this.endToEndFlow.getEndToEndStimuli().add((Object)cause);
            }
        }
        if (this.response != null) {
            Step endor = this.response.build();
            this.endToEndFlow.setEndToEndScenario((BehaviorScenario)endor);
        }
        if (this.deadline != null) {
            this.endToEndFlow.setEndToEndDeadline(this.deadline);
        }
    }

    public EndToEndFlow build() {
        if (this.endToEndFlow == null) {
            throw new IllegalStateException("Illegal API order of calls.");
        }
        return this.endToEndFlow;
    }
}

