/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.tmf.core.trace;

import org.eclipse.linuxtools.internal.tmf.core.trace.TmfExperimentLocation;
import org.eclipse.linuxtools.internal.tmf.core.trace.TmfLocationArray;
import org.eclipse.linuxtools.tmf.core.event.ITmfEvent;
import org.eclipse.linuxtools.tmf.core.trace.ITmfContext;
import org.eclipse.linuxtools.tmf.core.trace.ITmfLocation;
import org.eclipse.linuxtools.tmf.core.trace.TmfContext;

public class TmfExperimentContext
extends TmfContext {
    public static final int NO_TRACE = -1;
    private final ITmfContext[] fContexts;
    private ITmfEvent[] fEvents;
    private int lastTraceRead;

    public TmfExperimentContext(ITmfContext[] contexts) {
        this.fContexts = contexts;
        this.fEvents = new ITmfEvent[this.fContexts.length];
        ITmfLocation[] locations = new ITmfLocation[this.fContexts.length];
        long[] ranks = new long[this.fContexts.length];
        long rank = 0L;
        int i = 0;
        while (i < this.fContexts.length) {
            if (contexts[i] != null) {
                locations[i] = contexts[i].getLocation();
                ranks[i] = contexts[i].getRank();
                rank += contexts[i].getRank();
            }
            ++i;
        }
        this.setLocation(new TmfExperimentLocation(new TmfLocationArray(locations)));
        this.setRank(rank);
        this.lastTraceRead = -1;
    }

    public TmfExperimentContext(TmfExperimentContext other) {
        this(other.cloneContexts());
        this.fEvents = other.fEvents;
        if (other.getLocation() != null) {
            this.setLocation(other.getLocation().clone());
        }
        this.setRank(other.getRank());
        this.setLastTrace(other.lastTraceRead);
    }

    private ITmfContext[] cloneContexts() {
        ITmfContext[] contexts = new ITmfContext[this.fContexts.length];
        int i = 0;
        while (i < this.fContexts.length) {
            contexts[i] = this.fContexts[i].clone();
            ++i;
        }
        return contexts;
    }

    public ITmfContext[] getContexts() {
        return this.fContexts;
    }

    public ITmfEvent[] getEvents() {
        return this.fEvents;
    }

    public int getLastTrace() {
        return this.lastTraceRead;
    }

    public void setLastTrace(int newIndex) {
        this.lastTraceRead = newIndex;
    }

    @Override
    public int hashCode() {
        int result = 17;
        int i = 0;
        while (i < this.fContexts.length) {
            result = 37 * result + this.fContexts[i].hashCode();
            ++i;
        }
        return result;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!super.equals(other)) {
            return false;
        }
        if (!(other instanceof TmfExperimentContext)) {
            return false;
        }
        TmfExperimentContext o = (TmfExperimentContext)other;
        boolean isEqual = true;
        int i = 0;
        while (isEqual && i < this.fContexts.length) {
            isEqual &= this.fContexts[i].equals(o.fContexts[i]);
            ++i;
        }
        return isEqual;
    }
}

