/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpm.ui.editor.hyperlink;

import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.linuxtools.internal.rpm.ui.editor.SpecfileLog;
import org.eclipse.linuxtools.rpm.ui.editor.parser.SpecfileElement;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class SpecfileElementHyperlink
implements IHyperlink {
    private IRegion region;
    private SpecfileElement source;
    private IFile file;

    public SpecfileElementHyperlink(IRegion region, SpecfileElement source, IFile file) {
        this.region = region;
        this.source = source;
        this.file = file;
    }

    public IRegion getHyperlinkRegion() {
        return this.region;
    }

    public String getHyperlinkText() {
        return null;
    }

    public String getTypeLabel() {
        return null;
    }

    public void open() {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(this.file.getName());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("lineNumber", this.getSource().getLineNumber() + 1);
        map.put("org.eclipse.ui.editorID", desc.getId());
        try {
            IMarker marker = this.file.createMarker("org.eclipse.core.resources.textmarker");
            marker.setAttributes(map);
            IDE.openEditor((IWorkbenchPage)page, (IMarker)marker);
            marker.delete();
        }
        catch (CoreException e) {
            SpecfileLog.logError(e);
        }
    }

    public SpecfileElement getSource() {
        return this.source;
    }
}

