/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.lttng.ui.views.latency.dialogs;

import java.util.Vector;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.linuxtools.internal.lttng.core.latency.analyzer.EventMatcher;
import org.eclipse.linuxtools.internal.lttng.core.util.EventsPair;
import org.eclipse.linuxtools.internal.lttng.ui.views.latency.Messages;
import org.eclipse.linuxtools.internal.lttng.ui.views.latency.dialogs.AbstractDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class ListDialog
extends AbstractDialog {
    protected Table fTable;
    protected Vector<String> fEventStartTypes;
    protected Vector<String> fEventEndTypes;
    protected TableColumn[] fColumns;
    static final String[] COLUMN_NAMES = new String[]{"#", Messages.LatencyView_Dialogs_ListEvents_Columns_Trigger, Messages.LatencyView_Dialogs_ListEvents_Columns_End};
    static final int[] COLUMN_WIDTHS = new int[]{25, 250, 250};
    protected int fStyle = 68100;

    public ListDialog(Shell parentShell, String title, String message) {
        super(parentShell, title, message);
        EventsPair pair = this.getMatchPairs();
        this.fEventStartTypes = (Vector)pair.getFirst();
        this.fEventEndTypes = (Vector)pair.getSecond();
    }

    protected void createColumns() {
        this.fColumns = new TableColumn[COLUMN_NAMES.length];
        int i = 0;
        while (i < COLUMN_NAMES.length) {
            this.fColumns[i] = new TableColumn(this.fTable, 16384);
            this.fColumns[i].setText(COLUMN_NAMES[i]);
            this.fColumns[i].setWidth(COLUMN_WIDTHS[i]);
            ++i;
        }
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        GridLayout layout = new GridLayout(1, true);
        parent.setLayout((Layout)layout);
        GridData layoutData = new GridData(4, 4, true, true);
        this.fTable = new Table(parent, this.fStyle);
        this.fTable.setLayoutData((Object)layoutData);
        this.fTable.setHeaderVisible(true);
        this.fTable.setLinesVisible(true);
        this.createColumns();
        int i = 0;
        while (i < this.fEventStartTypes.size()) {
            TableItem item = new TableItem(this.fTable, 131072);
            String max = String.valueOf(this.fEventStartTypes.size());
            String number = this.formatListNumber(i + 1, max.length());
            String[] columns = new String[]{number, this.fEventStartTypes.get(i), this.fEventEndTypes.get(i)};
            item.setText(columns);
            ++i;
        }
        return parent;
    }

    @Override
    protected void createButtonsForButtonBar(Composite parent) {
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.horizontalSpan = 1;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 131072;
        parent.setLayoutData((Object)gridData);
        Button resetButton = this.createButton(parent, 53447, Messages.LatencyView_Dialogs_ListEvents_Buttons_Reset, false);
        resetButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                boolean confirmDeletion = MessageDialog.openQuestion((Shell)ListDialog.this.getShell(), (String)Messages.LatencyView_Dialogs_ListEvents_Confirm_Title, (String)Messages.LatencyView_Dialogs_ListEvents_Confirm_Message);
                if (confirmDeletion) {
                    EventMatcher.getInstance().resetMatches();
                    ListDialog.this.fTable.removeAll();
                    Vector<String> defaultStarts = new Vector<String>();
                    Vector<String> defaultEnds = new Vector<String>();
                    defaultStarts.add("page_fault_get_user_entry");
                    defaultEnds.add("page_fault_get_user_exit");
                    defaultStarts.add("tasklet_low_entry");
                    defaultEnds.add("tasklet_low_exit");
                    defaultStarts.add("page_fault_entry");
                    defaultEnds.add("page_fault_exit");
                    defaultStarts.add("syscall_entry");
                    defaultEnds.add("syscall_exit");
                    defaultStarts.add("irq_entry");
                    defaultEnds.add("irq_exit");
                    defaultStarts.add("read");
                    defaultEnds.add("write");
                    defaultStarts.add("open");
                    defaultEnds.add("close");
                    defaultStarts.add("buffer_wait_start");
                    defaultEnds.add("buffer_wait_end");
                    defaultStarts.add("start_commit");
                    defaultEnds.add("end_commit");
                    defaultStarts.add("wait_on_page_start");
                    defaultEnds.add("wait_on_page_end");
                    ListDialog.this.saveMatchPairs(defaultStarts, defaultEnds);
                    int i = 0;
                    while (i < defaultStarts.size()) {
                        EventMatcher.getInstance().addMatch(defaultStarts.get(i), defaultEnds.get(i));
                        ++i;
                    }
                    EventsPair pair = ListDialog.this.getMatchPairs();
                    ListDialog.this.fEventStartTypes = (Vector)pair.getFirst();
                    ListDialog.this.fEventEndTypes = (Vector)pair.getSecond();
                    int i2 = 0;
                    while (i2 < ListDialog.this.fEventStartTypes.size()) {
                        TableItem item = new TableItem(ListDialog.this.fTable, 131072);
                        String max = String.valueOf(ListDialog.this.fEventStartTypes.size());
                        String number = ListDialog.this.formatListNumber(i2 + 1, max.length());
                        String[] columns = new String[]{number, ListDialog.this.fEventStartTypes.get(i2), ListDialog.this.fEventEndTypes.get(i2)};
                        item.setText(columns);
                        ++i2;
                    }
                    ListDialog.this.fTable.setItemCount(ListDialog.this.fEventStartTypes.size());
                    ListDialog.this.fRedrawGraphs = true;
                }
            }
        });
        Button closeButton = this.createButton(parent, 1, Messages.LatencyView_Dialogs_ListEvents_Buttons_Close, false);
        closeButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ListDialog.this.setReturnCode(1);
                if (ListDialog.this.fRedrawGraphs) {
                    ListDialog.this.redrawGraphs();
                }
                ListDialog.this.close();
            }
        });
    }
}

