/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.environment;

import java.util.ArrayList;
import org.eclipse.linuxtools.tmf.core.ctfadaptor.CtfTmfTrace;
import org.eclipse.linuxtools.tmf.core.event.TmfEvent;
import org.eclipse.linuxtools.tmf.core.signal.TmfExperimentSelectedSignal;
import org.eclipse.linuxtools.tmf.core.signal.TmfSignalHandler;
import org.eclipse.linuxtools.tmf.core.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.core.trace.TmfExperiment;
import org.eclipse.linuxtools.tmf.ui.views.TmfView;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class TmfEnvironmentView
extends TmfView {
    public static final String ID = "org.eclipse.linuxtools.tmf.ui.views.environment";
    private TmfExperiment<?> fExperiment;
    private Table fTable;
    private final String fTitlePrefix = this.getTitle();
    private Composite fParent;

    public TmfEnvironmentView() {
        super("EnvironmentVariables");
    }

    public void createPartControl(Composite parent) {
        this.fParent = parent;
        TmfExperiment experiment = TmfExperiment.getCurrentExperiment();
        if (experiment == null) {
            return;
        }
        this.fTable = new Table(parent, 2052);
        ArrayList<Pair> tableData = new ArrayList<Pair>();
        ITmfTrace[] iTmfTraceArray = experiment.getTraces();
        int n = iTmfTraceArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITmfTrace trace = iTmfTraceArray[n2];
            Pair traceEntry = new Pair(trace.getName());
            tableData.add(traceEntry);
            if (trace instanceof CtfTmfTrace) {
                CtfTmfTrace ctfTrace = (CtfTmfTrace)trace;
                String[] stringArray = ctfTrace.getEnvNames();
                int n3 = stringArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    String varName = stringArray[n4];
                    tableData.add(new Pair(varName, ctfTrace.getEnvValue(varName)));
                    ++n4;
                }
            }
            ++n2;
        }
        TableColumn nameCol = new TableColumn(this.fTable, 0, 0);
        TableColumn valueCol = new TableColumn(this.fTable, 0, 1);
        nameCol.setText("Environment Variable");
        valueCol.setText("Value");
        int tableSize = tableData.size();
        this.fTable.setItemCount(tableSize);
        TableItem[] ti = this.fTable.getItems();
        int i = 0;
        while (i < tableSize) {
            Pair currentPair = (Pair)tableData.get(i);
            ti[i].setText(0, currentPair.getKey());
            ti[i].setText(1, currentPair.getValue());
            ++i;
        }
        this.fTable.setHeaderVisible(true);
        nameCol.pack();
        valueCol.pack();
        this.fTable.pack();
        parent.layout();
    }

    public void setFocus() {
        this.fTable.setFocus();
    }

    @Override
    public void dispose() {
        if (this.fTable != null) {
            this.fTable.dispose();
        }
        super.dispose();
    }

    @TmfSignalHandler
    public void experimentSelected(TmfExperimentSelectedSignal<TmfEvent> signal) {
        TmfExperiment exp = signal.getExperiment();
        if (!exp.equals(this.fExperiment)) {
            this.fExperiment = exp;
            if (this.fTable != null) {
                this.fTable.dispose();
            }
            this.createPartControl(this.fParent);
            this.fParent.layout();
        }
    }

    private final class Pair {
        private final String key;
        private final String value;

        public Pair(String k) {
            this.key = k;
            this.value = "";
        }

        public Pair(String k, String v) {
            this.key = k;
            this.value = v;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }
    }
}

