/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.charts;

import org.eclipse.birt.chart.api.ChartEngine;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.GeneratedChartState;
import org.eclipse.birt.chart.factory.Generator;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.ChartDimension;
import org.eclipse.birt.chart.model.attribute.IntersectionType;
import org.eclipse.birt.chart.model.attribute.LegendItemType;
import org.eclipse.birt.chart.model.attribute.LineStyle;
import org.eclipse.birt.chart.model.attribute.TickStyle;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.DataElement;
import org.eclipse.birt.chart.model.data.DataSet;
import org.eclipse.birt.chart.model.data.NumberDataSet;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.TextDataSet;
import org.eclipse.birt.chart.model.data.impl.NumberDataElementImpl;
import org.eclipse.birt.chart.model.data.impl.NumberDataSetImpl;
import org.eclipse.birt.chart.model.data.impl.SeriesDefinitionImpl;
import org.eclipse.birt.chart.model.data.impl.TextDataSetImpl;
import org.eclipse.birt.chart.model.impl.ChartWithAxesImpl;
import org.eclipse.birt.chart.model.type.AreaSeries;
import org.eclipse.birt.chart.model.type.impl.AreaSeriesImpl;
import org.eclipse.birt.core.framework.PlatformConfig;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.nonui.adapters.IAdapter;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.nonui.structures.NumberType;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.charts.AbstractChartBuilder;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.charts.AbstractChartWithAxisBuilder;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.internal.GraphingAPIUIPlugin;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;

public class AreaChartBuilder
extends AbstractChartWithAxisBuilder {
    protected IDeviceRenderer render = null;
    protected ChartWithAxes chart = null;
    protected AbstractChartBuilder builder = null;
    protected GeneratedChartState state = null;
    String[] x;
    Double[] y;
    boolean fullUpdate;
    Object[][] data;
    Composite parent = null;
    String[] labels;
    protected static int xSeriesTicks;
    protected static int ySeriesTicks;
    protected static int maxItems;
    protected static int viewableItems;
    public static final String ID = "org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.charts.areachartbuilder";
    Double min = 0.0;
    Double max = 0.0;

    public AreaChartBuilder(Composite parent, int style, String title, IAdapter adapter) {
        super(adapter, parent, style);
        this.title = title;
        this.parent = parent;
        try {
            PlatformConfig pf = new PlatformConfig();
            ChartEngine ce = ChartEngine.instance((PlatformConfig)pf);
            this.render = ce.getRenderer("dv.SWT");
        }
        catch (Exception exception) {}
        this.addPaintListener(new painter());
    }

    protected void createChart() {
        IPreferenceStore store = GraphingAPIUIPlugin.getDefault().getPreferenceStore();
        xSeriesTicks = store.getInt("XSeriesTicks");
        ySeriesTicks = store.getInt("YSeriesTicks");
        maxItems = store.getInt("MaxDataItems");
        viewableItems = store.getInt("ViewableDataItems");
        this.chart = ChartWithAxesImpl.create();
        this.chart.setDimension(ChartDimension.TWO_DIMENSIONAL_LITERAL);
        this.chart.setType("Line Chart");
    }

    protected void buildLegend() {
        this.createLegend();
        this.chart.getLegend().setItemType(LegendItemType.SERIES_LITERAL);
        this.chart.getLegend().getClientArea().getOutline().setVisible(true);
        this.chart.getLegend().getText().getFont().setSize(7.0f);
        this.chart.getLegend().setVisible(true);
    }

    protected void buildTitle() {
        this.chart.getTitle().getLabel().getCaption().setValue(this.title);
        this.chart.getTitle().getLabel().getCaption().getFont().setSize(10.0f);
        this.chart.getTitle().getLabel().getCaption().getFont().setName("MS Sans Serif");
    }

    protected void buildXAxis() {
        this.xAxis = this.chart.getPrimaryBaseAxes()[0];
        this.xAxis.getTitle().setVisible(true);
        this.xAxis.getTitle().getCaption().setValue(this.labels[0]);
        this.xAxis.getMajorGrid().setTickStyle(TickStyle.BELOW_LITERAL);
        this.xAxis.setType(AxisType.TEXT_LITERAL);
        this.xAxis.getOrigin().setType(IntersectionType.VALUE_LITERAL);
        this.xAxis.getTitle().getCaption().getFont().setSize(8.0f);
        this.xAxis.getLabel().getCaption().getFont().setSize(6.0f);
    }

    protected void buildYAxis() {
        this.yAxis = this.chart.getPrimaryOrthogonalAxis(this.xAxis);
        this.yAxis.getMajorGrid().getLineAttributes().setVisible(true);
        this.yAxis.getMajorGrid().getLineAttributes().setStyle(LineStyle.DASHED_LITERAL);
        this.yAxis.getMajorGrid().setTickStyle(TickStyle.LEFT_LITERAL);
        this.yAxis.setType(AxisType.LINEAR_LITERAL);
        this.yAxis.getOrigin().setType(IntersectionType.VALUE_LITERAL);
        this.yAxis.getTitle().getCaption().getFont().setSize(8.0f);
        this.yAxis.getLabel().getCaption().getFont().setSize(6.0f);
    }

    protected void buildXSeries() {
        this.data = this.adapter.getData();
        int starting = 0;
        if (this.data.length > xSeriesTicks) {
            starting = this.data.length - xSeriesTicks;
        }
        this.x = new String[this.data.length - starting];
        try {
            int j = starting;
            int k = 0;
            while (j < this.data.length) {
                this.x[k] = this.data[j][0].toString();
                ++j;
                ++k;
            }
        }
        catch (Exception exception) {}
        TextDataSet categoryValues = TextDataSetImpl.create((Object)this.x);
        Series seCategory = SeriesImpl.create();
        seCategory.setDataSet((DataSet)categoryValues);
        SeriesDefinition sdX = SeriesDefinitionImpl.create();
        sdX.getSeriesPalette().update(1);
        this.xAxis.getSeriesDefinitions().add((Object)sdX);
        sdX.getSeries().add((Object)seCategory);
    }

    protected void buildYSeries() {
        try {
            int starting = 0;
            if (this.data.length > xSeriesTicks) {
                starting = this.data.length - xSeriesTicks;
            }
            int yseriescount = this.adapter.getSeriesCount();
            NumberDataSet[] orthoValuesDataSet = new NumberDataSet[yseriescount];
            AreaSeries[] as1 = new AreaSeries[yseriescount];
            SeriesDefinition[] sdY = new SeriesDefinition[yseriescount];
            int i = 1;
            while (i <= yseriescount) {
                this.y = new Double[this.data.length - starting];
                int j = starting;
                int k = 0;
                while (j < this.data.length) {
                    this.y[k] = NumberType.obj2num((Object)this.data[j][i]).doubleValue();
                    if (this.max < this.y[k]) {
                        this.max = this.y[k];
                    }
                    if (this.min > this.y[k]) {
                        this.min = this.y[k];
                    }
                    ++j;
                    ++k;
                }
                orthoValuesDataSet[i - 1] = NumberDataSetImpl.create((Object)this.y);
                as1[i - 1] = (AreaSeries)AreaSeriesImpl.create();
                as1[i - 1].setDataSet((DataSet)orthoValuesDataSet[i - 1]);
                as1[i - 1].setSeriesIdentifier((Object)this.labels[i]);
                sdY[i - 1] = SeriesDefinitionImpl.create();
                sdY[i - 1].getSeriesPalette().update(0 - i - 2);
                this.yAxis.getSeriesDefinitions().add((Object)sdY[i - 1]);
                sdY[i - 1].getSeries().add((Object)as1[i - 1]);
                ++i;
            }
            this.yAxis.getScale().setStep(this.max / 2.0);
            this.yAxis.getScale().setMax((DataElement)NumberDataElementImpl.create((double)this.max));
        }
        catch (Exception exception) {}
    }

    public void updateDataSet() {
        try {
            this.data = this.adapter.getData();
            int starting = 0;
            if (this.data.length > xSeriesTicks) {
                starting = this.data.length - xSeriesTicks;
            }
            this.x = new String[this.data.length - starting];
            int j = starting;
            int k = 0;
            while (j < this.data.length) {
                this.x[k] = this.data[j][0].toString();
                ++j;
                ++k;
            }
            TextDataSet categoryValues = TextDataSetImpl.create((Object)this.x);
            Axis xAxisPrimary = this.chart.getPrimaryBaseAxes()[0];
            SeriesDefinition sdX = (SeriesDefinition)xAxisPrimary.getSeriesDefinitions().get(0);
            ((Series)sdX.getSeries().get(0)).setDataSet((DataSet)categoryValues);
            Axis yAxisPrimary = this.chart.getPrimaryOrthogonalAxis(xAxisPrimary);
            NumberDataSet[] orthoValuesDataSet1 = new NumberDataSet[this.adapter.getSeriesCount()];
            int i = 1;
            while (i <= this.adapter.getSeriesCount()) {
                this.y = new Double[this.data.length - starting];
                int j2 = starting;
                int k2 = 0;
                while (j2 < this.data.length) {
                    this.y[k2] = NumberType.obj2num((Object)this.data[j2][i]).doubleValue();
                    if (this.max < this.y[k2]) {
                        this.max = this.y[k2];
                    }
                    ++j2;
                    ++k2;
                }
                orthoValuesDataSet1[i - 1] = NumberDataSetImpl.create((Object)this.y);
                SeriesDefinition sdY = (SeriesDefinition)yAxisPrimary.getSeriesDefinitions().get(i - 1);
                ((Series)sdY.getSeries().get(0)).setDataSet((DataSet)orthoValuesDataSet1[i - 1]);
                ++i;
            }
            this.yAxis.getScale().setStep(this.max / 5.0);
            this.yAxis.getScale().setMax((DataElement)NumberDataElementImpl.create((double)this.max));
        }
        catch (Exception exception) {}
    }

    public void handleUpdateEvent() {
        try {
            this.updateDataSet();
            this.repaint();
        }
        catch (Exception exception) {}
    }

    public synchronized void repaint() {
        this.getDisplay().syncExec(new Runnable(){
            boolean stop = false;

            public void run() {
                if (this.stop) {
                    return;
                }
                try {
                    AreaChartBuilder.this.redraw();
                }
                catch (Exception exception) {
                    this.stop = true;
                }
            }
        });
    }

    protected void createLegend() {
        this.labels = this.adapter.getLabels();
        String[] labels2 = new String[this.labels.length - 1];
        int i = 0;
        while (i < labels2.length) {
            labels2[i] = this.labels[i + 1];
            ++i;
        }
    }

    public void setScale(double scale) {
        IPreferenceStore store = GraphingAPIUIPlugin.getDefault().getPreferenceStore();
        xSeriesTicks = store.getInt("XSeriesTicks");
        xSeriesTicks = (int)(Integer.valueOf(xSeriesTicks).doubleValue() * scale);
        this.handleUpdateEvent();
    }

    private class painter
    implements PaintListener {
        private painter() {
        }

        public void paintControl(PaintEvent pe) {
            if (AreaChartBuilder.this.chart == null) {
                return;
            }
            try {
                AreaChartBuilder.this.render.setProperty("device.output.context", (Object)pe.gc);
                Composite co = (Composite)pe.getSource();
                Rectangle re = co.getClientArea();
                Bounds bo = BoundsImpl.create((double)re.x, (double)re.y, (double)re.width, (double)re.height);
                bo.scale(72.0 / (double)AreaChartBuilder.this.render.getDisplayServer().getDpiResolution());
                Generator gr = Generator.instance();
                AreaChartBuilder.this.state = gr.build(AreaChartBuilder.this.render.getDisplayServer(), (Chart)AreaChartBuilder.this.chart, bo, null, null, null);
                gr.render(AreaChartBuilder.this.render, AreaChartBuilder.this.state);
            }
            catch (ChartException chartException) {}
        }
    }
}

