/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng.ui.views.histogram;

import org.eclipse.linuxtools.lttng.event.LttngEvent;
import org.eclipse.linuxtools.lttng.ui.views.histogram.FullTraceHistogram;
import org.eclipse.linuxtools.lttng.ui.views.histogram.HistogramCurrentTimeControl;
import org.eclipse.linuxtools.lttng.ui.views.histogram.HistogramRequest;
import org.eclipse.linuxtools.lttng.ui.views.histogram.HistogramTextControl;
import org.eclipse.linuxtools.lttng.ui.views.histogram.HistogramTimeRangeControl;
import org.eclipse.linuxtools.lttng.ui.views.histogram.HistogramUtils;
import org.eclipse.linuxtools.lttng.ui.views.histogram.Messages;
import org.eclipse.linuxtools.lttng.ui.views.histogram.TimeRangeHistogram;
import org.eclipse.linuxtools.tmf.event.TmfTimeRange;
import org.eclipse.linuxtools.tmf.event.TmfTimestamp;
import org.eclipse.linuxtools.tmf.experiment.TmfExperiment;
import org.eclipse.linuxtools.tmf.request.ITmfDataRequest;
import org.eclipse.linuxtools.tmf.signal.TmfExperimentRangeUpdatedSignal;
import org.eclipse.linuxtools.tmf.signal.TmfExperimentSelectedSignal;
import org.eclipse.linuxtools.tmf.signal.TmfRangeSynchSignal;
import org.eclipse.linuxtools.tmf.signal.TmfSignal;
import org.eclipse.linuxtools.tmf.signal.TmfSignalHandler;
import org.eclipse.linuxtools.tmf.signal.TmfSignalManager;
import org.eclipse.linuxtools.tmf.signal.TmfTimeSynchSignal;
import org.eclipse.linuxtools.tmf.ui.views.TmfView;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class HistogramView
extends TmfView {
    public static final String ID = "org.eclipse.linuxtools.lttng.ui.views.histogram";
    public static long INITIAL_WINDOW_SPAN = 100000000L;
    private final byte TIME_SCALE = (byte)-9;
    private Composite fParent;
    private TmfExperiment<LttngEvent> fCurrentExperiment;
    private long fExperimentStartTime;
    private long fExperimentEndTime;
    private long fWindowStartTime;
    private long fWindowEndTime;
    private long fWindowSpan = INITIAL_WINDOW_SPAN;
    private long fCurrentTimestamp;
    private HistogramTextControl fCurrentEventTimeControl;
    private HistogramTextControl fTimeSpanControl;
    private static FullTraceHistogram fFullTraceHistogram;
    private HistogramRequest fFullTraceRequest;
    private static TimeRangeHistogram fTimeRangeHistogram;
    private HistogramRequest fTimeRangeRequest;

    public HistogramView() {
        super(ID);
    }

    public void dispose() {
        if (this.fTimeRangeRequest != null && !this.fTimeRangeRequest.isCompleted()) {
            this.fTimeRangeRequest.cancel();
        }
        if (this.fFullTraceRequest != null && !this.fFullTraceRequest.isCompleted()) {
            this.fFullTraceRequest.cancel();
        }
        fFullTraceHistogram.dispose();
        fTimeRangeHistogram.dispose();
        super.dispose();
    }

    public void createPartControl(Composite parent) {
        this.fParent = parent;
        String currentEventLabel = Messages.HistogramView_currentEventLabel;
        String windowSpanLabel = Messages.HistogramView_windowSpanLabel;
        Composite viewComposite = new Composite(this.fParent, 4);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.horizontalSpacing = 5;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        viewComposite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        viewComposite.setLayoutData((Object)gridData);
        Composite controlsComposite = new Composite(viewComposite, 4);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 5;
        gridLayout.verticalSpacing = 0;
        gridLayout.makeColumnsEqualWidth = true;
        gridLayout.marginLeft = 5;
        gridLayout.marginRight = 5;
        controlsComposite.setLayout((Layout)gridLayout);
        gridData = new GridData();
        gridData.horizontalAlignment = 0x1000000;
        gridData.verticalAlignment = 0x1000000;
        this.fCurrentEventTimeControl = new HistogramCurrentTimeControl(this, controlsComposite, 2048, 2048, currentEventLabel, HistogramUtils.nanosecondsToString(0L));
        this.fCurrentEventTimeControl.setLayoutData(gridData);
        gridData = new GridData();
        gridData.horizontalAlignment = 0x1000000;
        gridData.verticalAlignment = 0x1000000;
        this.fTimeSpanControl = new HistogramTimeRangeControl(this, controlsComposite, 2048, 2048, windowSpanLabel, HistogramUtils.nanosecondsToString(0L));
        this.fTimeSpanControl.setLayoutData(gridData);
        Composite timeRangeComposite = new Composite(viewComposite, 4);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginTop = 5;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginLeft = 5;
        gridLayout.marginRight = 5;
        timeRangeComposite.setLayout((Layout)gridLayout);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        timeRangeComposite.setLayoutData((Object)gridData);
        fTimeRangeHistogram = new TimeRangeHistogram(this, timeRangeComposite);
        Composite fullRangeComposite = new Composite(viewComposite, 4);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginTop = 5;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginLeft = 5;
        gridLayout.marginRight = 5;
        fullRangeComposite.setLayout((Layout)gridLayout);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.horizontalSpan = 2;
        gridData.grabExcessHorizontalSpace = true;
        fullRangeComposite.setLayoutData((Object)gridData);
        fFullTraceHistogram = new FullTraceHistogram(this, fullRangeComposite);
        this.fCurrentExperiment = TmfExperiment.getCurrentExperiment();
        if (this.fCurrentExperiment != null) {
            this.loadExperiment();
        }
    }

    public void setFocus() {
        TmfExperiment experiment = TmfExperiment.getCurrentExperiment();
        if (experiment != null && experiment != this.fCurrentExperiment) {
            this.fCurrentExperiment = experiment;
            this.initializeHistograms();
        }
        this.fParent.redraw();
    }

    public TmfTimeRange getTimeRange() {
        return new TmfTimeRange(new TmfTimestamp(this.fWindowStartTime, -9), new TmfTimestamp(this.fWindowEndTime, -9));
    }

    public void updateCurrentEventTime(long newTime) {
        if (this.fCurrentExperiment != null) {
            TmfTimeRange timeRange = new TmfTimeRange(new TmfTimestamp(newTime, -9), TmfTimestamp.BigCrunch);
            HistogramRequest request = new HistogramRequest(fTimeRangeHistogram, timeRange, 0, 1, ITmfDataRequest.ExecutionType.FOREGROUND){

                @Override
                public void handleData(LttngEvent event) {
                    if (event != null) {
                        TmfTimeSynchSignal signal = new TmfTimeSynchSignal((Object)this, event.getTimestamp());
                        TmfSignalManager.dispatchSignal((TmfSignal)signal);
                    }
                }
            };
            this.fCurrentExperiment.sendRequest((ITmfDataRequest)request);
        }
    }

    public void updateTimeRange(long startTime, long endTime) {
        if (this.fCurrentExperiment != null) {
            TmfTimeRange timeRange = new TmfTimeRange(new TmfTimestamp(startTime, -9), new TmfTimestamp(endTime, -9));
            TmfTimestamp currentTime = new TmfTimestamp(this.fCurrentTimestamp, -9);
            this.fTimeSpanControl.setValue(endTime - startTime);
            TmfRangeSynchSignal signal = new TmfRangeSynchSignal((Object)this, timeRange, currentTime);
            TmfSignalManager.dispatchSignal((TmfSignal)signal);
        }
    }

    public synchronized void updateTimeRange(long newDuration) {
        if (this.fCurrentExperiment != null) {
            long delta = newDuration - this.fWindowSpan;
            long newStartTime = this.fWindowStartTime + delta / 2L;
            this.setNewRange(newStartTime, newDuration);
        }
    }

    private void setNewRange(long startTime, long duration) {
        long endTime;
        if (startTime < this.fExperimentStartTime) {
            startTime = this.fExperimentStartTime;
        }
        if ((endTime = startTime + duration) > this.fExperimentEndTime) {
            endTime = this.fExperimentEndTime;
            startTime = endTime - duration > this.fExperimentStartTime ? endTime - duration : this.fExperimentStartTime;
        }
        this.updateTimeRange(startTime, endTime);
    }

    @TmfSignalHandler
    public void experimentSelected(TmfExperimentSelectedSignal<LttngEvent> signal) {
        assert (signal != null);
        this.fCurrentExperiment = signal.getExperiment();
        this.loadExperiment();
    }

    private void loadExperiment() {
        this.initializeHistograms();
        this.fParent.redraw();
    }

    @TmfSignalHandler
    public void experimentRangeUpdated(TmfExperimentRangeUpdatedSignal signal) {
        this.fCurrentExperiment = signal.getExperiment();
        boolean drawTimeRangeHistogram = this.fExperimentStartTime == 0L;
        TmfTimeRange fullRange = signal.getRange();
        this.fExperimentStartTime = fullRange.getStartTime().getValue();
        this.fExperimentEndTime = fullRange.getEndTime().getValue();
        fFullTraceHistogram.setFullRange(this.fExperimentStartTime, this.fExperimentEndTime);
        fTimeRangeHistogram.setFullRange(this.fExperimentStartTime, this.fExperimentEndTime);
        if (drawTimeRangeHistogram) {
            this.fCurrentTimestamp = this.fExperimentStartTime;
            this.fCurrentEventTimeControl.setValue(this.fCurrentTimestamp);
            fFullTraceHistogram.setTimeRange(this.fExperimentStartTime, INITIAL_WINDOW_SPAN);
            fTimeRangeHistogram.setTimeRange(this.fExperimentStartTime, INITIAL_WINDOW_SPAN);
            this.sendTimeRangeRequest(this.fExperimentStartTime, this.fExperimentStartTime + INITIAL_WINDOW_SPAN);
        }
        this.sendFullRangeRequest(fullRange);
    }

    @TmfSignalHandler
    public void currentTimeUpdated(TmfTimeSynchSignal signal) {
        assert (signal != null);
        TmfTimestamp currentTime = signal.getCurrentTime();
        this.fCurrentTimestamp = currentTime.getValue();
        fFullTraceHistogram.setCurrentEvent(this.fCurrentTimestamp);
        fTimeRangeHistogram.setCurrentEvent(this.fCurrentTimestamp);
        this.fCurrentEventTimeControl.setValue(this.fCurrentTimestamp);
    }

    @TmfSignalHandler
    public void timeRangeUpdated(TmfRangeSynchSignal signal) {
        assert (signal != null);
        if (this.fCurrentExperiment != null) {
            this.fWindowStartTime = signal.getCurrentRange().getStartTime().getValue();
            this.fWindowEndTime = signal.getCurrentRange().getEndTime().getValue();
            this.fWindowSpan = this.fWindowEndTime - this.fWindowStartTime;
            this.sendTimeRangeRequest(this.fWindowStartTime, this.fWindowEndTime);
            fFullTraceHistogram.setTimeRange(this.fWindowStartTime, this.fWindowSpan);
            this.fTimeSpanControl.setValue(this.fWindowSpan);
        }
    }

    private void initializeHistograms() {
        TmfTimeRange fullRange = this.updateExperimentTimeRange(this.fCurrentExperiment);
        fTimeRangeHistogram.clear();
        fTimeRangeHistogram.setFullRange(this.fExperimentStartTime, this.fExperimentEndTime);
        fTimeRangeHistogram.setTimeRange(this.fExperimentStartTime, INITIAL_WINDOW_SPAN);
        fTimeRangeHistogram.setCurrentEvent(this.fExperimentStartTime);
        fFullTraceHistogram.clear();
        fFullTraceHistogram.setFullRange(this.fExperimentStartTime, this.fExperimentEndTime);
        fFullTraceHistogram.setTimeRange(this.fExperimentStartTime, INITIAL_WINDOW_SPAN);
        fFullTraceHistogram.setCurrentEvent(this.fExperimentStartTime);
        this.fWindowStartTime = this.fExperimentStartTime;
        this.fWindowSpan = INITIAL_WINDOW_SPAN;
        this.fWindowEndTime = this.fWindowStartTime + this.fWindowSpan;
        this.fCurrentEventTimeControl.setValue(this.fExperimentStartTime);
        this.fTimeSpanControl.setValue(this.fWindowSpan);
        this.sendTimeRangeRequest(this.fExperimentStartTime, this.fExperimentStartTime + this.fWindowSpan);
        this.sendFullRangeRequest(fullRange);
    }

    private TmfTimeRange updateExperimentTimeRange(TmfExperiment<LttngEvent> experiment) {
        this.fExperimentStartTime = 0L;
        this.fExperimentEndTime = 0L;
        this.fCurrentTimestamp = 0L;
        TmfTimeRange timeRange = this.fCurrentExperiment.getTimeRange();
        if (timeRange != TmfTimeRange.Null) {
            this.fExperimentStartTime = timeRange.getStartTime().getValue();
            this.fExperimentEndTime = timeRange.getEndTime().getValue();
            this.fCurrentTimestamp = this.fExperimentStartTime;
        }
        return timeRange;
    }

    private void sendTimeRangeRequest(long startTime, long endTime) {
        if (this.fTimeRangeRequest != null && !this.fTimeRangeRequest.isCompleted()) {
            this.fTimeRangeRequest.cancel();
        }
        TmfTimestamp startTS = new TmfTimestamp(startTime, -9);
        TmfTimestamp endTS = new TmfTimestamp(endTime, -9);
        TmfTimeRange timeRange = new TmfTimeRange(startTS, endTS);
        fTimeRangeHistogram.clear();
        fTimeRangeHistogram.setTimeRange(startTime, endTime - startTime);
        this.fTimeRangeRequest = new HistogramRequest(fTimeRangeHistogram, timeRange, ITmfDataRequest.ExecutionType.FOREGROUND);
        this.fCurrentExperiment.sendRequest((ITmfDataRequest)this.fTimeRangeRequest);
    }

    private void sendFullRangeRequest(TmfTimeRange fullRange) {
        if (this.fFullTraceRequest != null && !this.fFullTraceRequest.isCompleted()) {
            this.fFullTraceRequest.cancel();
        }
        this.fFullTraceRequest = new HistogramRequest(fFullTraceHistogram, fullRange, (int)HistogramView.fFullTraceHistogram.fDataModel.getNbEvents(), ITmfDataRequest.ExecutionType.BACKGROUND);
        this.fCurrentExperiment.sendRequest((ITmfDataRequest)this.fFullTraceRequest);
    }
}

