/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng.ui.tracecontrol.actions;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.linuxtools.lttng.tracecontrol.model.TraceResource;
import org.eclipse.linuxtools.lttng.tracecontrol.model.config.TraceConfig;
import org.eclipse.linuxtools.lttng.tracecontrol.service.ILttControllerService;
import org.eclipse.linuxtools.lttng.tracecontrol.service.LttControllerServiceProxy;
import org.eclipse.linuxtools.lttng.ui.LTTngUiPlugin;
import org.eclipse.linuxtools.lttng.ui.tracecontrol.Messages;
import org.eclipse.linuxtools.lttng.ui.tracecontrol.subsystems.TraceSubSystem;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.model.SystemStartHere;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tm.tcf.protocol.IToken;
import org.eclipse.tm.tcf.util.TCFTask;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class StopTrace
implements IObjectActionDelegate,
IWorkbenchWindowActionDelegate,
IViewActionDelegate {
    private List<TraceResource> fSelectedTraces = new ArrayList<TraceResource>();

    public void setActivePart(IAction arg0, IWorkbenchPart arg1) {
    }

    public void run(IAction arg0) {
        int size = this.fSelectedTraces.size();
        int i = 0;
        while (i < size) {
            TraceResource trace = this.fSelectedTraces.get(i);
            TraceSubSystem subSystem = (TraceSubSystem)trace.getSubSystem();
            try {
                LttControllerServiceProxy service = subSystem.getControllerService();
                TraceConfig traceConfig = trace.getTraceConfig();
                if (traceConfig != null && traceConfig.getMode() == 1) {
                    this.setupLocation((ILttControllerService)service, trace, traceConfig);
                }
                Boolean cfr_ignored_0 = (Boolean)new TCFTask<Boolean>((ILttControllerService)service, trace){
                    private final /* synthetic */ ILttControllerService val$service;
                    private final /* synthetic */ TraceResource val$trace;
                    {
                        this.val$service = iLttControllerService;
                        this.val$trace = traceResource;
                    }

                    public void run() {
                        this.val$service.destroyTrace(this.val$trace.getParent().getParent().getName(), this.val$trace.getParent().getName(), this.val$trace.getName(), new ILttControllerService.DoneDestroyTrace(){

                            public void doneDestroyTrace(IToken token, Exception error, Object str) {
                                if (error != null) {
                                    this.error(error);
                                    return;
                                }
                                this.done(true);
                            }
                        });
                    }
                }.get(10L, TimeUnit.SECONDS);
                trace.setTraceState(TraceResource.TraceState.STOPPED);
                ISystemRegistry registry = SystemStartHere.getSystemRegistry();
                registry.fireRemoteResourceChangeEvent(4, (Object)trace, (Object)trace.getParent(), (ISubSystem)subSystem, null);
            }
            catch (Exception e) {
                SystemMessageException sysExp = e instanceof SystemMessageException ? (SystemMessageException)((Object)e) : new SystemMessageException(LTTngUiPlugin.getDefault().getMessage(e));
                SystemBasePlugin.logError((String)(String.valueOf(Messages.Lttng_Control_ErrorStop) + " (" + Messages.Lttng_Resource_Trace + ": " + trace.getName() + ")"), (Throwable)sysExp);
            }
            ++i;
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.fSelectedTraces.clear();
            for (Object obj : (IStructuredSelection)selection) {
                if (!(obj instanceof TraceResource)) continue;
                this.fSelectedTraces.add((TraceResource)obj);
            }
        }
    }

    protected Shell getShell() {
        return SystemBasePlugin.getActiveWorkbenchShell();
    }

    public void init(IWorkbenchWindow window) {
    }

    public void dispose() {
    }

    public void init(IViewPart view) {
    }

    private void setupLocation(final ILttControllerService service, final TraceResource trace, final TraceConfig traceConfig) throws Exception {
        boolean success = false;
        success = traceConfig.isNetworkTrace() ? ((Boolean)new TCFTask<Boolean>(){

            public void run() {
                service.writeTraceNetwork(trace.getParent().getParent().getName(), trace.getParent().getName(), traceConfig.getTraceName(), traceConfig.getNumChannel(), Boolean.valueOf(traceConfig.getIsAppend()), Boolean.valueOf(true), Boolean.valueOf(false), new ILttControllerService.DoneWriteTraceNetwork(){

                    public void doneWriteTraceNetwork(IToken token, Exception error, Object str) {
                        if (error != null) {
                            this.error(error);
                            return;
                        }
                        this.done(true);
                    }
                });
            }
        }.get(10L, TimeUnit.SECONDS)).booleanValue() : ((Boolean)new TCFTask<Boolean>(){

            public void run() {
                service.writeTraceLocal(trace.getParent().getParent().getName(), trace.getParent().getName(), traceConfig.getTraceName(), traceConfig.getTracePath(), traceConfig.getNumChannel(), Boolean.valueOf(traceConfig.getIsAppend()), Boolean.valueOf(true), Boolean.valueOf(false), new ILttControllerService.DoneWriteTraceLocal(){

                    public void doneWriteTraceLocal(IToken token, Exception error, Object str) {
                        if (error != null) {
                            this.error(error);
                            return;
                        }
                        this.done(true);
                    }
                });
            }
        }.get(10L, TimeUnit.SECONDS)).booleanValue();
        if (success) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

