/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.gprof.action;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.linuxtools.dataviewers.abstractview.AbstractSTDataView;
import org.eclipse.linuxtools.dataviewers.abstractviewers.AbstractSTTreeViewer;
import org.eclipse.linuxtools.gprof.Activator;
import org.eclipse.linuxtools.gprof.parser.GmonDecoder;
import org.eclipse.linuxtools.gprof.view.fields.SampleProfField;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeColumn;

public class SwitchSampleTimeAction
extends Action {
    private final AbstractSTDataView view;

    public SwitchSampleTimeAction(AbstractSTDataView view) {
        super("Switch sample/time", 2);
        this.setImageDescriptor(Activator.getImageDescriptor("icons/datetime_obj.gif"));
        this.setToolTipText("Switch sample/time");
        this.view = view;
    }

    public void run() {
        AbstractSTTreeViewer gmonViewer = (AbstractSTTreeViewer)this.view.getSTViewer();
        GmonDecoder decoder = (GmonDecoder)gmonViewer.getInput();
        if (decoder != null) {
            int prof_rate = decoder.getHistogramDecoder().getProf_rate();
            if (prof_rate == 0) {
                MessageDialog.openError((Shell)this.view.getSite().getShell(), (String)"Gmon prof rate is null", (String)"Unable to display time, because profiling rate is null");
                return;
            }
            TreeColumn tc = gmonViewer.getViewer().getTree().getColumn(1);
            SampleProfField spf = (SampleProfField)((Object)tc.getData());
            spf.toggle();
            tc.setText(spf.getColumnHeaderText());
            gmonViewer.getViewer().refresh();
        }
    }
}

