/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.dataviewers.abstractviewers;

import java.text.NumberFormat;
import org.eclipse.linuxtools.dataviewers.abstractviewers.AbstractSTDataViewersField;
import org.eclipse.linuxtools.dataviewers.listeners.ISpecialDrawerListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;

public abstract class AbstractPercentageDrawerField
extends AbstractSTDataViewersField
implements ISpecialDrawerListener {
    @Override
    public ISpecialDrawerListener getSpecialDrawer(Object obj) {
        return this;
    }

    @Override
    public String getValue(Object obj) {
        return String.valueOf(this.getPercentage(obj));
    }

    public abstract float getPercentage(Object var1);

    public void handleEvent(Event event) {
        Item item = (Item)event.item;
        Display display = event.widget.getDisplay();
        int index = event.index;
        int widthcol = 0;
        if (event.widget instanceof Tree) {
            Tree tree = (Tree)event.widget;
            widthcol = tree.getColumn(index).getWidth();
        } else {
            Table table = (Table)event.widget;
            widthcol = table.getColumn(index).getWidth();
        }
        float d = this.getPercentage(item.getData());
        int percent = (int)((double)d + 0.5);
        GC gc = event.gc;
        Color foreground = gc.getForeground();
        Color background = gc.getBackground();
        gc.setForeground(display.getSystemColor(3));
        gc.setBackground(display.getSystemColor(7));
        int width = (widthcol - 1) * percent / 100;
        if (width > 0) {
            gc.fillGradientRectangle(event.x, event.y, width, event.height, true);
            Rectangle rect = new Rectangle(event.x, event.y, width - 1, event.height - 1);
            gc.drawRectangle(rect);
        }
        gc.setForeground(display.getSystemColor(24));
        String text = "%";
        text = (this.isSettedNumberFormat() ? this.getNumberFormat().format(d) : Float.valueOf(d)) + text;
        Point size = gc.textExtent(text);
        int offset = Math.max(0, (event.height - size.y) / 2);
        gc.drawText(text, event.x + 2, event.y + offset, true);
        gc.setForeground(foreground);
        gc.setBackground(background);
    }

    public abstract NumberFormat getNumberFormat();

    public abstract boolean isSettedNumberFormat();
}

