/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.filter.xml;

import java.util.Stack;
import org.eclipse.linuxtools.tmf.filter.model.ITmfFilterTreeNode;
import org.eclipse.linuxtools.tmf.filter.model.TmfFilterAndNode;
import org.eclipse.linuxtools.tmf.filter.model.TmfFilterCompareNode;
import org.eclipse.linuxtools.tmf.filter.model.TmfFilterContainsNode;
import org.eclipse.linuxtools.tmf.filter.model.TmfFilterEqualsNode;
import org.eclipse.linuxtools.tmf.filter.model.TmfFilterEventTypeNode;
import org.eclipse.linuxtools.tmf.filter.model.TmfFilterMatchesNode;
import org.eclipse.linuxtools.tmf.filter.model.TmfFilterNode;
import org.eclipse.linuxtools.tmf.filter.model.TmfFilterOrNode;
import org.eclipse.linuxtools.tmf.filter.model.TmfFilterRootNode;
import org.eclipse.linuxtools.tmf.filter.model.TmfFilterTreeNode;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TmfFilterContentHandler
extends DefaultHandler {
    private ITmfFilterTreeNode fRoot = null;
    private Stack<ITmfFilterTreeNode> fFilterTreeStack = new Stack();

    public ITmfFilterTreeNode getTree() {
        return this.fRoot;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        TmfFilterTreeNode node = null;
        if (localName.equalsIgnoreCase("ROOT")) {
            node = new TmfFilterRootNode();
        } else if (localName.equals("FILTER")) {
            node = new TmfFilterNode(atts.getValue("name"));
        } else if (localName.equals("EVENTTYPE")) {
            node = new TmfFilterEventTypeNode(null);
            ((TmfFilterEventTypeNode)node).setEventType(atts.getValue("type"));
            ((TmfFilterEventTypeNode)node).setName(atts.getValue("name"));
        } else if (localName.equals("AND")) {
            node = new TmfFilterAndNode(null);
            String value = atts.getValue("not");
            if (value != null && value.equalsIgnoreCase(Boolean.TRUE.toString())) {
                ((TmfFilterAndNode)node).setNot(true);
            }
        } else if (localName.equals("OR")) {
            node = new TmfFilterOrNode(null);
            String value = atts.getValue("not");
            if (value != null && value.equalsIgnoreCase(Boolean.TRUE.toString())) {
                ((TmfFilterOrNode)node).setNot(true);
            }
        } else if (localName.equals("CONTAINS")) {
            node = new TmfFilterContainsNode(null);
            String value = atts.getValue("not");
            if (value != null && value.equalsIgnoreCase(Boolean.TRUE.toString())) {
                ((TmfFilterContainsNode)node).setNot(true);
            }
            ((TmfFilterContainsNode)node).setField(atts.getValue("field"));
            ((TmfFilterContainsNode)node).setValue(atts.getValue("value"));
            value = atts.getValue("ignorecase");
            if (value != null && value.equalsIgnoreCase(Boolean.TRUE.toString())) {
                ((TmfFilterContainsNode)node).setIgnoreCase(true);
            }
        } else if (localName.equals("EQUALS")) {
            node = new TmfFilterEqualsNode(null);
            String value = atts.getValue("not");
            if (value != null && value.equalsIgnoreCase(Boolean.TRUE.toString())) {
                ((TmfFilterEqualsNode)node).setNot(true);
            }
            ((TmfFilterEqualsNode)node).setField(atts.getValue("field"));
            ((TmfFilterEqualsNode)node).setValue(atts.getValue("value"));
            value = atts.getValue("ignorecase");
            if (value != null && value.equalsIgnoreCase(Boolean.TRUE.toString())) {
                ((TmfFilterEqualsNode)node).setIgnoreCase(true);
            }
        } else if (localName.equals("MATCHES")) {
            node = new TmfFilterMatchesNode(null);
            String value = atts.getValue("not");
            if (value != null && value.equalsIgnoreCase(Boolean.TRUE.toString())) {
                ((TmfFilterMatchesNode)node).setNot(true);
            }
            ((TmfFilterMatchesNode)node).setField(atts.getValue("field"));
            ((TmfFilterMatchesNode)node).setRegex(atts.getValue("regex"));
        } else if (localName.equals("COMPARE")) {
            node = new TmfFilterCompareNode(null);
            String value = atts.getValue("not");
            if (value != null && value.equalsIgnoreCase(Boolean.TRUE.toString())) {
                ((TmfFilterCompareNode)node).setNot(true);
            }
            ((TmfFilterCompareNode)node).setField(atts.getValue("field"));
            value = atts.getValue("type");
            if (value != null) {
                ((TmfFilterCompareNode)node).setType(TmfFilterCompareNode.Type.valueOf(value));
            }
            if ((value = atts.getValue("result")) != null) {
                if (value.equals(Integer.toString(-1))) {
                    ((TmfFilterCompareNode)node).setResult(-1);
                } else if (value.equals(Integer.toString(1))) {
                    ((TmfFilterCompareNode)node).setResult(1);
                } else {
                    ((TmfFilterCompareNode)node).setResult(0);
                }
            }
            ((TmfFilterCompareNode)node).setValue(atts.getValue("value"));
        }
        this.fFilterTreeStack.push(node);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        ITmfFilterTreeNode node = this.fFilterTreeStack.pop();
        if (this.fFilterTreeStack.isEmpty()) {
            this.fRoot = node;
        } else if (this.fFilterTreeStack.lastElement() instanceof TmfFilterTreeNode && node instanceof TmfFilterTreeNode) {
            ((ITmfFilterTreeNode)this.fFilterTreeStack.lastElement()).addChild(node);
        }
    }
}

