/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.rpmstubby;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.linuxtools.rpmstubby.StubbyGenerator;
import org.eclipse.linuxtools.rpmstubby.StubbyLog;
import org.eclipse.linuxtools.rpmstubby.StubbyPackageModel;
import org.eclipse.linuxtools.rpmstubby.StubbyPlugin;
import org.eclipse.linuxtools.rpmstubby.model.MainPackage;
import org.eclipse.linuxtools.rpmstubby.model.SubPackage;
import org.eclipse.swt.widgets.Shell;

public class SpecfileWriter {
    IPreferenceStore store = StubbyPlugin.getDefault().getPreferenceStore();

    public void write(IFile featureFile) {
        StubbyPackageModel stubbyPackageModel = new StubbyPackageModel(featureFile);
        MainPackage mainPackage = new MainPackage();
        stubbyPackageModel.populatePackageData(mainPackage);
        stubbyPackageModel.populatePackagePreambleData(mainPackage);
        stubbyPackageModel.populateDocFiles(mainPackage);
        List<IFile> includedFeatureFiles = stubbyPackageModel.getIncudedFeatures();
        ArrayList<SubPackage> subPackages = new ArrayList<SubPackage>();
        for (IFile includedFeatureFile : includedFeatureFiles) {
            StubbyPackageModel strubbySubPackageModel = new StubbyPackageModel(includedFeatureFile);
            SubPackage subPackage = new SubPackage();
            strubbySubPackageModel.populatePackageData(subPackage);
            subPackages.add(subPackage);
        }
        if (!stubbyPackageModel.isAllIncludedFeatureFound()) {
            String message = "";
            message = stubbyPackageModel.getMissingFeaturesAsString().indexOf(",") >= 0 ? "Stub out an RPM specfile for '" + mainPackage.getName() + "' fails because '" + stubbyPackageModel.getMissingFeaturesAsString() + "' features were not found.\n\n" + "Please, add these features somewhere in your workspace.\n" : "Stub out an RPM specfile for '" + mainPackage.getName() + "' fails because '" + stubbyPackageModel.getMissingFeaturesAsString() + "' feature was not found.\n\n" + "Please, add these feature somewhere in your workspace.\n";
            if (this.store.getBoolean("StubbyInteractive")) {
                MessageDialog.openError((Shell)StubbyPlugin.getActiveWorkbenchShell(), null, (String)message);
            } else {
                System.err.println(message);
            }
        } else {
            StubbyGenerator generator = new StubbyGenerator(mainPackage, subPackages);
            String packageName = "eclipse-" + generator.getPackageName(mainPackage.getName());
            try {
                if (this.store.getBoolean("StrubbyWithFetchScript")) {
                    generator.writeContent(featureFile.getProject().getName(), String.valueOf(packageName.toLowerCase()) + "-fetch-src.sh", generator.generateFetchScript());
                }
                generator.writeContent(featureFile.getProject().getName(), String.valueOf(packageName.toLowerCase()) + ".spec", generator.generateSpecfile());
            }
            catch (CoreException e) {
                StubbyLog.logError(e);
            }
        }
    }
}

