/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.rpm.ui;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.linuxtools.rpm.core.RPMProject;
import org.eclipse.linuxtools.rpm.ui.IRPMUIConstants;
import org.eclipse.linuxtools.rpm.ui.Messages;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class RPMExportPage
extends WizardPage
implements Listener {
    private Button exportBinary;
    private Button exportSource;
    private RPMProject rpmProject;

    public RPMExportPage(IProject rpmProject) {
        super(Messages.getString("RPMExportPage.Export_SRPM"), Messages.getString("RPMExportPage.Export_SRPM_from_project"), null);
        this.setDescription(Messages.getString("RPMExportPage.Select_project_export"));
        try {
            this.rpmProject = new RPMProject(rpmProject);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        this.setPageComplete(true);
    }

    public RPMProject getSelectedRPMProject() {
        return this.rpmProject;
    }

    public IRPMUIConstants.BuildType getExportType() {
        IRPMUIConstants.BuildType exportType = IRPMUIConstants.BuildType.NONE;
        if (this.exportBinary.getSelection() && this.exportSource.getSelection()) {
            exportType = IRPMUIConstants.BuildType.ALL;
        } else if (this.exportBinary.getSelection()) {
            exportType = IRPMUIConstants.BuildType.BINARY;
        } else if (this.exportSource.getSelection()) {
            exportType = IRPMUIConstants.BuildType.SOURCE;
        }
        return exportType;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(256));
        this.setControl((Control)composite);
        if (this.rpmProject != null) {
            this.createExportTypeControls(composite);
            this.setPageComplete(false);
        } else {
            this.createErrorControls(composite);
            this.setPageComplete(true);
        }
    }

    private void createErrorControls(Composite parent) {
        Label label = new Label(parent, 0x1000000);
        label.setText(Messages.getString("RPMExportPage.0"));
    }

    private void createExportTypeControls(Composite parent) {
        Group group = new Group(parent, 0);
        group.setLayout((Layout)new GridLayout());
        group.setText(Messages.getString("RPMExportPage.Composite_Export_Type"));
        group.setLayoutData((Object)new GridData(768));
        this.exportBinary = new Button((Composite)group, 32);
        this.exportBinary.setText(Messages.getString("RPMExportPage.Export_Binary"));
        this.exportBinary.setSelection(true);
        this.exportBinary.setToolTipText(Messages.getString("RPMExportPage.toolTip_Export_Binary"));
        this.exportSource = new Button((Composite)group, 32);
        this.exportSource.setText(Messages.getString("RPMExportPage.Export_Source"));
        this.exportSource.setSelection(true);
        this.exportSource.setToolTipText(Messages.getString("RPMExportPage.toolTip_Export_Source"));
        SelectionListener listener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                RPMExportPage.this.handleEvent(null);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                RPMExportPage.this.handleEvent(null);
            }
        };
        this.exportBinary.addSelectionListener(listener);
        this.exportSource.addSelectionListener(listener);
    }

    public boolean canFinish() {
        if (this.rpmProject != null && !this.exportBinary.getSelection() && !this.exportSource.getSelection()) {
            this.setErrorMessage(Messages.getString("RPMExportPage.Select_export_type"));
            return false;
        }
        this.setDescription(null);
        this.setErrorMessage(null);
        return true;
    }

    public void handleEvent(Event e) {
        this.setPageComplete(this.canFinish());
    }
}

