/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.rpm.core.utils;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class Utils {
    public static BufferedInputStream runCommandToInputStream(String ... command) throws IOException {
        BufferedInputStream in = null;
        ProcessBuilder pBuilder = new ProcessBuilder(command);
        pBuilder = pBuilder.redirectErrorStream(true);
        Process child = pBuilder.start();
        in = new BufferedInputStream(child.getInputStream());
        return in;
    }

    public static void runCommand(final OutputStream outStream, String ... command) throws IOException {
        ProcessBuilder pBuilder = new ProcessBuilder(command);
        pBuilder = pBuilder.redirectErrorStream(true);
        Process child = pBuilder.start();
        final BufferedInputStream in = new BufferedInputStream(child.getInputStream());
        Job readinJob = new Job(""){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    int i;
                    while ((i = in.read()) != -1) {
                        outStream.write(i);
                    }
                    outStream.flush();
                    outStream.close();
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        readinJob.schedule();
        try {
            child.waitFor();
            readinJob.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static String runCommandToString(String ... command) throws IOException {
        BufferedInputStream in = Utils.runCommandToInputStream(command);
        return Utils.inputStreamToString(in);
    }

    public static String inputStreamToString(InputStream stream) throws IOException {
        int c;
        StringBuilder retStr = new StringBuilder();
        while ((c = stream.read()) != -1) {
            retStr.append((char)c);
        }
        stream.close();
        return retStr.toString();
    }

    public static boolean fileExist(String cmdPath) {
        return new File(cmdPath).exists();
    }

    public static void copyFile(File in, File out) throws IOException {
        FileChannel inChannel = new FileInputStream(in).getChannel();
        FileChannel outChannel = new FileOutputStream(out).getChannel();
        try {
            inChannel.transferTo(0L, inChannel.size(), outChannel);
        }
        finally {
            if (inChannel != null) {
                inChannel.close();
            }
            if (outChannel != null) {
                outChannel.close();
            }
        }
    }
}

