/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng.ui.views.project.dialogs;

import java.net.URI;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.linuxtools.lttng.ui.LTTngUiPlugin;
import org.eclipse.linuxtools.lttng.ui.TraceHelper;
import org.eclipse.linuxtools.lttng.ui.views.project.dialogs.Messages;
import org.eclipse.linuxtools.lttng.ui.views.project.dialogs.NewProjectMainWizardPage;
import org.eclipse.linuxtools.lttng.ui.views.project.dialogs.TraceLibraryPathWizardPage;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public class NewProjectWizard
extends BasicNewResourceWizard {
    private String fTtitle;
    private String fDescription;
    protected NewProjectMainWizardPage fMainPage;
    protected String fProjectName;
    protected URI fProjectLocation;
    protected IConfigurationElement fConfigElement;
    protected IProject fProject;
    private TraceLibraryPathWizardPage traceLibraryPathPage;

    public NewProjectWizard() {
        this(Messages.NewProjectWizard_Title, Messages.NewProjectWizard_Description);
    }

    public NewProjectWizard(String title, String desc) {
        this.setDialogSettings(LTTngUiPlugin.getDefault().getDialogSettings());
        this.setNeedsProgressMonitor(true);
        this.setForcePreviousAndNextButtons(true);
        this.setWindowTitle(title);
        this.fTtitle = title;
        this.fDescription = desc;
    }

    public void addPages() {
        this.fMainPage = new NewProjectMainWizardPage(Messages.NewProjectWizard_Title);
        this.fMainPage.setTitle(this.fTtitle);
        this.fMainPage.setDescription(this.fDescription);
        this.addPage((IWizardPage)this.fMainPage);
        this.traceLibraryPathPage = new TraceLibraryPathWizardPage(Messages.NewProjectWizard_Title);
        this.traceLibraryPathPage.setTitle(Messages.TraceLibraryPathWizardPage_Title);
        this.traceLibraryPathPage.setDescription(Messages.TraceLibraryPathWizardPage_Description);
        this.addPage((IWizardPage)this.traceLibraryPathPage);
    }

    public boolean performCancel() {
        return true;
    }

    public boolean performFinish() {
        this.fProjectName = this.fMainPage.getProjectName();
        this.fProjectLocation = this.fMainPage.useDefaults() ? null : this.fMainPage.getLocationURI();
        this.fProject = this.createProject(this.fProjectName, this.fProjectLocation, (IProgressMonitor)new NullProgressMonitor());
        String traceLibraryPath = this.traceLibraryPathPage.getPath();
        if (traceLibraryPath != null) {
            return TraceHelper.setProjectPreference(this.fProject, "traceLibraryPath", traceLibraryPath);
        }
        return true;
    }

    public IProject getProject() {
        return this.fProject;
    }

    private IProject createProject(String projectName, URI projectLocation, IProgressMonitor monitor) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        IProject project = root.getProject(projectName);
        try {
            IProjectDescription description;
            if (!project.exists()) {
                description = workspace.newProjectDescription(project.getName());
                if (projectLocation != null) {
                    description.setLocationURI(projectLocation);
                }
                project.create(description, monitor);
            }
            if (!project.isOpen()) {
                project.open(monitor);
            }
            description = project.getDescription();
            description.setNatureIds(new String[]{"org.eclipse.linuxtools.lttng.ui.views.project.LTTngProjectNature"});
            project.setDescription(description, null);
            IFolder folder = project.getFolder("Traces");
            if (!folder.exists()) {
                folder.create(true, true, null);
            }
            if (!(folder = project.getFolder("Experiments")).exists()) {
                folder.create(true, true, null);
            }
            return project;
        }
        catch (CoreException e) {
            e.printStackTrace();
            return null;
        }
    }
}

