/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.lttng.ui.views.histogram;

import org.eclipse.linuxtools.lttng.ui.views.histogram.HistogramCanvasPaintListener;
import org.eclipse.linuxtools.lttng.ui.views.histogram.HistogramContent;
import org.eclipse.linuxtools.lttng.ui.views.histogram.ParentHistogramCanvas;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;

public class ParentHistogramCanvasPaintListener
extends HistogramCanvasPaintListener {
    private static ParentHistogramCanvas parentCanvas = null;
    private final String DATA_KEY = "double-buffer-image";

    public ParentHistogramCanvasPaintListener(ParentHistogramCanvas newCanvas) {
        parentCanvas = newCanvas;
    }

    @Override
    public synchronized void drawHistogram(GC imageGC, Image image) {
        HistogramContent tmpContent = parentCanvas.getHistogramContent();
        int tmpBarWidth = tmpContent.getBarsWidth();
        int closestPowerToCanvas = (int)Math.pow(2.0, Math.floor(Math.log(image.getBounds().width) / Math.log(2.0)));
        this.clearDrawingSection(imageGC, image, parentCanvas);
        this.recalculateHeightIfCanvasSizeChanged();
        double factor = (double)image.getBounds().width / (double)closestPowerToCanvas;
        int intervalDifference = tmpContent.getNbElement() / closestPowerToCanvas * tmpBarWidth;
        int posInPower = 0;
        int widthFilled = 0;
        imageGC.setBackground(new Color(imageGC.getDevice(), 74, 112, 139));
        int itemWidth = 0;
        int thisElementHeight = 0;
        int contentPos = 0;
        while (contentPos < tmpContent.getReadyUpToPosition()) {
            itemWidth = (int)(Math.ceil((double)(posInPower + 1) * factor) - Math.ceil((double)posInPower * factor));
            itemWidth *= tmpBarWidth;
            thisElementHeight = 0;
            int concatPos = 0;
            while (concatPos < intervalDifference) {
                if (contentPos + concatPos < tmpContent.getReadyUpToPosition()) {
                    thisElementHeight += tmpContent.getElementByIndex((int)(contentPos + concatPos)).intervalHeight;
                }
                ++concatPos;
            }
            imageGC.fillRectangle(widthFilled, thisElementHeight > image.getBounds().height ? 0 : image.getBounds().height - thisElementHeight, itemWidth, thisElementHeight);
            widthFilled += itemWidth;
            ++posInPower;
            contentPos += intervalDifference;
        }
    }

    protected void recalculateHeightIfCanvasSizeChanged() {
        HistogramContent tmpContent = parentCanvas.getHistogramContent();
        int exp = (int)Math.floor(Math.log(tmpContent.getCanvasWindowSize()) / Math.log(2.0));
        int contentSize = (int)Math.pow(2.0, exp);
        double maxBarsDiffFactor = (double)tmpContent.getNbElement() / (double)contentSize;
        if (Math.abs(maxBarsDiffFactor - tmpContent.getMaxDifferenceToAverageFactor()) > 0.001) {
            tmpContent.setMaxDifferenceToAverageFactor(maxBarsDiffFactor);
            tmpContent.recalculateHeightFactor();
            tmpContent.recalculateEventHeight();
        }
    }

    @Override
    public void paintControl(PaintEvent event) {
        if (ParentHistogramCanvasPaintListener.parentCanvas.getSize().x > 0 && ParentHistogramCanvasPaintListener.parentCanvas.getSize().y > 0) {
            Image image = (Image)parentCanvas.getData("double-buffer-image");
            if (image == null || image.getBounds().width != ParentHistogramCanvasPaintListener.parentCanvas.getClientArea().width || image.getBounds().height != ParentHistogramCanvasPaintListener.parentCanvas.getClientArea().height) {
                image = new Image((Device)event.display, ParentHistogramCanvasPaintListener.parentCanvas.getClientArea().width, ParentHistogramCanvasPaintListener.parentCanvas.getClientArea().height);
                parentCanvas.setData("double-buffer-image", image);
            }
            GC imageGC = new GC((Drawable)image);
            if (parentCanvas.getHistogramContent() != null && parentCanvas.getHistogramContent().getReadyUpToPosition() != 0) {
                this.drawHistogram(imageGC, image);
                Image img = new Image(image.getDevice(), image, 0);
                GC imgGC = new GC((Drawable)img);
                if (parentCanvas.getCurrentWindow() != null && parentCanvas.getCurrentWindow().getSelectedWindowVisible()) {
                    this.drawSelectedWindow(imgGC, img);
                }
                event.gc.drawImage(img, 0, 0);
                imgGC.dispose();
                img.dispose();
            }
            imageGC.dispose();
        }
    }

    public void drawSelectedWindow(GC imageGC, Image image) {
        int positionCenter = parentCanvas.getCurrentWindow().getWindowXPositionCenter();
        int positionLeft = parentCanvas.getCurrentWindow().getWindowXPositionLeft();
        int positionRight = parentCanvas.getCurrentWindow().getWindowXPositionRight();
        int imageHeight = image.getBounds().height;
        int imageHalfHeight = image.getBounds().height / 2;
        imageGC.setForeground(new Color(imageGC.getDevice(), 255, 128, 0));
        imageGC.setLineWidth(1);
        imageGC.setLineStyle(1);
        if (imageHeight > 40) {
            imageGC.drawLine(positionCenter - 0, imageHalfHeight - 20, positionCenter - 0, imageHalfHeight + 20);
        }
        if (positionRight - positionLeft > 40) {
            imageGC.drawLine(positionCenter - 20, imageHalfHeight - 0, positionCenter + 20, imageHalfHeight - 0);
        }
        imageGC.setLineWidth(1);
        imageGC.setLineStyle(1);
        imageGC.drawRoundRectangle(positionLeft + 0, 0, positionRight - positionLeft - 0, imageHeight - 1, 15, 15);
        imageGC.setBackground(new Color(imageGC.getDevice(), 255, 128, 0));
        imageGC.setAlpha(25);
        imageGC.fillRoundRectangle(positionLeft + 1, 1, positionRight - positionLeft - 0 - 1, imageHeight - 0 - 1, 15, 15);
    }
}

