/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.cdt.autotools.ui.editors.automake;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.linuxtools.cdt.autotools.core.AutotoolsPlugin;
import org.eclipse.linuxtools.internal.cdt.autotools.ui.editors.automake.AutomakeDocumentProvider;
import org.eclipse.linuxtools.internal.cdt.autotools.ui.editors.automake.AutomakeEditorFactory;
import org.eclipse.linuxtools.internal.cdt.autotools.ui.editors.automake.AutomakeErrorHandler;
import org.eclipse.linuxtools.internal.cdt.autotools.ui.editors.automake.AutomakefileContentOutlinePage;
import org.eclipse.linuxtools.internal.cdt.autotools.ui.editors.automake.AutomakefileSourceConfiguration;
import org.eclipse.linuxtools.internal.cdt.autotools.ui.editors.automake.IMakefile;
import org.eclipse.linuxtools.internal.cdt.autotools.ui.editors.automake.MakefileEditor;
import org.eclipse.linuxtools.internal.cdt.autotools.ui.preferences.AutomakeEditorPreferencePage;
import org.eclipse.linuxtools.internal.cdt.autotools.ui.preferences.AutotoolsEditorPreferenceConstants;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.ui.texteditor.DefaultRangeIndicator;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class AutomakeEditor
extends MakefileEditor {
    protected AutomakefileContentOutlinePage page;
    private AutomakefileSourceConfiguration sourceViewerConfiguration;
    private AutomakeErrorHandler errorHandler;
    private static AutomakeEditor fgInstance;
    private IEditorInput input;

    public AutomakeEditor() {
        fgInstance = this;
    }

    public static AutomakeEditor getDefault() {
        return fgInstance;
    }

    protected void doSetInput(IEditorInput newInput) throws CoreException {
        super.doSetInput(newInput);
        this.input = newInput;
        this.getOutlinePage().setInput(this.input);
    }

    protected void initializeEditor() {
        this.setRangeIndicator((Annotation)new DefaultRangeIndicator());
        this.setEditorContextMenuId("#MakefileEditorContext");
        this.setRulerContextMenuId("#MakefileRulerContext");
        this.setDocumentProvider(AutomakeEditorFactory.getDefault().getAutomakefileDocumentProvider());
        IPreferenceStore[] stores = new IPreferenceStore[]{AutotoolsPlugin.getDefault().getPreferenceStore(), EditorsUI.getPreferenceStore()};
        ChainedPreferenceStore chainedStore = new ChainedPreferenceStore(stores);
        this.setPreferenceStore((IPreferenceStore)chainedStore);
        this.sourceViewerConfiguration = new AutomakefileSourceConfiguration((IPreferenceStore)chainedStore, this);
        this.setSourceViewerConfiguration((SourceViewerConfiguration)this.sourceViewerConfiguration);
        AutotoolsEditorPreferenceConstants.initializeDefaultValues(stores[0]);
        AutomakeEditorPreferencePage.initDefaults(stores[0]);
        this.configureInsertMode(SMART_INSERT, false);
        this.setInsertMode(INSERT);
    }

    public AutomakeDocumentProvider getAutomakefileDocumentProvider() {
        return (AutomakeDocumentProvider)AutomakeEditorFactory.getDefault().getAutomakefileDocumentProvider();
    }

    public AutomakefileContentOutlinePage getAutomakeOutlinePage() {
        if (this.page == null) {
            this.page = new AutomakefileContentOutlinePage(this);
            this.page.addSelectionChangedListener(this);
            this.page.setInput(this.getEditorInput());
        }
        return this.page;
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
    }

    public Object getAdapter(Class key) {
        if (key.equals(IContentOutlinePage.class)) {
            return this.getAutomakeOutlinePage();
        }
        return super.getAdapter(key);
    }

    public AutomakefileSourceConfiguration getAutomakeSourceViewerConfiguration() {
        return this.sourceViewerConfiguration;
    }

    protected void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        super.handlePreferenceStoreChanged(event);
    }

    public IMakefile getMakefile() {
        return this.getAutomakefileDocumentProvider().getWorkingCopy(this.getEditorInput());
    }

    public ISourceViewer getAutomakeSourceViewer() {
        return this.getSourceViewer();
    }

    public AutomakeErrorHandler getAutomakeErrorHandler() {
        return this.errorHandler;
    }
}

