/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.binutils.link2source;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.cdt.debug.core.CDebugCorePlugin;
import org.eclipse.cdt.debug.core.sourcelookup.MappingSourceContainer;
import org.eclipse.cdt.debug.internal.core.sourcelookup.CSourceLookupDirector;
import org.eclipse.cdt.debug.internal.core.sourcelookup.MapEntrySourceContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.sourcelookup.AbstractSourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.debug.ui.sourcelookup.CommonSourceNotFoundEditor;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.linuxtools.binutils.link2source.STCSourceNotFoundEditorInput;
import org.eclipse.linuxtools.binutils.link2source.STLink2SourceSupport;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class STCSourceNotFoundEditor
extends CommonSourceNotFoundEditor {
    private static final String foundMappingsContainerName = "Found Mappings";
    private Button locateFileButton;
    private Button editLookupButton;

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
    }

    private IPath getMissingFile() {
        IEditorInput i = this.getEditorInput();
        if (i instanceof STCSourceNotFoundEditorInput) {
            STCSourceNotFoundEditorInput input = (STCSourceNotFoundEditorInput)i;
            return input.getSourcePath();
        }
        return null;
    }

    private int getLineNumber() {
        IEditorInput i = this.getEditorInput();
        if (i instanceof STCSourceNotFoundEditorInput) {
            STCSourceNotFoundEditorInput input = (STCSourceNotFoundEditorInput)i;
            return input.getLineNumber();
        }
        return -1;
    }

    private IProject getProject() {
        IEditorInput i = this.getEditorInput();
        if (i instanceof STCSourceNotFoundEditorInput) {
            STCSourceNotFoundEditorInput input = (STCSourceNotFoundEditorInput)i;
            return input.getProject();
        }
        return null;
    }

    public void setInput(IEditorInput input) {
        super.setInput(input);
        this.syncButtons();
    }

    private boolean isValidMissingFile() {
        IPath p = this.getMissingFile();
        boolean v = p != null && p.toString().length() > 0;
        return v;
    }

    private void syncButtons() {
        boolean v = this.isValidMissingFile();
        if (this.locateFileButton != null) {
            this.locateFileButton.setVisible(v);
        }
        if (this.editLookupButton != null) {
            this.editLookupButton.setVisible(v);
        }
    }

    protected String getText() {
        boolean v = this.isValidMissingFile();
        if (v) {
            return "Can't find a source file at \"" + this.getMissingFile() + "\" \n";
        }
        return "No source available for \"\"";
    }

    protected void createButtons(Composite parent) {
        this.locateFileButton = new Button(parent, 8);
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = false;
        data.grabExcessVerticalSpace = false;
        this.locateFileButton.setLayoutData((Object)data);
        this.locateFileButton.setText("Locate File...");
        this.locateFileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                STCSourceNotFoundEditor.this.locateFile();
            }
        });
        this.editLookupButton = new Button(parent, 8);
        data = new GridData();
        data.grabExcessHorizontalSpace = false;
        data.grabExcessVerticalSpace = false;
        this.editLookupButton.setLayoutData((Object)data);
        this.editLookupButton.setText("Edit Source Lookup Path...");
        this.editLookupButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                STCSourceNotFoundEditor.this.editSourceLookupPath();
            }
        });
        this.syncButtons();
    }

    protected void editSourceLookupPath() {
        PreferenceDialog d = PreferencesUtil.createPreferenceDialogOn(null, (String)"org.eclipse.cdt.debug.ui.SourcePreferencePage", null, null);
        if (d.open() == 0) {
            this.closeEditor();
            this.openSourceFileAtLocation(this.getProject(), this.getMissingFile(), this.getLineNumber());
        }
    }

    private void addSourceMappingToDirector(IPath missingPath, IPath newSourcePath, AbstractSourceLookupDirector director) throws CoreException {
        ArrayList<ISourceContainer> containerList = new ArrayList<ISourceContainer>(Arrays.asList(director.getSourceContainers()));
        boolean hasFoundMappings = false;
        MappingSourceContainer foundMappings = null;
        Iterator<ISourceContainer> iter = containerList.iterator();
        while (iter.hasNext() && !hasFoundMappings) {
            ISourceContainer container = iter.next();
            if (!(container instanceof MappingSourceContainer) || !(hasFoundMappings = container.getName().equals(foundMappingsContainerName))) continue;
            foundMappings = (MappingSourceContainer)container;
        }
        if (!hasFoundMappings) {
            foundMappings = new MappingSourceContainer(foundMappingsContainerName);
            foundMappings.init((ISourceLookupDirector)director);
            containerList.add((ISourceContainer)foundMappings);
        }
        foundMappings.addMapEntry(new MapEntrySourceContainer(missingPath, newSourcePath));
        director.setSourceContainers(containerList.toArray(new ISourceContainer[containerList.size()]));
    }

    private void addSourceMappingToCommon(IPath missingPath, IPath newSourcePath) throws CoreException {
        CSourceLookupDirector director = CDebugCorePlugin.getDefault().getCommonSourceLookupDirector();
        this.addSourceMappingToDirector(missingPath, newSourcePath, (AbstractSourceLookupDirector)director);
        CDebugCorePlugin.getDefault().savePluginPreferences();
    }

    protected void locateFile() {
        Path newPath;
        FileDialog dialog = new FileDialog(this.getEditorSite().getShell(), 0);
        IPath missingPath = this.getMissingFile();
        dialog.setFilterNames(new String[]{"Missing Source File"});
        dialog.setFilterExtensions(new String[]{"*." + missingPath.getFileExtension()});
        String res = dialog.open();
        if (res != null && (newPath = new Path(res)).lastSegment().equalsIgnoreCase(missingPath.lastSegment())) {
            if (missingPath.segmentCount() > 1) {
                int missingPathSegCount = missingPath.segmentCount() - 2;
                int newPathSegCount = newPath.segmentCount() - 2;
                while (missingPathSegCount >= 0 && newPathSegCount >= 0) {
                    if (!newPath.segment(newPathSegCount).equalsIgnoreCase(missingPath.segment(missingPathSegCount))) break;
                    --newPathSegCount;
                    --missingPathSegCount;
                }
                IPath compPath = missingPath.removeLastSegments(missingPath.segmentCount() - missingPathSegCount - 1);
                IPath newSourcePath = newPath.removeLastSegments(newPath.segmentCount() - newPathSegCount - 1);
                try {
                    this.addSourceMappingToCommon(compPath, newSourcePath);
                }
                catch (CoreException coreException) {}
            }
            this.openSourceFileAtLocation(this.getProject(), (IPath)newPath, this.getLineNumber());
            this.closeEditor();
        }
    }

    protected void openSourceFileAtLocation(IProject project, IPath sourceLoc, int lineNumber) {
        STLink2SourceSupport.sharedInstance.openSourceFileAtLocation(project, sourceLoc, lineNumber);
    }
}

