/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.report.internal.html;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jacoco.core.analysis.ICoverageNode;
import org.jacoco.report.IReportVisitor;
import org.jacoco.report.ISourceFileLocator;
import org.jacoco.report.ReportOutputFolder;
import org.jacoco.report.internal.html.HTMLElement;
import org.jacoco.report.internal.html.IHTMLReportContext;
import org.jacoco.report.internal.html.NodePage;
import org.jacoco.report.internal.html.PackagePage;
import org.jacoco.report.internal.html.ReportPage;

public class GroupPage
extends NodePage {
    private final List<NodePage> children = new ArrayList<NodePage>();

    public GroupPage(ICoverageNode node, ReportPage parent, ReportOutputFolder folder, IHTMLReportContext context) {
        super(node, parent, folder, context);
    }

    public IReportVisitor visitChild(ICoverageNode node) {
        NodePage child;
        switch (node.getElementType()) {
            case PACKAGE: {
                child = new PackagePage(node, this, this.folder.subFolder(node.getName().replace('/', '.')), this.context);
                break;
            }
            default: {
                child = new GroupPage(node, this, this.folder.subFolder(node.getName()), this.context);
            }
        }
        this.children.add(child);
        return child;
    }

    public void visitEnd(ISourceFileLocator sourceFileLocator) throws IOException {
        super.visitEnd(sourceFileLocator);
        this.children.clear();
    }

    protected void headExtra(HTMLElement head) throws IOException {
        super.headExtra(head);
        head.script("text/javascript", this.context.getResources().getLink(this.folder, "sort.js"));
    }

    protected String getOnload() {
        return "initialSort(['breadcrumb', 'coveragetable'])";
    }

    protected void content(HTMLElement body) throws IOException {
        this.context.getTable().render(body, this.children, this.getNode(), this.context.getResources(), this.folder);
    }

    protected String getFileName() {
        return "index.html";
    }
}

